/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.messages;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.queryablestate.network.messages.MessageBody;
import org.apache.flink.queryablestate.network.messages.MessageDeserializer;
import org.apache.flink.util.Preconditions;

@Internal
public class KvStateResponse
extends MessageBody {
    private final byte[] content;

    public KvStateResponse(byte[] content) {
        this.content = (byte[])Preconditions.checkNotNull((Object)content);
    }

    public byte[] getContent() {
        return this.content;
    }

    @Override
    public byte[] serialize() {
        int size = 4 + this.content.length;
        return ByteBuffer.allocate(size).putInt(this.content.length).put(this.content).array();
    }

    public static class KvStateResponseDeserializer
    implements MessageDeserializer<KvStateResponse> {
        @Override
        public KvStateResponse deserializeMessage(ByteBuf buf) {
            int length = buf.readInt();
            Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Negative length for state content. This indicates a serialization error.");
            byte[] content = new byte[length];
            buf.readBytes(content);
            return new KvStateResponse(content);
        }
    }
}

