/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.queryablestate.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import java.nio.channels.ClosedChannelException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.queryablestate.network.ClientHandlerCallback;
import org.apache.flink.queryablestate.network.messages.MessageBody;
import org.apache.flink.queryablestate.network.messages.MessageSerializer;
import org.apache.flink.queryablestate.network.messages.MessageType;
import org.apache.flink.queryablestate.network.messages.RequestFailure;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ClientHandler<REQ extends MessageBody, RESP extends MessageBody>
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ClientHandler.class);
    private final String clientName;
    private final MessageSerializer<REQ, RESP> serializer;
    private final ClientHandlerCallback<RESP> callback;

    public ClientHandler(String clientName, MessageSerializer<REQ, RESP> serializer, ClientHandlerCallback<RESP> callback) {
        this.clientName = (String)Preconditions.checkNotNull((Object)clientName);
        this.serializer = (MessageSerializer)Preconditions.checkNotNull(serializer);
        this.callback = (ClientHandlerCallback)Preconditions.checkNotNull(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block10: {
            try {
                ByteBuf buf = (ByteBuf)msg;
                MessageType msgType = MessageSerializer.deserializeHeader(buf);
                if (msgType == MessageType.REQUEST_RESULT) {
                    long requestId = MessageSerializer.getRequestId(buf);
                    RESP result = this.serializer.deserializeResponse(buf);
                    this.callback.onRequestResult(requestId, result);
                    break block10;
                }
                if (msgType == MessageType.REQUEST_FAILURE) {
                    RequestFailure failure = MessageSerializer.deserializeRequestFailure(buf);
                    this.callback.onRequestFailure(failure.getRequestId(), failure.getCause());
                    break block10;
                }
                if (msgType == MessageType.SERVER_FAILURE) {
                    throw MessageSerializer.deserializeServerFailure(buf);
                }
                throw new IllegalStateException("Unexpected response type '" + (Object)((Object)msgType) + "'");
            }
            catch (Throwable t1) {
                try {
                    this.callback.onFailure(t1);
                }
                catch (Throwable t2) {
                    LOG.error("Failed to notify callback about failure", t2);
                }
            }
            finally {
                ReferenceCountUtil.release((Object)msg);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        try {
            this.callback.onFailure(cause);
        }
        catch (Throwable t) {
            LOG.error("Failed to notify callback about failure", t);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            this.callback.onFailure(new ClosedChannelException());
        }
        catch (Throwable t) {
            LOG.error("Failed to notify callback about failure", t);
        }
    }
}

