/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.client.deployment.application.JobStatusPollingUtils;
import org.apache.flink.client.deployment.application.UnsuccessfulExecutionException;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationRequestGateway;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

@Internal
public class EmbeddedJobClient
implements JobClient,
CoordinationRequestGateway {
    private final JobID jobId;
    private final DispatcherGateway dispatcherGateway;
    private final ScheduledExecutor retryExecutor;
    private final Time timeout;
    private final ClassLoader classLoader;

    public EmbeddedJobClient(JobID jobId, DispatcherGateway dispatcherGateway, ScheduledExecutor retryExecutor, Time rpcTimeout, ClassLoader classLoader) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.dispatcherGateway = (DispatcherGateway)Preconditions.checkNotNull((Object)dispatcherGateway);
        this.retryExecutor = (ScheduledExecutor)Preconditions.checkNotNull((Object)retryExecutor);
        this.timeout = (Time)Preconditions.checkNotNull((Object)rpcTimeout);
        this.classLoader = classLoader;
    }

    public JobID getJobID() {
        return this.jobId;
    }

    public CompletableFuture<JobStatus> getJobStatus() {
        return this.dispatcherGateway.requestJobStatus(this.jobId, this.timeout);
    }

    public CompletableFuture<Void> cancel() {
        return this.dispatcherGateway.cancelJob(this.jobId, this.timeout).thenApply(ignores -> null);
    }

    public CompletableFuture<String> stopWithSavepoint(boolean advanceToEndOfEventTime, @Nullable String savepointDirectory) {
        return this.dispatcherGateway.stopWithSavepoint(this.jobId, savepointDirectory, advanceToEndOfEventTime, this.timeout);
    }

    public CompletableFuture<String> triggerSavepoint(@Nullable String savepointDirectory) {
        return this.dispatcherGateway.triggerSavepoint(this.jobId, savepointDirectory, false, this.timeout);
    }

    public CompletableFuture<Map<String, Object>> getAccumulators() {
        Preconditions.checkNotNull((Object)this.classLoader);
        return ((CompletableFuture)this.dispatcherGateway.requestJob(this.jobId, this.timeout).thenApply(ArchivedExecutionGraph::getAccumulatorsSerialized)).thenApply(accumulators -> {
            try {
                return AccumulatorHelper.deserializeAndUnwrapAccumulators((Map)accumulators, (ClassLoader)this.classLoader);
            }
            catch (Exception e) {
                throw new CompletionException("Cannot deserialize and unwrap accumulators properly.", e);
            }
        });
    }

    public CompletableFuture<JobExecutionResult> getJobExecutionResult() {
        Preconditions.checkNotNull((Object)this.classLoader);
        Time retryPeriod = Time.milliseconds((long)100L);
        return JobStatusPollingUtils.getJobResult(this.dispatcherGateway, this.jobId, this.retryExecutor, this.timeout, retryPeriod).thenApply(jobResult -> {
            try {
                return jobResult.toJobExecutionResult(this.classLoader);
            }
            catch (Throwable t) {
                throw new CompletionException((Throwable)((Object)UnsuccessfulExecutionException.fromJobResult(jobResult, this.classLoader)));
            }
        });
    }

    public CompletableFuture<CoordinationResponse> sendCoordinationRequest(OperatorID operatorId, CoordinationRequest request) {
        try {
            SerializedValue serializedRequest = new SerializedValue((Object)request);
            return this.dispatcherGateway.deliverCoordinationRequestToCoordinator(this.jobId, operatorId, serializedRequest, this.timeout);
        }
        catch (IOException e) {
            return FutureUtils.completedExceptionally((Throwable)e);
        }
    }
}

