/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.common.util;

import com.huawei.it.eip.ump.common.exception.UmpException;
import com.huawei.it.eip.ump.common.message.Message;
import com.huawei.it.eip.ump.common.util.CommonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.rocketmq.common.message.MessageExt;

public class ConvertUtils {
    public static Message convertMqMessageToUmpMessage(MessageExt messageExt) throws UmpException {
        Message message = new Message();
        Map<String, String> map = ConvertUtils.cleanSysTag(CommonUtils.mapCoppy(messageExt.getProperties()));
        message.setProperties(map);
        message.setMessageId(map.get("message_id"));
        message.setBusinessId(map.get("business_id"));
        message.setTags(messageExt.getTags());
        message.setBornTimestamp(messageExt.getBornTimestamp());
        message.setStoreTimestamp(messageExt.getStoreTimestamp());
        String umpMessageFlag = map.get("ump_message_flag");
        int umpSysFlag = umpMessageFlag == null ? 0 : Integer.parseInt(umpMessageFlag);
        try {
            byte[] body = messageExt.getBody();
            if (body != null && (umpSysFlag & 2) == 2) {
                body = CommonUtils.uncompress(body);
            }
            message.setBody(body);
        }
        catch (Exception e) {
            throw new UmpException(e);
        }
        return message;
    }

    private static Map<String, String> cleanSysTag(Map<String, String> properties) {
        String[] sysTags;
        for (String sysTag : sysTags = new String[]{"KEYS", "TAGS", "WAIT", "DELAY", "RETRY_TOPIC", "REAL_TOPIC", "REAL_QID", "TRAN_MSG", "PGROUP", "MIN_OFFSET", "MAX_OFFSET", "BUYER_ID", "ORIGIN_MESSAGE_ID", "TRANSFER_FLAG", "CORRECTION_FLAG", "MQ2_FLAG", "RECONSUME_TIME"}) {
            properties.remove(sysTag);
        }
        return properties;
    }

    public static List<Message> convertMessageList(List<MessageExt> messageExtList) throws UmpException {
        ArrayList<Message> msgList = new ArrayList<Message>();
        for (MessageExt msgExt : messageExtList) {
            msgList.add(ConvertUtils.convertMqMessageToUmpMessage(msgExt));
        }
        return msgList;
    }
}

