/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.common.util;

import com.alibaba.fastjson.JSON;
import com.huawei.it.eip.ump.common.log.LogOperateType;
import com.huawei.it.eip.ump.common.log.MessageLogBo;
import com.huawei.it.eip.ump.common.message.UmpRequestHeader;
import com.huawei.it.eip.ump.common.util.CommonUtils;
import com.huawei.it.eip.ump.common.util.DateUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.Map;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;

public class LogUtils {
    private static MessageLogBo toLogBo(Map<String, String> userProperties, String mqMessageId, String topic, LogOperateType logOperateType, String connectorIp, int messageSize, boolean msgFlag) {
        MessageLogBo messageLogBo = new MessageLogBo();
        messageLogBo.setCreateTime(DateUtil.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss.SSS"));
        messageLogBo.setTopicName(topic);
        messageLogBo.setAppId(userProperties.get("app_id"));
        messageLogBo.setBusinessId(userProperties.get("business_id"));
        messageLogBo.setDc(userProperties.get("sys_dc"));
        messageLogBo.setZone(userProperties.get("sys_zone"));
        messageLogBo.setClientIp(userProperties.get("client_ip_address"));
        messageLogBo.setMessageId(userProperties.get("message_id"));
        messageLogBo.setTags(userProperties.get("TAGS"));
        messageLogBo.setLogOperateType(logOperateType);
        messageLogBo.setConnectorIp(connectorIp);
        messageLogBo.setMessageSize(messageSize);
        messageLogBo.setMessageFlag(msgFlag);
        messageLogBo.setMqMessageId(mqMessageId);
        messageLogBo.setMessageGroupId(userProperties.get("ump_message_group_id"));
        messageLogBo.setConsumerGroup(userProperties.get("consumer_group"));
        messageLogBo.setConsumerInstance(userProperties.get("consumer_instance"));
        messageLogBo.setMessageModel(userProperties.get("message_model"));
        messageLogBo.setSecurityZone(userProperties.get("security_zone"));
        messageLogBo.setMsgBornTime(userProperties.get("msg_born_time"));
        return messageLogBo;
    }

    public static MessageLogBo toLogBo(Map<String, String> userProperties, String mqMessageId, String topic, LogOperateType logOperateType, String connectorIp, int messageSize) {
        return LogUtils.toLogBo(userProperties, mqMessageId, topic, logOperateType, connectorIp, messageSize, false);
    }

    public static Message toLogMessage(MessageLogBo messageLogBo) {
        Message logMessage = new Message();
        logMessage.setBody(JSON.toJSONString((Object)messageLogBo).getBytes());
        return logMessage;
    }

    public static Message toLogMessage(Message mqMessage, String mqMessageId, LogOperateType logOperateType, String connectorIp) {
        Map userProperties = mqMessage.getProperties();
        int messageSize = mqMessage.getBody() == null ? 0 : mqMessage.getBody().length;
        return LogUtils.toLogMessage(userProperties, mqMessageId, mqMessage.getTopic(), logOperateType, connectorIp, messageSize);
    }

    public static Message toLogMessage(Map<String, String> userProperties, String mqMessageId, String topic, LogOperateType logOperateType, String connectorIp, int messageSize, boolean msgFlag) {
        MessageLogBo messageLogBo = LogUtils.toLogBo(userProperties, mqMessageId, topic, logOperateType, connectorIp, messageSize, msgFlag);
        return LogUtils.toLogMessage(messageLogBo);
    }

    public static Message toLogMessage(Map<String, String> userProperties, String mqMessageId, String topic, LogOperateType logOperateType, String connectorIp, int messageSize) {
        MessageLogBo messageLogBo = LogUtils.toLogBo(userProperties, mqMessageId, topic, logOperateType, connectorIp, messageSize);
        return LogUtils.toLogMessage(messageLogBo);
    }

    private static MessageLogBo toLogBo(UmpRequestHeader header, LogOperateType logOperateType, String connectorIp, boolean authFlag, boolean messageFlag, String dc, String zone, int messageSize, String securityZone) {
        MessageLogBo messageLogBo = new MessageLogBo();
        messageLogBo.setCreateTime(DateUtil.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss.SSS"));
        messageLogBo.setTopicName(header.getTopic());
        messageLogBo.setAppId(header.getAppId());
        messageLogBo.setBusinessId(header.getBusinessId());
        messageLogBo.setDc(dc);
        messageLogBo.setZone(zone);
        messageLogBo.setClientIp(header.getClientIp());
        messageLogBo.setMessageId(header.getMessageId());
        messageLogBo.setLogOperateType(logOperateType);
        messageLogBo.setConnectorIp(connectorIp);
        messageLogBo.setMessageSize(messageSize);
        messageLogBo.setAuthFlag(authFlag);
        messageLogBo.setMessageFlag(messageFlag);
        messageLogBo.setTags(header.getTags());
        messageLogBo.setMessageGroupId(header.getMessageGroupId());
        messageLogBo.setSecurityZone(securityZone);
        messageLogBo.setMsgBornTime(header.getMsgBornTime());
        return messageLogBo;
    }

    public static Message toLogMessage(UmpRequestHeader header, LogOperateType logOperateType, String connectorIp, boolean authFlag, boolean messageFlag, String dc, String zone, int messageSize, String securityZone) {
        MessageLogBo messageLogBo = LogUtils.toLogBo(header, logOperateType, connectorIp, authFlag, messageFlag, dc, zone, messageSize, securityZone);
        return LogUtils.toLogMessage(messageLogBo);
    }

    public static Message toRestApiChannelLogMessage(UmpRequestHeader header, LogOperateType logOperateType, String connectorIp, boolean authFlag, boolean messageFlag, String dc, String zone, int messageSize, String securityZone) {
        MessageLogBo messageLogBo = LogUtils.toLogBo(header, logOperateType, connectorIp, authFlag, messageFlag, dc, zone, messageSize, securityZone);
        messageLogBo.setChannel("RestAPI");
        return LogUtils.toLogMessage(messageLogBo);
    }

    public static MessageLogBo toLogBo(MessageExt messageExt) {
        Map<String, String> userProperties = CommonUtils.mapCoppy(messageExt.getProperties());
        MessageLogBo messageLogBo = new MessageLogBo();
        messageLogBo.setCreateTime(DateUtil.formatDate(new Date(), "yyyy-MM-dd HH:mm:ss.SSS"));
        messageLogBo.setTopicName(messageExt.getTopic());
        messageLogBo.setAppId(userProperties.get("app_id"));
        messageLogBo.setBusinessId(userProperties.get("business_id"));
        messageLogBo.setDc(userProperties.get("sys_dc"));
        messageLogBo.setZone(userProperties.get("sys_zone"));
        messageLogBo.setClientIp(userProperties.get("client_ip_address"));
        messageLogBo.setMessageId(userProperties.get("message_id"));
        messageLogBo.setTags(userProperties.get("TAGS") == null ? "" : userProperties.get("TAGS"));
        messageLogBo.setLogOperateType(LogOperateType.RECEIVE_SUCCESS);
        messageLogBo.setConnectorIp("");
        messageLogBo.setMessageSize(messageExt.getBody() == null ? 0 : messageExt.getBody().length);
        messageLogBo.setMessageFlag(true);
        messageLogBo.setMqMessageId(messageExt.getMsgId());
        messageLogBo.setMessageGroupId(userProperties.get("ump_message_group_id"));
        messageLogBo.setConsumerGroup(userProperties.get("consumer_group"));
        messageLogBo.setConsumerInstance(userProperties.get("consumer_instance"));
        messageLogBo.setMessageModel(userProperties.get("message_model"));
        messageLogBo.setSecurityZone(userProperties.get("security_zone"));
        messageLogBo.setMsgBornTime(userProperties.get("msg_born_time"));
        return messageLogBo;
    }

    public static void printObjectProperties(Logger logger, Object object) {
        Field[] fields;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            String name;
            if (Modifier.isStatic(field.getModifiers()) || (name = field.getName()).startsWith("this")) continue;
            Object value = null;
            try {
                field.setAccessible(true);
                value = field.get(object);
                if (null == value) {
                    value = "";
                }
            }
            catch (IllegalAccessException e) {
                logger.error("Failed to obtain object properties", (Throwable)e);
            }
            if (logger == null) continue;
            logger.info(name + "=" + value);
        }
    }
}

