/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.InvokeCallback;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.common.Pair;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.common.RemotingUtil;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyDecoder;
import org.apache.rocketmq.remoting.netty.NettyEncoder;
import org.apache.rocketmq.remoting.netty.NettyEvent;
import org.apache.rocketmq.remoting.netty.NettyEventType;
import org.apache.rocketmq.remoting.netty.NettyRemotingAbstract;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyBridgeRemotingClient
extends NettyRemotingAbstract
implements RemotingClient {
    private static final Logger log = LoggerFactory.getLogger((String)"UmpConnector");
    private static final long LockTimeoutMillis = 3000L;
    private final NettyClientConfig nettyClientConfig;
    private final Bootstrap bootstrap = new Bootstrap();
    private final EventLoopGroup eventLoopGroupWorker;
    private DefaultEventExecutorGroup defaultEventExecutorGroup;
    private final Lock lockChannelTables = new ReentrantLock();
    private final ConcurrentHashMap<String, ChannelWrapper> channelTables = new ConcurrentHashMap();
    private final Timer timer = new Timer("ClientHouseKeepingService", true);
    private final AtomicReference<List<String>> namesrvAddrList = new AtomicReference();
    private final AtomicReference<String> namesrvAddrChoosed = new AtomicReference();
    private final AtomicInteger namesrvIndex = new AtomicInteger(NettyBridgeRemotingClient.initValueIndex());
    private final Lock lockNamesrvChannel = new ReentrantLock();
    private final ExecutorService publicExecutor;
    private final ChannelEventListener channelEventListener;
    private RPCHook rpcHook;
    public static final AttributeKey<Channel> clientChannelKey = AttributeKey.valueOf((String)"clientChannelKey");
    public static final AttributeKey<List<String>> bridgeChannelListKey = AttributeKey.valueOf((String)"bridgeChannelListKey");

    private static int initValueIndex() {
        Random r = new Random();
        return Math.abs(r.nextInt() % 999) % 999;
    }

    public NettyBridgeRemotingClient(NettyClientConfig nettyClientConfig) {
        this(nettyClientConfig, null);
    }

    public NettyBridgeRemotingClient(NettyClientConfig nettyClientConfig, ChannelEventListener channelEventListener) {
        super(nettyClientConfig.getClientOnewaySemaphoreValue(), nettyClientConfig.getClientAsyncSemaphoreValue());
        this.nettyClientConfig = nettyClientConfig;
        this.channelEventListener = channelEventListener;
        int publicThreadNums = nettyClientConfig.getClientCallbackExecutorThreads();
        if (publicThreadNums <= 0) {
            publicThreadNums = 4;
        }
        this.publicExecutor = Executors.newFixedThreadPool(publicThreadNums, new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyClientPublicExecutor_" + this.threadIndex.incrementAndGet());
            }
        });
        this.eventLoopGroupWorker = new NioEventLoopGroup(1, new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, String.format("NettyClientSelector_%d", this.threadIndex.incrementAndGet()));
            }
        });
    }

    public void start() {
        this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyClientConfig.getClientWorkerThreads(), new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyBridgeClientWorkerThread_" + this.threadIndex.incrementAndGet());
            }
        });
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroupWorker)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)false)).option(ChannelOption.SO_SNDBUF, (Object)this.nettyClientConfig.getClientSocketSndBufSize())).option(ChannelOption.SO_RCVBUF, (Object)this.nettyClientConfig.getClientSocketRcvBufSize())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast((EventExecutorGroup)NettyBridgeRemotingClient.this.defaultEventExecutorGroup, new ChannelHandler[]{new NettyEncoder(), new NettyDecoder(), new IdleStateHandler(0, 0, NettyBridgeRemotingClient.this.nettyClientConfig.getClientChannelMaxIdleTimeSeconds()), new NettyConnetManageHandler(), new NettyClientHandler()});
            }
        });
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    NettyBridgeRemotingClient.this.scanResponseTable();
                }
                catch (Exception e) {
                    log.error("scanResponseTable exception", (Throwable)e);
                }
            }
        }, 3000L, 1000L);
        if (this.channelEventListener != null) {
            this.nettyEventExecutor.start();
        }
    }

    public void shutdown() {
        try {
            this.timer.cancel();
            for (ChannelWrapper cw : this.channelTables.values()) {
                this.closeChannel(null, cw.getChannel());
            }
            this.channelTables.clear();
            this.eventLoopGroupWorker.shutdownGracefully();
            if (this.nettyEventExecutor != null) {
                this.nettyEventExecutor.shutdown();
            }
            if (this.defaultEventExecutorGroup != null) {
                this.defaultEventExecutorGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.error("NettyRemotingClient shutdown exception, ", (Throwable)e);
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
            }
            catch (Exception e) {
                log.error("NettyRemotingServer shutdown exception, ", (Throwable)e);
            }
        }
    }

    private Channel getAndCreateChannel(String addr, Channel clientChannel) throws InterruptedException {
        if (null == addr) {
            return this.getAndCreateNameserverChannel();
        }
        ChannelWrapper cw = this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.getChannel();
        }
        return this.createChannel(addr, clientChannel);
    }

    protected Channel getAndCreateChannel(String addr) throws InterruptedException {
        return this.getAndCreateChannel(addr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Channel getAndCreateNameserverChannel() throws InterruptedException {
        ChannelWrapper cw;
        String addr = this.namesrvAddrChoosed.get();
        if (addr != null && (cw = this.channelTables.get(addr)) != null && cw.isOK()) {
            return cw.getChannel();
        }
        List<String> addrList = this.namesrvAddrList.get();
        if (this.lockNamesrvChannel.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            try {
                ChannelWrapper cw2;
                addr = this.namesrvAddrChoosed.get();
                if (addr != null && (cw2 = this.channelTables.get(addr)) != null && cw2.isOK()) {
                    Channel channel = cw2.getChannel();
                    return channel;
                }
                if (addrList == null || addrList.isEmpty()) return null;
                for (int i = 0; i < addrList.size(); ++i) {
                    int index = this.namesrvIndex.incrementAndGet();
                    index = Math.abs(index);
                    String newAddr = addrList.get(index %= addrList.size());
                    this.namesrvAddrChoosed.set(newAddr);
                    Channel channelNew = this.createChannel(newAddr, null);
                    if (channelNew == null) continue;
                    Channel channel = channelNew;
                    return channel;
                }
                return null;
            }
            catch (Exception e) {
                log.error("getAndCreateNameserverChannel: create name server channel exception", (Throwable)e);
                return null;
            }
            finally {
                this.lockNamesrvChannel.unlock();
            }
        } else {
            log.warn("getAndCreateNameserverChannel: try to lock name server, but timeout, {}ms", (Object)3000L);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Channel createChannel(String addr, Channel clientChannel) throws InterruptedException {
        cw = this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return ChannelWrapper.access$400(cw);
        }
        if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            try {
                createNewConnection = false;
                cw = this.channelTables.get(addr);
                if (cw != null) {
                    if (cw.isOK()) {
                        var5_7 = ChannelWrapper.access$400(cw);
                        return var5_7;
                    }
                    if (!cw.getChannelFuture().isDone()) {
                        createNewConnection = false;
                    } else {
                        this.channelTables.remove(addr);
                        createNewConnection = true;
                    }
                } else {
                    createNewConnection = true;
                }
                if (!createNewConnection) ** GOTO lbl35
                channelFuture = this.bootstrap.connect(this.parseAddr(addr, clientChannel));
                NettyBridgeRemotingClient.log.info("createChannel: begin to connect remote host[{}] asynchronously", (Object)addr);
                cw = new ChannelWrapper(channelFuture);
                ChannelWrapper.access$400(cw).attr(NettyBridgeRemotingClient.clientChannelKey).set((Object)clientChannel);
                this.channelTables.put(addr, cw);
            }
            catch (Exception e) {
                NettyBridgeRemotingClient.log.error("createChannel: create channel exception", (Throwable)e);
            }
            finally {
                this.lockChannelTables.unlock();
            }
        } else {
            NettyBridgeRemotingClient.log.warn("createChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
        }
lbl35:
        // 4 sources

        if (cw != null) {
            channelFuture = cw.getChannelFuture();
            if (channelFuture.awaitUninterruptibly((long)this.nettyClientConfig.getConnectTimeoutMillis())) {
                if (cw.isOK()) {
                    NettyBridgeRemotingClient.log.info("createChannel: connect remote host[{}] success, {}", (Object)addr, (Object)channelFuture.toString());
                    return ChannelWrapper.access$400(cw);
                }
                NettyBridgeRemotingClient.log.warn("createChannel: connect remote host[" + addr + "] failed, " + channelFuture.toString(), channelFuture.cause());
            } else {
                NettyBridgeRemotingClient.log.warn("createChannel: connect remote host[{}] timeout {}ms, {}", new Object[]{addr, this.nettyClientConfig.getConnectTimeoutMillis(), channelFuture.toString()});
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(String addr, Channel channel) {
        block13: {
            if (null == channel) {
                return;
            }
            String addrRemote = null == addr ? RemotingHelper.parseChannelRemoteAddr((Channel)channel) : addr;
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        boolean removeItemFromTable = true;
                        ChannelWrapper prevCW = this.channelTables.get(addrRemote);
                        log.info("closeChannel: begin close the channel[{}] Found: {}", (Object)addrRemote, (Object)(prevCW != null ? 1 : 0));
                        if (null == prevCW) {
                            log.info("closeChannel: the channel[{}] has been removed from the channel table before", (Object)addrRemote);
                            removeItemFromTable = false;
                        } else if (prevCW.getChannel() != channel) {
                            log.info("closeChannel: the channel[{}] has been closed before, and has been created again, nothing to do.", (Object)addrRemote);
                            removeItemFromTable = false;
                        }
                        if (removeItemFromTable) {
                            this.channelTables.remove(addrRemote);
                            log.info("closeChannel: the channel[{}] was removed from channel table", (Object)addrRemote);
                        }
                        RemotingUtil.closeChannel((Channel)channel);
                        break block13;
                    }
                    catch (Exception e) {
                        log.error("closeChannel: close the channel exception", (Throwable)e);
                        break block13;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                log.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
            }
            catch (InterruptedException e) {
                log.error("closeChannel exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(Channel channel) {
        block12: {
            if (null == channel) {
                return;
            }
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        boolean removeItemFromTable = true;
                        ChannelWrapper prevCW = null;
                        String addrRemote = null;
                        for (String key : this.channelTables.keySet()) {
                            ChannelWrapper prev = this.channelTables.get(key);
                            if (prev.getChannel() == null || prev.getChannel() != channel) continue;
                            prevCW = prev;
                            addrRemote = key;
                            break;
                        }
                        if (null == prevCW) {
                            log.info("eventCloseChannel: the channel[{}] has been removed from the channel table before", addrRemote);
                            removeItemFromTable = false;
                        }
                        if (removeItemFromTable) {
                            this.channelTables.remove(addrRemote);
                            log.info("closeChannel: the channel[{}] was removed from channel table", addrRemote);
                            RemotingUtil.closeChannel((Channel)channel);
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        log.error("closeChannel: close the channel exception", (Throwable)e);
                        break block12;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                log.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
            }
            catch (InterruptedException e) {
                log.error("closeChannel exception", (Throwable)e);
            }
        }
    }

    public void registerProcessor(int requestCode, NettyRequestProcessor processor, ExecutorService executor) {
        ExecutorService executorThis = executor;
        if (null == executor) {
            executorThis = this.publicExecutor;
        }
        Pair pair = new Pair((Object)processor, (Object)executorThis);
        this.processorTable.put(requestCode, pair);
    }

    public void setCallbackExecutor(ExecutorService executorService) {
    }

    public RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        return this.invokeSync(addr, request, timeoutMillis, null);
    }

    public RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis, Channel clientChannel) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        Channel channel = this.getAndCreateChannel(addr, clientChannel);
        if (channel != null && channel.isActive()) {
            try {
                if (this.rpcHook != null) {
                    this.rpcHook.doBeforeRequest(addr, request);
                }
                RemotingCommand response = this.invokeSyncImpl(channel, request, timeoutMillis);
                if (this.rpcHook != null) {
                    this.rpcHook.doAfterResponse(RemotingHelper.parseChannelRemoteAddr((Channel)channel), request, response);
                }
                return response;
            }
            catch (RemotingSendRequestException e) {
                log.warn("invokeSync: send request exception, so close the channel[{}]", (Object)addr);
                this.closeChannel(addr, channel);
                throw e;
            }
            catch (RemotingTimeoutException e) {
                log.warn("invokeSync: wait response timeout exception, the channel[{}]", (Object)addr);
                throw e;
            }
        }
        this.closeChannel(addr, channel);
        throw new RemotingConnectException(addr);
    }

    public void invokeAsync(String addr, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        this.invokeAsync(addr, request, timeoutMillis, invokeCallback, null);
    }

    public void invokeAsync(String addr, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback, Channel clientChannel) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        Channel channel = this.getAndCreateChannel(addr, clientChannel);
        if (channel != null && channel.isActive()) {
            try {
                if (this.rpcHook != null) {
                    this.rpcHook.doBeforeRequest(addr, request);
                }
                this.invokeAsyncImpl(channel, request, timeoutMillis, invokeCallback);
            }
            catch (RemotingSendRequestException e) {
                log.warn("invokeAsync: send request exception, so close the channel[{}]", (Object)addr);
                this.closeChannel(addr, channel);
                throw e;
            }
        } else {
            this.closeChannel(addr, channel);
            throw new RemotingConnectException(addr);
        }
    }

    public void invokeOneway(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        this.invokeOneway(addr, request, timeoutMillis, null);
    }

    public void invokeOneway(String addr, RemotingCommand request, long timeoutMillis, Channel clientChannel) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        Channel channel = this.getAndCreateChannel(addr, clientChannel);
        if (channel != null && channel.isActive()) {
            try {
                if (this.rpcHook != null) {
                    this.rpcHook.doBeforeRequest(addr, request);
                }
                this.invokeOnewayImpl(channel, request, timeoutMillis);
            }
            catch (RemotingSendRequestException e) {
                log.warn("invokeOneway: send request exception, so close the channel[{}]", (Object)addr);
                this.closeChannel(addr, channel);
                throw e;
            }
        } else {
            this.closeChannel(addr, channel);
            throw new RemotingConnectException(addr);
        }
    }

    public ExecutorService getCallbackExecutor() {
        return this.publicExecutor;
    }

    public void updateNameServerAddressList(List<String> addrs) {
        List<String> old = this.namesrvAddrList.get();
        boolean update = false;
        if (!addrs.isEmpty()) {
            if (null == old) {
                update = true;
            } else if (addrs.size() != old.size()) {
                update = true;
            } else {
                for (int i = 0; i < addrs.size() && !update; ++i) {
                    if (old.contains(addrs.get(i))) continue;
                    update = true;
                }
            }
            if (update) {
                Collections.shuffle(addrs);
                this.namesrvAddrList.set(addrs);
            }
        }
    }

    public ChannelEventListener getChannelEventListener() {
        return this.channelEventListener;
    }

    public List<String> getNamesrvAddrList() {
        return this.namesrvAddrList.get();
    }

    public List<String> getNameServerAddressList() {
        return this.namesrvAddrList.get();
    }

    public RPCHook getRpcHook() {
        return this.rpcHook;
    }

    public void registerRPCHook(RPCHook rpcHook) {
        this.rpcHook = rpcHook;
    }

    public RPCHook getRPCHook() {
        return this.rpcHook;
    }

    public boolean isChannelWritable(String addr) {
        ChannelWrapper cw = this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.isWriteable();
        }
        return true;
    }

    private SocketAddress parseAddr(String addr, Channel clientChannel) {
        int index = addr.indexOf("@");
        if (index > 0) {
            ArrayList<String> addrList = (ArrayList<String>)clientChannel.attr(bridgeChannelListKey).get();
            if (addrList == null) {
                addrList = new ArrayList<String>();
            }
            addrList.add(addr);
            clientChannel.attr(bridgeChannelListKey).set(addrList);
            addr = addr.substring(0, index);
        }
        return RemotingHelper.string2SocketAddress((String)addr);
    }

    public void releaseChannel(String addr) {
        ChannelWrapper channelWrapper = this.channelTables.get(addr);
        if (channelWrapper != null) {
            this.closeChannel(addr, channelWrapper.getChannel());
        }
    }

    public int getChannelTableSize() {
        return this.channelTables.size();
    }

    public Channel getBridgeChannel(String addr) {
        ChannelWrapper channelWrapper = this.channelTables.get(addr);
        if (channelWrapper != null) {
            return channelWrapper.getChannel();
        }
        return null;
    }

    class NettyConnetManageHandler
    extends ChannelDuplexHandler {
        NettyConnetManageHandler() {
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            String local = localAddress == null ? "UNKNOW" : localAddress.toString();
            String remote = remoteAddress == null ? "UNKNOW" : remoteAddress.toString();
            log.info("NETTY CLIENT PIPELINE: CONNECT  {} => {}", (Object)local, (Object)remote);
            super.connect(ctx, remoteAddress, localAddress, promise);
            if (NettyBridgeRemotingClient.this.channelEventListener != null) {
                NettyBridgeRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CONNECT, remoteAddress.toString(), ctx.channel()));
            }
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel());
            log.info("NETTY CLIENT PIPELINE: DISCONNECT {}", (Object)remoteAddress);
            NettyBridgeRemotingClient.this.closeChannel(ctx.channel());
            super.disconnect(ctx, promise);
            if (NettyBridgeRemotingClient.this.channelEventListener != null) {
                NettyBridgeRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress.toString(), ctx.channel()));
            }
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel());
            log.info("NETTY CLIENT PIPELINE: CLOSE {}", (Object)remoteAddress);
            NettyBridgeRemotingClient.this.closeChannel(ctx.channel());
            super.close(ctx, promise);
            if (NettyBridgeRemotingClient.this.channelEventListener != null) {
                NettyBridgeRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress.toString(), ctx.channel()));
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel());
            log.warn("NETTY CLIENT PIPELINE: exceptionCaught {}", (Object)remoteAddress);
            log.warn("NETTY CLIENT PIPELINE: exceptionCaught exception.", cause);
            NettyBridgeRemotingClient.this.closeChannel(ctx.channel());
            if (NettyBridgeRemotingClient.this.channelEventListener != null) {
                NettyBridgeRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.EXCEPTION, remoteAddress.toString(), ctx.channel()));
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            IdleStateEvent evnet;
            if (evt instanceof IdleStateEvent && (evnet = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel());
                log.warn("NETTY CLIENT PIPELINE: IDLE exception [{}]", (Object)remoteAddress);
                NettyBridgeRemotingClient.this.closeChannel(ctx.channel());
                if (NettyBridgeRemotingClient.this.channelEventListener != null) {
                    NettyBridgeRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.IDLE, remoteAddress.toString(), ctx.channel()));
                }
            }
            ctx.fireUserEventTriggered(evt);
        }
    }

    class NettyClientHandler
    extends SimpleChannelInboundHandler<RemotingCommand> {
        NettyClientHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, RemotingCommand msg) throws Exception {
            NettyBridgeRemotingClient.this.processMessageReceived(ctx, msg);
        }
    }

    class ChannelWrapper {
        private final ChannelFuture channelFuture;

        public ChannelWrapper(ChannelFuture channelFuture) {
            this.channelFuture = channelFuture;
        }

        public boolean isOK() {
            return this.channelFuture.channel() != null && this.channelFuture.channel().isActive();
        }

        public boolean isWriteable() {
            return this.channelFuture.channel().isWritable();
        }

        private Channel getChannel() {
            return this.channelFuture.channel();
        }

        public ChannelFuture getChannelFuture() {
            return this.channelFuture;
        }
    }
}

