/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.netty;

import com.huawei.it.eip.ump.common.constant.UmpConstants;
import com.huawei.it.eip.ump.common.security.AesCoder;
import com.huawei.it.eip.ump.common.security.RsaCoder;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.InvokeCallback;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.common.Pair;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.common.RemotingUtil;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyDecoder;
import org.apache.rocketmq.remoting.netty.NettyEncoder;
import org.apache.rocketmq.remoting.netty.NettyEvent;
import org.apache.rocketmq.remoting.netty.NettyEventType;
import org.apache.rocketmq.remoting.netty.NettyRemotingAbstract;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class NettySslRemotingClient
extends NettyRemotingAbstract
implements RemotingClient {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqRemoting");
    private static final long LockTimeoutMillis = 10000L;
    private final NettyClientConfig nettyClientConfig;
    private final Bootstrap bootstrap = new Bootstrap();
    private final EventLoopGroup eventLoopGroupWorker;
    private DefaultEventExecutorGroup defaultEventExecutorGroup;
    private final Lock lockChannelTables = new ReentrantLock();
    private final ConcurrentHashMap<String, ChannelWrapper> channelTables = new ConcurrentHashMap();
    private final Timer timer = new Timer("ClientHouseKeepingService", true);
    private final AtomicReference<List<String>> namesrvAddrList = new AtomicReference();
    private final AtomicReference<String> namesrvAddrChoosed = new AtomicReference();
    private final AtomicInteger namesrvIndex = new AtomicInteger(NettySslRemotingClient.initValueIndex());
    private final Lock lockNamesrvChannel = new ReentrantLock();
    private final ExecutorService publicExecutor;
    private final ChannelEventListener channelEventListener;
    private RPCHook rpcHook;
    protected boolean encryptTransport = false;

    private static int initValueIndex() {
        Random r = new Random();
        return Math.abs(r.nextInt() % 999) % 999;
    }

    public NettySslRemotingClient(NettyClientConfig nettyClientConfig, boolean encryptTransport) {
        this(nettyClientConfig, null);
        this.encryptTransport = encryptTransport;
    }

    public NettySslRemotingClient(NettyClientConfig nettyClientConfig, ChannelEventListener channelEventListener) {
        super(nettyClientConfig.getClientOnewaySemaphoreValue(), nettyClientConfig.getClientAsyncSemaphoreValue());
        this.nettyClientConfig = nettyClientConfig;
        this.channelEventListener = channelEventListener;
        int publicThreadNums = nettyClientConfig.getClientCallbackExecutorThreads();
        if (publicThreadNums <= 0) {
            publicThreadNums = 4;
        }
        this.publicExecutor = Executors.newFixedThreadPool(publicThreadNums, new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyClientPublicExecutor_" + this.threadIndex.incrementAndGet());
            }
        });
        this.eventLoopGroupWorker = new NioEventLoopGroup(1, new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, String.format("NettyClientSelector_%d", this.threadIndex.incrementAndGet()));
            }
        });
    }

    public void start() {
        this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyClientConfig.getClientWorkerThreads(), new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettySslClientWorkerThread_" + this.threadIndex.incrementAndGet());
            }
        });
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroupWorker)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)false)).option(ChannelOption.SO_SNDBUF, (Object)this.nettyClientConfig.getClientSocketSndBufSize())).option(ChannelOption.SO_RCVBUF, (Object)this.nettyClientConfig.getClientSocketRcvBufSize())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast((EventExecutorGroup)NettySslRemotingClient.this.defaultEventExecutorGroup, new ChannelHandler[]{new NettyEncoder(), new NettyDecoder(), new IdleStateHandler(0, 0, NettySslRemotingClient.this.nettyClientConfig.getClientChannelMaxIdleTimeSeconds()), new NettyConnetManageHandler(), new NettyClientHandler()});
            }
        });
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    NettySslRemotingClient.this.scanResponseTable();
                }
                catch (Exception e) {
                    log.error("scanResponseTable exception", (Throwable)e);
                }
            }
        }, 3000L, 1000L);
        if (this.channelEventListener != null) {
            this.nettyEventExecutor.start();
        }
    }

    public void shutdown() {
        try {
            this.timer.cancel();
            for (ChannelWrapper cw : this.channelTables.values()) {
                this.closeChannel(null, cw.getChannel());
            }
            this.channelTables.clear();
            this.eventLoopGroupWorker.shutdownGracefully();
            if (this.nettyEventExecutor != null) {
                this.nettyEventExecutor.shutdown();
            }
            if (this.defaultEventExecutorGroup != null) {
                this.defaultEventExecutorGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.error("NettyRemotingClient shutdown exception, ", (Throwable)e);
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
            }
            catch (Exception e) {
                log.error("NettyRemotingServer shutdown exception, ", (Throwable)e);
            }
        }
    }

    private Channel getAndCreateChannel(String addr) throws InterruptedException, RemotingConnectException {
        if (null == addr) {
            return this.getAndCreateNameserverChannel();
        }
        ChannelWrapper cw = this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.getChannel();
        }
        return this.createChannel(addr);
    }

    public void exchangeEncryptKey(Channel channel, long timeoutMillis) throws Exception {
        block4: {
            try {
                RemotingCommand requestRsaKey = RemotingCommand.createRequestCommand((int)17, null);
                RemotingCommand responseRsaKey = this.invokeSyncImpl(channel, requestRsaKey, timeoutMillis);
                if (responseRsaKey.getCode() == 0) {
                    String rsaPublicKey = new String(responseRsaKey.getBody());
                    byte[] encryptAesKey = RsaCoder.encryptByPublicKey(AesCoder.getKey().getBytes(), rsaPublicKey);
                    RemotingCommand request = RemotingCommand.createRequestCommand((int)16, null);
                    request.setBody(encryptAesKey);
                    RemotingCommand response = this.invokeSyncImpl(channel, request, timeoutMillis);
                    if (response.getCode() != 0) {
                        throw new Exception("send AES key to connector failed.");
                    }
                    break block4;
                }
                throw new Exception("get RSA public key from connector failed.");
            }
            catch (Exception e) {
                throw new Exception("exchangeEncryptKey encounter exception.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Channel getAndCreateNameserverChannel() throws InterruptedException {
        ChannelWrapper cw;
        String addr = this.namesrvAddrChoosed.get();
        if (addr != null && (cw = this.channelTables.get(addr)) != null && cw.isOK()) {
            return cw.getChannel();
        }
        List<String> addrList = this.namesrvAddrList.get();
        if (this.lockNamesrvChannel.tryLock(10000L, TimeUnit.MILLISECONDS)) {
            try {
                ChannelWrapper cw2;
                addr = this.namesrvAddrChoosed.get();
                if (addr != null && (cw2 = this.channelTables.get(addr)) != null && cw2.isOK()) {
                    Channel channel = cw2.getChannel();
                    return channel;
                }
                if (addrList == null || addrList.isEmpty()) return null;
                for (int i = 0; i < addrList.size(); ++i) {
                    int index = this.namesrvIndex.incrementAndGet();
                    index = Math.abs(index);
                    String newAddr = addrList.get(index %= addrList.size());
                    this.namesrvAddrChoosed.set(newAddr);
                    Channel channelNew = this.createChannel(newAddr);
                    if (channelNew == null) continue;
                    if (this.encryptTransport) {
                        this.exchangeEncryptKey(channelNew, UmpConstants.TIMEOUT_MILLIS);
                    }
                    Channel channel = channelNew;
                    return channel;
                }
                return null;
            }
            catch (Exception e) {
                log.error("getAndCreateNameserverChannel: create name server channel exception", (Throwable)e);
                return null;
            }
            finally {
                this.lockNamesrvChannel.unlock();
            }
        } else {
            log.warn("getAndCreateNameserverChannel: try to lock name server, but timeout, {}ms", (Object)10000L);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Channel createChannel(String addr) throws InterruptedException, RemotingConnectException {
        cw = this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return ChannelWrapper.access$400(cw);
        }
        if (this.lockChannelTables.tryLock(10000L, TimeUnit.MILLISECONDS)) {
            try {
                createNewConnection = false;
                cw = this.channelTables.get(addr);
                if (cw != null) {
                    if (cw.isOK()) {
                        var4_6 = ChannelWrapper.access$400(cw);
                        return var4_6;
                    }
                    if (!cw.getChannelFuture().isDone()) {
                        createNewConnection = false;
                    } else {
                        this.channelTables.remove(addr);
                        createNewConnection = true;
                    }
                } else {
                    createNewConnection = true;
                }
                if (!createNewConnection) ** GOTO lbl34
                channelFuture = this.bootstrap.connect(RemotingHelper.string2SocketAddress((String)addr));
                NettySslRemotingClient.log.info("createChannel: begin to connect remote host[{}] asynchronously", (Object)addr);
                cw = new ChannelWrapper(channelFuture);
                this.channelTables.put(addr, cw);
            }
            catch (Exception e) {
                NettySslRemotingClient.log.error("createChannel: create channel exception", (Throwable)e);
            }
            finally {
                this.lockChannelTables.unlock();
            }
        } else {
            NettySslRemotingClient.log.warn("createChannel: try to lock channel table, but timeout, {}ms", (Object)10000L);
        }
lbl34:
        // 4 sources

        if (cw != null) {
            channelFuture = cw.getChannelFuture();
            if (channelFuture.awaitUninterruptibly((long)this.nettyClientConfig.getConnectTimeoutMillis())) {
                if (cw.isOK()) {
                    NettySslRemotingClient.log.info("createChannel: connect remote host[{}] success, {}", (Object)addr, (Object)channelFuture.toString());
                    return ChannelWrapper.access$400(cw);
                }
                NettySslRemotingClient.log.warn("createChannel: connect remote host[" + addr + "] failed, " + channelFuture.toString(), channelFuture.cause());
            } else {
                NettySslRemotingClient.log.warn("createChannel: connect remote host[{}] timeout {}ms, {}", new Object[]{addr, this.nettyClientConfig.getConnectTimeoutMillis(), channelFuture.toString()});
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(String addr, Channel channel) {
        block13: {
            if (null == channel) {
                return;
            }
            String addrRemote = null == addr ? RemotingHelper.parseChannelRemoteAddr((Channel)channel) : addr;
            try {
                if (this.lockChannelTables.tryLock(10000L, TimeUnit.MILLISECONDS)) {
                    try {
                        boolean removeItemFromTable = true;
                        ChannelWrapper prevCW = this.channelTables.get(addrRemote);
                        log.info("closeChannel: begin close the channel[{}] Found: {}", (Object)addrRemote, (Object)(prevCW != null ? 1 : 0));
                        if (null == prevCW) {
                            log.info("closeChannel: the channel[{}] has been removed from the channel table before", (Object)addrRemote);
                            removeItemFromTable = false;
                        } else if (prevCW.getChannel() != channel) {
                            log.info("closeChannel: the channel[{}] has been closed before, and has been created again, nothing to do.", (Object)addrRemote);
                            removeItemFromTable = false;
                        }
                        if (removeItemFromTable) {
                            this.channelTables.remove(addrRemote);
                            log.info("closeChannel: the channel[{}] was removed from channel table", (Object)addrRemote);
                        }
                        RemotingUtil.closeChannel((Channel)channel);
                        break block13;
                    }
                    catch (Exception e) {
                        log.error("closeChannel: close the channel exception", (Throwable)e);
                        break block13;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                log.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)10000L);
            }
            catch (InterruptedException e) {
                log.error("closeChannel exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(Channel channel) {
        block12: {
            if (null == channel) {
                return;
            }
            try {
                if (this.lockChannelTables.tryLock(10000L, TimeUnit.MILLISECONDS)) {
                    try {
                        boolean removeItemFromTable = true;
                        ChannelWrapper prevCW = null;
                        String addrRemote = null;
                        for (String key : this.channelTables.keySet()) {
                            ChannelWrapper prev = this.channelTables.get(key);
                            if (prev.getChannel() == null || prev.getChannel() != channel) continue;
                            prevCW = prev;
                            addrRemote = key;
                            break;
                        }
                        if (null == prevCW) {
                            log.info("eventCloseChannel: the channel[{}] has been removed from the channel table before", addrRemote);
                            removeItemFromTable = false;
                        }
                        if (removeItemFromTable) {
                            this.channelTables.remove(addrRemote);
                            log.info("closeChannel: the channel[{}] was removed from channel table", addrRemote);
                            RemotingUtil.closeChannel((Channel)channel);
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        log.error("closeChannel: close the channel exception", (Throwable)e);
                        break block12;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                log.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)10000L);
            }
            catch (InterruptedException e) {
                log.error("closeChannel exception", (Throwable)e);
            }
        }
    }

    public void registerProcessor(int requestCode, NettyRequestProcessor processor, ExecutorService executor) {
        ExecutorService executorThis = executor;
        if (null == executor) {
            executorThis = this.publicExecutor;
        }
        Pair pair = new Pair((Object)processor, (Object)executorThis);
        this.processorTable.put(requestCode, pair);
    }

    public RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        Channel channel = this.getAndCreateChannel(addr);
        if (channel != null && channel.isActive()) {
            try {
                if (this.rpcHook != null) {
                    this.rpcHook.doBeforeRequest(addr, request);
                }
                RemotingCommand response = this.invokeSyncImpl(channel, request, timeoutMillis);
                if (this.rpcHook != null) {
                    this.rpcHook.doAfterResponse(RemotingHelper.parseChannelRemoteAddr((Channel)channel), request, response);
                }
                return response;
            }
            catch (RemotingSendRequestException e) {
                log.warn("invokeSync: send request exception, so close the channel[{}]", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
                this.closeChannel(addr, channel);
                throw e;
            }
            catch (RemotingTimeoutException e) {
                log.warn("invokeSync: wait response timeout exception, the channel[{}]", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
                throw e;
            }
        }
        this.closeChannel(addr, channel);
        throw new RemotingConnectException(addr);
    }

    public void invokeAsync(String addr, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        Channel channel = this.getAndCreateChannel(addr);
        if (channel != null && channel.isActive()) {
            try {
                if (this.rpcHook != null) {
                    this.rpcHook.doBeforeRequest(addr, request);
                }
                this.invokeAsyncImpl(channel, request, timeoutMillis, invokeCallback);
            }
            catch (RemotingSendRequestException e) {
                log.warn("invokeAsync: send request exception, so close the channel[{}]", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
                this.closeChannel(addr, channel);
                throw e;
            }
        } else {
            this.closeChannel(addr, channel);
            throw new RemotingConnectException(addr);
        }
    }

    public void invokeOneway(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        Channel channel = this.getAndCreateChannel(addr);
        if (channel != null && channel.isActive()) {
            try {
                if (this.rpcHook != null) {
                    this.rpcHook.doBeforeRequest(addr, request);
                }
                this.invokeOnewayImpl(channel, request, timeoutMillis);
            }
            catch (RemotingSendRequestException e) {
                log.warn("invokeOneway: send request exception, so close the channel[{}]", (Object)RemotingHelper.parseChannelRemoteAddr((Channel)channel));
                this.closeChannel(addr, channel);
                throw e;
            }
        } else {
            this.closeChannel(addr, channel);
            throw new RemotingConnectException(addr);
        }
    }

    public ExecutorService getCallbackExecutor() {
        return this.publicExecutor;
    }

    public void updateNameServerAddressList(List<String> addrs) {
        List<String> old = this.namesrvAddrList.get();
        boolean update = false;
        if (!addrs.isEmpty()) {
            if (null == old) {
                update = true;
            } else if (addrs.size() != old.size()) {
                update = true;
            } else {
                for (int i = 0; i < addrs.size() && !update; ++i) {
                    if (old.contains(addrs.get(i))) continue;
                    update = true;
                }
            }
            if (update) {
                Collections.shuffle(addrs);
                this.namesrvAddrList.set(addrs);
            }
        }
    }

    public ChannelEventListener getChannelEventListener() {
        return this.channelEventListener;
    }

    public List<String> getNamesrvAddrList() {
        return this.namesrvAddrList.get();
    }

    public List<String> getNameServerAddressList() {
        return this.namesrvAddrList.get();
    }

    public RPCHook getRpcHook() {
        return this.rpcHook;
    }

    public void registerRPCHook(RPCHook rpcHook) {
        this.rpcHook = rpcHook;
    }

    public RPCHook getRPCHook() {
        return this.rpcHook;
    }

    public boolean isChannelWritable(String addr) {
        ChannelWrapper cw = this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.isWriteable();
        }
        return true;
    }

    public void closeCurrentChannel() {
        String addr = this.namesrvAddrChoosed.get();
        ChannelWrapper channelWrapper = this.channelTables.get(addr);
        if (channelWrapper != null) {
            this.closeChannel(addr, channelWrapper.getChannel());
        }
    }

    public void setCallbackExecutor(ExecutorService executorService) {
    }

    class NettyConnetManageHandler
    extends ChannelDuplexHandler {
        NettyConnetManageHandler() {
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            String local = localAddress == null ? "UNKNOW" : localAddress.toString();
            String remote = remoteAddress == null ? "UNKNOW" : remoteAddress.toString();
            log.info("NETTY CLIENT PIPELINE: CONNECT  {} => {}", (Object)local, (Object)remote);
            super.connect(ctx, remoteAddress, localAddress, promise);
            if (NettySslRemotingClient.this.channelEventListener != null) {
                NettySslRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CONNECT, remoteAddress.toString(), ctx.channel()));
            }
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel());
            log.info("NETTY CLIENT PIPELINE: DISCONNECT {}", (Object)remoteAddress);
            NettySslRemotingClient.this.closeChannel(ctx.channel());
            super.disconnect(ctx, promise);
            if (NettySslRemotingClient.this.channelEventListener != null) {
                NettySslRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress.toString(), ctx.channel()));
            }
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel());
            log.info("NETTY CLIENT PIPELINE: CLOSE {}", (Object)remoteAddress);
            NettySslRemotingClient.this.closeChannel(ctx.channel());
            super.close(ctx, promise);
            if (NettySslRemotingClient.this.channelEventListener != null) {
                NettySslRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress.toString(), ctx.channel()));
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel());
            log.warn("NETTY CLIENT PIPELINE: exceptionCaught {}", (Object)remoteAddress);
            log.warn("NETTY CLIENT PIPELINE: exceptionCaught exception.", cause);
            NettySslRemotingClient.this.closeChannel(ctx.channel());
            if (NettySslRemotingClient.this.channelEventListener != null) {
                NettySslRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.EXCEPTION, remoteAddress.toString(), ctx.channel()));
            }
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            IdleStateEvent evnet;
            if (evt instanceof IdleStateEvent && (evnet = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr((Channel)ctx.channel());
                log.warn("NETTY CLIENT PIPELINE: IDLE exception [{}]", (Object)remoteAddress);
                NettySslRemotingClient.this.closeChannel(ctx.channel());
                if (NettySslRemotingClient.this.channelEventListener != null) {
                    NettySslRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.IDLE, remoteAddress.toString(), ctx.channel()));
                }
            }
            ctx.fireUserEventTriggered(evt);
        }
    }

    class NettyClientHandler
    extends SimpleChannelInboundHandler<RemotingCommand> {
        NettyClientHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, RemotingCommand msg) throws Exception {
            NettySslRemotingClient.this.processMessageReceived(ctx, msg);
        }
    }

    class ChannelWrapper {
        private final ChannelFuture channelFuture;

        public ChannelWrapper(ChannelFuture channelFuture) {
            this.channelFuture = channelFuture;
        }

        public boolean isOK() {
            return this.channelFuture.channel() != null && this.channelFuture.channel().isActive();
        }

        public boolean isWriteable() {
            return this.channelFuture.channel().isWritable();
        }

        private Channel getChannel() {
            return this.channelFuture.channel();
        }

        public ChannelFuture getChannelFuture() {
            return this.channelFuture;
        }
    }
}

