/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.client;

import com.huawei.it.eip.ump.client.config.ClientConfig;
import com.huawei.it.eip.ump.client.namesrv.NamesrvService;
import com.huawei.it.eip.ump.client.netty.UmpNettyRemotingClient;
import com.huawei.it.eip.ump.common.constant.UmpConstants;
import com.huawei.it.eip.ump.common.exception.UmpException;
import com.huawei.it.eip.ump.common.message.UmpRequestHeader;
import com.huawei.it.eip.ump.common.protocol.body.ConnectorInfo;
import com.huawei.it.eip.ump.common.protocol.body.ConnectorInfoWrapper;
import com.huawei.it.eip.ump.common.security.AesCoder;
import com.huawei.it.eip.ump.common.security.Coder;
import com.huawei.it.eip.ump.common.util.CommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.client.ext.exception.MQClientException;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
extends ClientConfig {
    protected static final Logger logger = LoggerFactory.getLogger((String)"UmpClient");
    protected AtomicBoolean started = new AtomicBoolean(false);
    protected int clientLoginCode = 18;
    protected String clientName = "consumer";
    protected String connectorUrl = null;
    protected Iterator<ConnectorInfo> connit = null;
    protected ConnectorInfoWrapper connectorInfoWrapper;
    protected RemotingClient remotingClient;
    protected NamesrvService namesrvService;
    protected long channelActiveTime = 0L;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    public static Map<String, Boolean> clientInstanceMap = new HashMap<String, Boolean>();
    protected long heartBeatPeriod = 30000L;
    protected int maxMessageSize = 0x200000;
    protected int compressSize = 4096;
    protected int sendMsgTimeout = 12000;
    protected final ClientConfig fixClientConfig = new ClientConfig();
    private AtomicBoolean loggedIn = new AtomicBoolean(false);
    protected boolean tlsTestModeEnable = false;
    protected boolean tlsClientAuthServer = false;
    protected String tlsClientTrustCertPath = null;
    protected String tlsClientKeyPath = null;
    protected String tlsClientKeyPassword = null;
    protected String tlsClientCertPath = null;

    public AbstractClient() {
        this.namesrvService = new NamesrvService(this);
    }

    public void authenticateClient(RemotingClient remotingClient) throws MQClientException {
        this.remotingClient = remotingClient;
        this.authenticateClient();
    }

    public void authenticateClient() throws MQClientException {
        this.login();
    }

    protected List<String> fetchConnector() throws MQClientException {
        return this.fetchConnector(this.namesrvService);
    }

    protected List<String> fetchConnector(NamesrvService service) throws MQClientException {
        List<ConnectorInfo> connectorInfoList = Collections.emptyList();
        for (String umpNamesrvUrl : this.getUmpNamesrvUrls().split(";")) {
            try {
                connectorInfoList = service.fetchConnectorUrl(umpNamesrvUrl);
                if (CommonUtils.isEmpty(connectorInfoList)) continue;
                break;
            }
            catch (UmpException e) {
                logger.warn("initial connector encounter inactive umpNamesrv: {}", (Object)umpNamesrvUrl, (Object)e);
            }
        }
        if (CommonUtils.isEmpty(connectorInfoList)) {
            throw new MQClientException(-1, String.format("cannot fetch any active connector from umpNamesrvUrls=%s", this.getUmpNamesrvUrls()));
        }
        Collections.sort(connectorInfoList, this.getConnectorInfoComparator());
        return this.getConnectorUrls(connectorInfoList);
    }

    protected List<String> getConnectorUrls(List<ConnectorInfo> connectorInfoList) {
        ArrayList<String> connectorUrlList = new ArrayList<String>();
        for (ConnectorInfo connectorInfo : connectorInfoList) {
            connectorUrlList.add(connectorInfo.getConnectorUrl());
        }
        return connectorUrlList;
    }

    protected void fetchConnectorUrl() {
        try {
            List<String> connectorUrlList = this.fetchConnector();
            StringBuilder sb = new StringBuilder();
            for (String url : connectorUrlList) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(url);
            }
            this.connectorUrl = sb.toString();
        }
        catch (Exception e) {
            logger.error("FetchConnectorUrl exception", (Throwable)e);
        }
    }

    protected String getConnectorUrl() {
        if (this.connectorUrl == null) {
            if (CommonUtils.isNotEmpty((String)this.getUmpConnectorUrls())) {
                this.connectorUrl = this.getUmpConnectorUrls();
            } else {
                this.fetchConnectorUrl();
            }
        }
        return this.connectorUrl;
    }

    protected void fetchFileServiceUrl() {
        if (CommonUtils.isEmpty((String)this.getUmpNamesrvUrls())) {
            return;
        }
        for (String umpNamesrvUrl : this.getUmpNamesrvUrls().split(";")) {
            try {
                String ftsUrl = this.namesrvService.fetchFileServiceUrl(umpNamesrvUrl);
                if (ftsUrl != null) {
                    this.setFileServiceUrl(ftsUrl);
                    return;
                }
                break;
            }
            catch (UmpException e) {
                logger.warn("fetchFileServiceUrl from umpNamesrv encounter inactive umpNamesrv: {}", (Object)umpNamesrvUrl, (Object)e);
            }
        }
    }

    public void start() throws UmpException {
        this.checkConfig();
        try {
            if (this.started.compareAndSet(false, true)) {
                AesCoder.initKey();
                this.namesrvService.start();
                this.startClient();
                this.freezeConfig();
                this.loggedIn.set(true);
            }
        }
        catch (Exception e) {
            this.shutdownClient();
            if (this.remotingClient != null) {
                this.remotingClient.shutdown();
            }
            throw new UmpException(String.format("Failed to start %s with settings: %s, %s", this.clientName, super.toString(), e.getMessage()));
        }
        finally {
            if (this.namesrvService != null) {
                this.namesrvService.shutdown();
            }
        }
    }

    protected void login() throws MQClientException {
        UmpRequestHeader header = new UmpRequestHeader();
        header.setAppId(this.getAppId());
        header.setTopic(this.getTopic());
        header.setTags(this.getTags());
        header.setClientIp(this.getClientIp());
        header.setMessageId(CommonUtils.generateUuid());
        header.setClientName(this.clientName);
        RemotingCommand response = null;
        try {
            RemotingCommand request = RemotingCommand.createRequestCommand((int)this.clientLoginCode, (CommandCustomHeader)header);
            String appSecret = Coder.encryptBASE64((byte[])this.getAppSecret().getBytes("UTF-8"));
            request.setBody(appSecret.getBytes("UTF-8"));
            long timeoutMillis = this.getLoginTimeoutMillis();
            if (timeoutMillis < UmpConstants.TIMEOUT_MILLIS) {
                timeoutMillis = UmpConstants.TIMEOUT_MILLIS;
            }
            response = this.remotingClient.invokeSync(null, request, timeoutMillis);
        }
        catch (Exception e) {
            throw new MQClientException(String.format("%s login encounter exception with appId: %s", this.clientName, this.getAppId()), e);
        }
        if (0 != response.getCode()) {
            String remark = response.getRemark();
            if (remark == null) {
                remark = "error code: " + response.getCode();
            }
            throw new MQClientException(response.getCode(), remark);
        }
        logger.info("authenticate successfully, connectorUrls: {}", (Object)this.remotingClient.getNameServerAddressList());
    }

    public void shutdown() throws UmpException {
        try {
            if (this.closed.compareAndSet(false, true)) {
                this.shutdownClient();
                this.namesrvService.shutdown();
            }
        }
        catch (Exception e) {
            throw new UmpException("shutdown " + this.clientName + " encounter exception.", (Throwable)e);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isLoggedIn() {
        return this.loggedIn.get();
    }

    protected MessageExt toMqMessage(com.huawei.it.eip.ump.common.message.Message umpMessage) throws UmpException {
        MessageExt message = new MessageExt();
        umpMessage.setMessageId(CommonUtils.generateUuid());
        HashMap<String, String> properties = null;
        properties = !CommonUtils.isEmpty((Map)umpMessage.getProperties()) ? CommonUtils.mapCoppy((Map)umpMessage.getProperties()) : new HashMap<String, String>();
        properties.put("app_id", this.fixClientConfig.getAppId());
        properties.put("client_ip_address", this.fixClientConfig.getClientIp());
        properties.put("message_id", umpMessage.getMessageId());
        if (!CommonUtils.isEmpty((String)umpMessage.getBusinessId())) {
            properties.put("business_id", umpMessage.getBusinessId());
        }
        if (!CommonUtils.isEmpty((String)umpMessage.getDestinationDc())) {
            properties.put("sys_destination_dc", umpMessage.getDestinationDc());
        }
        if (!CommonUtils.isEmpty((String)umpMessage.getDestinationZone())) {
            properties.put("sys_destination_zone", umpMessage.getDestinationZone());
        }
        if (!CommonUtils.isEmpty((String)umpMessage.getMessageGroupId())) {
            properties.put("ump_message_group_id", umpMessage.getMessageGroupId());
        }
        MessageAccessor.setProperties((Message)message, properties);
        message.setTopic(this.fixClientConfig.getTopic());
        message.setFlag(umpMessage.getFlag());
        message.setTags(umpMessage.getTags() == null ? "" : umpMessage.getTags());
        message.setBody(umpMessage.getBody());
        message.setDelayTimeLevel(umpMessage.getDelayTimeLevel());
        return message;
    }

    protected com.huawei.it.eip.ump.common.message.Message toUmpMessage(MessageExt messageExt) throws UmpException {
        com.huawei.it.eip.ump.common.message.Message message = new com.huawei.it.eip.ump.common.message.Message();
        Map<String, String> map = this.cleanSysTag(CommonUtils.mapCoppy((Map)messageExt.getProperties()));
        map.put("rmq_msg_id", messageExt.getMsgId());
        message.setProperties(map);
        message.setMessageId(map.remove("message_id"));
        message.setMessageGroupId(map.remove("ump_message_group_id"));
        message.setBusinessId(map.remove("business_id"));
        message.setTags(messageExt.getTags());
        message.setBornTimestamp(messageExt.getBornTimestamp());
        message.setStoreTimestamp(messageExt.getStoreTimestamp());
        message.setDelayTimeLevel(messageExt.getDelayTimeLevel());
        String umpMessageFlag = map.get("ump_message_flag");
        int umpSysFlag = umpMessageFlag == null ? 0 : Integer.parseInt(umpMessageFlag);
        try {
            byte[] body = messageExt.getBody();
            if (body != null && (umpSysFlag & 2) == 2) {
                body = CommonUtils.uncompress((byte[])body);
            }
            message.setBody(body);
        }
        catch (Exception e) {
            throw new UmpException((Throwable)e);
        }
        return message;
    }

    private Map<String, String> cleanSysTag(Map<String, String> properties) {
        String[] sysTags;
        for (String sysTag : sysTags = new String[]{"KEYS", "TAGS", "WAIT", "DELAY", "RETRY_TOPIC", "REAL_TOPIC", "REAL_QID", "TRAN_MSG", "PGROUP", "MIN_OFFSET", "MAX_OFFSET", "BUYER_ID", "ORIGIN_MESSAGE_ID", "TRANSFER_FLAG", "CORRECTION_FLAG", "MQ2_FLAG", "RECONSUME_TIME"}) {
            properties.remove(sysTag);
        }
        return properties;
    }

    protected void checkConfig() throws UmpException {
        if (CommonUtils.isEmpty((String)this.getUmpNamesrvUrls()) && CommonUtils.isEmpty((String)this.getUmpConnectorUrls())) {
            throw new UmpException("umpNamesrvUrls or umpConnectorUrls is required.");
        }
        if (CommonUtils.isEmpty((String)this.getTopic())) {
            throw new UmpException("topic is required.");
        }
        if (CommonUtils.isEmpty((String)this.getAppId())) {
            throw new UmpException("appId is required.");
        }
        if (CommonUtils.isEmpty((String)this.getAppSecret())) {
            throw new UmpException("appSecret is required.");
        }
    }

    protected void freezeConfig() {
        this.fixClientConfig.setAppId(this.getAppId());
        this.fixClientConfig.setAppSecret(this.getAppSecret());
        this.fixClientConfig.setTopic(this.getTopic());
        this.fixClientConfig.setTags(this.getTags());
        this.fixClientConfig.setEncryptTransport(this.isEncryptTransport());
        this.fixClientConfig.setUmpNamesrvUrls(this.getUmpNamesrvUrls());
        this.fixClientConfig.setCompressLargeBody(this.isCompressLargeBody());
        this.fixClientConfig.setInstanceName(this.getInstanceName());
    }

    public void freshConnectorList() {
        NamesrvService service = new NamesrvService(this);
        try {
            service.start();
            List<String> addrList = this.fetchConnector(service);
            this.remotingClient.updateNameServerAddressList(addrList);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            service.shutdown();
        }
    }

    protected void closeCurrentChannel() {
        if (this.remotingClient instanceof UmpNettyRemotingClient) {
            UmpNettyRemotingClient client = (UmpNettyRemotingClient)this.remotingClient;
            client.closeCurrentChannel();
        }
    }

    protected void resetCurrentChannel() {
        this.freshConnectorList();
        this.closeCurrentChannel();
    }

    protected Comparator<ConnectorInfo> getConnectorInfoComparator() {
        return new Comparator<ConnectorInfo>(){

            @Override
            public int compare(ConnectorInfo c1, ConnectorInfo c2) {
                if (c1 == null || c1.getSendMessageCount() == null) {
                    return 1;
                }
                if (c2 == null || c2.getSendMessageCount() == null) {
                    return -1;
                }
                return c1.getSendMessageCount().compareTo(c2.getSendMessageCount());
            }
        };
    }

    protected void startClient() throws MQClientException {
        if (this.isEncryptTransport() && !CommonUtils.isEmpty((String)this.tlsClientTrustCertPath)) {
            this.tlsClientAuthServer = true;
            System.setProperty("tls.client.trustCertPath", this.tlsClientTrustCertPath);
        }
        System.setProperty("tls.test.mode.enable", String.valueOf(this.tlsTestModeEnable));
        System.setProperty("tls.client.authServer", String.valueOf(this.tlsClientAuthServer));
        if (this.tlsClientCertPath != null) {
            System.setProperty("tls.client.certPath", this.tlsClientCertPath);
        }
        if (this.tlsClientKeyPath != null) {
            System.setProperty("tls.client.keyPath", this.tlsClientKeyPath);
        }
        if (this.tlsClientKeyPassword != null) {
            System.setProperty("tls.client.keyPassword", this.tlsClientKeyPassword);
        }
    }

    protected abstract void shutdownClient();

    public boolean isTlsTestModeEnable() {
        return this.tlsTestModeEnable;
    }

    public void setTlsTestModeEnable(boolean tlsTestModeEnable) {
        this.tlsTestModeEnable = tlsTestModeEnable;
    }

    public boolean isTlsClientAuthServer() {
        return this.tlsClientAuthServer;
    }

    public void setTlsClientAuthServer(boolean tlsClientAuthServer) {
        this.tlsClientAuthServer = tlsClientAuthServer;
    }

    public String getTlsClientTrustCertPath() {
        return this.tlsClientTrustCertPath;
    }

    public void setTlsClientTrustCertPath(String tlsClientTrustCertPath) {
        this.tlsClientTrustCertPath = tlsClientTrustCertPath;
    }

    public String getTlsClientKeyPath() {
        return this.tlsClientKeyPath;
    }

    public void setTlsClientKeyPath(String tlsClientKeyPath) {
        this.tlsClientKeyPath = tlsClientKeyPath;
    }

    public String getTlsClientKeyPassword() {
        return this.tlsClientKeyPassword;
    }

    public void setTlsClientKeyPassword(String tlsClientKeyPassword) {
        this.tlsClientKeyPassword = tlsClientKeyPassword;
    }

    public String getTlsClientCertPath() {
        return this.tlsClientCertPath;
    }

    public void setTlsClientCertPath(String tlsClientCertPath) {
        this.tlsClientCertPath = tlsClientCertPath;
    }
}

