/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.client.consumer;

import com.alibaba.fastjson.JSON;
import com.huawei.it.eip.ump.client.http.BodyStorageInfo;
import com.huawei.it.eip.ump.client.http.HttpFsClient;
import com.huawei.it.eip.ump.common.exception.UmpException;
import com.huawei.it.eip.ump.common.message.Message;
import com.huawei.it.eip.ump.common.util.CommonUtils;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;

public class ConsumerLargeBodyHelper {
    private HttpFsClient httpFsClient;

    protected ConsumerLargeBodyHelper(HttpFsClient httpFsClient) {
        this.httpFsClient = httpFsClient;
    }

    public static boolean isLargeBodyMessage(Message message) {
        return CommonUtils.isNotEmpty((String)message.getProperty("UmpLargeBodySize"));
    }

    private String parseFileUrl(Message message) {
        String bodyStr = new String(message.getBody(), Charset.forName("UTF-8"));
        BodyStorageInfo bs = (BodyStorageInfo)JSON.parseObject((String)bodyStr, BodyStorageInfo.class);
        String url = bs.getUrl();
        return url;
    }

    public byte[] fetchBody(Message message) throws UmpException {
        String largeBodySize = message.getProperty("UmpLargeBodySize");
        boolean compressed = CommonUtils.isNotEmpty((String)message.getProperty("UmpLargeBodyCompressed"));
        if (CommonUtils.isNotEmpty((String)largeBodySize)) {
            String url = null;
            try {
                url = this.parseFileUrl(message);
                HashMap<String, String> headers = new HashMap<String, String>();
                this.httpFsClient.addAuthHeaders(headers);
                byte[] data = compressed ? this.httpFsClient.downloadByUrlAndUncompress(url, headers) : this.httpFsClient.downloadByUrl(url, headers);
                return data;
            }
            catch (Exception e) {
                throw new UmpException("Failed to download large message body. " + url, (Throwable)e);
            }
        }
        return message.getBody();
    }

    public InputStream fetchLargeBodyAsInputStream(Message message) throws UmpException {
        String largeBodySize = message.getProperty("UmpLargeBodySize");
        if (CommonUtils.isNotEmpty((String)largeBodySize)) {
            try {
                String url = this.parseFileUrl(message);
                HashMap<String, String> headers = new HashMap<String, String>();
                this.httpFsClient.addAuthHeaders(headers);
                InputStream is = this.httpFsClient.downloadByUrlAsStream(url, headers);
                return is;
            }
            catch (Exception e) {
                throw new UmpException("Failed to download large message body.", (Throwable)e);
            }
        }
        return null;
    }
}

