/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.client.consumer;

import com.huawei.it.eip.ump.client.consumer.UmpMessageQueue;
import com.huawei.it.eip.ump.client.consumer.UmpPullResult;
import com.huawei.it.eip.ump.client.consumer.UmpPullStatus;
import java.util.HashSet;
import java.util.Set;
import org.apache.rocketmq.client.ext.consumer.PullResult;
import org.apache.rocketmq.client.ext.consumer.PullStatus;
import org.apache.rocketmq.common.message.MessageQueue;

class UmpConverter {
    UmpConverter() {
    }

    public static UmpMessageQueue convert(MessageQueue messageQueue) {
        return new UmpMessageQueue(messageQueue.getTopic(), messageQueue.getBrokerName(), messageQueue.getQueueId());
    }

    public static MessageQueue convert(UmpMessageQueue messageQueue) {
        return new MessageQueue(messageQueue.getTopic(), messageQueue.getBrokerName(), messageQueue.getQueueId());
    }

    public static Set<UmpMessageQueue> convert(Set<MessageQueue> set) {
        HashSet<UmpMessageQueue> all = new HashSet<UmpMessageQueue>();
        for (MessageQueue messageQueue : set) {
            UmpMessageQueue mq = UmpConverter.convert(messageQueue);
            all.add(mq);
        }
        return all;
    }

    public static UmpPullStatus convert(PullStatus pullStatus) {
        UmpPullStatus status = UmpPullStatus.NO_NEW_MSG;
        switch (pullStatus) {
            case FOUND: {
                status = UmpPullStatus.FOUND;
                break;
            }
            case NO_MATCHED_MSG: {
                status = UmpPullStatus.NO_MATCHED_MSG;
                break;
            }
            case OFFSET_ILLEGAL: {
                status = UmpPullStatus.OFFSET_ILLEGAL;
                break;
            }
        }
        return status;
    }

    public static UmpPullResult convert(PullResult pullResult) {
        UmpPullResult result = new UmpPullResult();
        result.setPullStatus(UmpConverter.convert(pullResult.getPullStatus()));
        result.setNextBeginOffset(pullResult.getNextBeginOffset());
        result.setMinOffset(pullResult.getMinOffset());
        result.setMaxOffset(pullResult.getMaxOffset());
        return result;
    }
}

