/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.client.http;

import com.huawei.it.eip.ump.client.http.ConnectionHolderInputStream;
import com.huawei.it.eip.ump.client.http.FsErrorRespException;
import com.huawei.it.eip.ump.client.http.TrustAnyHostnameVerifier;
import com.huawei.it.eip.ump.client.http.TrustAnyTrustManager;
import com.huawei.it.eip.ump.common.util.DigestUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class HttpFsClient {
    private static final int READ_BUF_SIZE = 4096;
    public static final String HEADER_APPID = "appid";
    public static final String HEADER_TOKEN = "token";
    public static final String HEADER_CONTENT_MD5 = "content-md5";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String DEFAULT_MIME = "application/octet-stream";
    public static final String CONTENT_LENGTH_HEADER = "Content-Length";
    public static final String POST_METHOD = "POST";
    public static final String GET_METHOD = "GET";
    private String serviceUrl;
    private String appid;
    private String token;
    private int connectTimeout = 3000;

    private void checkConfig() {
        String message = null;
        if (this.serviceUrl == null || this.serviceUrl.equals("")) {
            message = "config serviceUrl is required.";
        }
        if (this.appid == null || this.appid.equals("")) {
            message = "config appid is required.";
        }
        if (this.token == null || this.token.equals("")) {
            message = "config token is required.";
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public Map<String, String> getAuthHeaders() {
        return this.addAuthHeaders(null);
    }

    public Map<String, String> addAuthHeaders(Map<String, String> headers) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put(HEADER_APPID, this.appid);
        headers.put(HEADER_TOKEN, this.token);
        return headers;
    }

    public String buildUploadUrl(String serviceUrl, String md5) {
        return serviceUrl + "?md5=" + md5;
    }

    public String buildDownloadUrl(String serviceUrl, String fileid) {
        return serviceUrl + "/" + fileid;
    }

    public String buildUploadUrl(String md5) {
        return this.serviceUrl + "?md5=" + md5;
    }

    public String buildDownloadUrl(String fileid) {
        return this.serviceUrl + "/" + fileid;
    }

    public static void copyDataInStream(InputStream fromStream, OutputStream toStream) throws IOException {
        int l;
        byte[] data = new byte[4096];
        while ((l = fromStream.read(data)) != -1) {
            toStream.write(data, 0, l);
        }
    }

    public byte[] downloadById(String fileid) throws Exception {
        this.checkConfig();
        if (fileid == null || fileid.equals("")) {
            throw new IllegalArgumentException("fileid is null");
        }
        String url = this.buildDownloadUrl(fileid);
        Map<String, String> headers = this.getAuthHeaders();
        return this.downloadByUrl(url, headers);
    }

    public InputStream downloadByIdAsStream(String fileid) throws Exception {
        this.checkConfig();
        if (fileid == null || fileid.equals("")) {
            throw new IllegalArgumentException("fileid is null");
        }
        String url = this.buildDownloadUrl(fileid);
        Map<String, String> headers = this.getAuthHeaders();
        return this.downloadByUrlAsStream(url, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] downloadByUrl(String url, Map<String, String> headers) throws Exception {
        HttpURLConnection httpURLConnection = null;
        InputStream inputStream = null;
        try {
            byte[] data;
            httpURLConnection = this.createConnection(url, GET_METHOD, headers);
            int respCode = httpURLConnection.getResponseCode();
            if (respCode == 200) {
                inputStream = httpURLConnection.getInputStream();
                int contentLength = httpURLConnection.getContentLength();
                if (contentLength != -1) {
                    int l;
                    data = new byte[contentLength];
                    byte[] buf = new byte[4096];
                    int p = 0;
                    while ((l = inputStream.read(buf)) != -1) {
                        System.arraycopy(buf, 0, data, p, l);
                        p += l;
                    }
                } else {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    HttpFsClient.copyDataInStream(inputStream, byteArrayOutputStream);
                    data = byteArrayOutputStream.toByteArray();
                }
            } else {
                throw new Exception("Unexpected HTTP Response Status " + respCode);
            }
            byte[] byArray = data;
            return byArray;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] downloadByUrlAndUncompress(String url, Map<String, String> headers) throws Exception {
        HttpURLConnection httpURLConnection = null;
        InputStream inputStream = null;
        InflaterInputStream inflaterInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            httpURLConnection = this.createConnection(url, GET_METHOD, headers);
            int respCode = httpURLConnection.getResponseCode();
            if (respCode != 200) {
                throw new Exception("Unexpected HTTP Response Status " + respCode);
            }
            inputStream = httpURLConnection.getInputStream();
            inflaterInputStream = new InflaterInputStream(inputStream);
            byteArrayOutputStream = new ByteArrayOutputStream(0x400000);
            HttpFsClient.copyDataInStream(inflaterInputStream, byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byte[] data = byteArrayOutputStream.toByteArray();
            byte[] byArray = data;
            return byArray;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            if (inflaterInputStream != null) {
                try {
                    inflaterInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public InputStream downloadByUrlAsStream(String url, Map<String, String> headers) throws Exception {
        HttpURLConnection httpURLConnection = null;
        InputStream inputStream = null;
        httpURLConnection = this.createConnection(url, GET_METHOD, headers);
        int respCode = httpURLConnection.getResponseCode();
        if (respCode == 200) {
            inputStream = httpURLConnection.getInputStream();
            return new ConnectionHolderInputStream(inputStream, httpURLConnection);
        }
        throw new Exception("Unexpected HTTP Response Status " + respCode);
    }

    public String upload(byte[] content) throws Exception {
        this.checkConfig();
        if (content == null) {
            throw new IllegalArgumentException("inputStream content is null");
        }
        String md5 = DigestUtils.md5AsHex((byte[])content);
        Map<String, String> headers = this.getAuthHeaders();
        headers.put(HEADER_CONTENT_MD5, md5);
        return this.upload(this.buildUploadUrl(md5), content, headers);
    }

    public String upload(InputStream content, String md5) throws Exception {
        this.checkConfig();
        if (content == null) {
            throw new IllegalArgumentException("inputStream content is null");
        }
        if (md5 == null || md5.equals("")) {
            throw new IllegalArgumentException("content md5 is null");
        }
        String url = this.buildUploadUrl(md5);
        Map<String, String> headers = this.getAuthHeaders();
        headers.put(HEADER_CONTENT_MD5, md5);
        return this.upload(url, content, headers);
    }

    public String upload(String url, byte[] content, Map<String, String> headers) throws Exception {
        ByteArrayInputStream contentStream = new ByteArrayInputStream(content);
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put(CONTENT_LENGTH_HEADER, String.valueOf(content.length));
        return this.upload(url, contentStream, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String upload(String url, InputStream content, Map<String, String> headers) throws Exception {
        StringBuilder sb;
        block23: {
            sb = new StringBuilder();
            HttpURLConnection httpURLConnection = null;
            OutputStream outputStream = null;
            InputStream inputStream = null;
            BufferedReader bufferedReader = null;
            try {
                if (headers == null) {
                    headers = new HashMap<String, String>();
                }
                headers.put(CONTENT_TYPE_HEADER, DEFAULT_MIME);
                httpURLConnection = this.createConnection(url, POST_METHOD, headers);
                outputStream = httpURLConnection.getOutputStream();
                HttpFsClient.copyDataInStream(content, outputStream);
                outputStream.flush();
                int respCode = httpURLConnection.getResponseCode();
                if (respCode == 200) {
                    inputStream = httpURLConnection.getInputStream();
                    if (inputStream != null) {
                        String line;
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                        while ((line = bufferedReader.readLine()) != null) {
                            sb.append(line);
                        }
                    }
                    break block23;
                }
                throw new FsErrorRespException(respCode, "Unexpected HTTP Response Status " + respCode);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
        }
        return sb.toString();
    }

    private HttpURLConnection createConnection(String address, String method, Map<String, String> headers) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        boolean isSSL;
        URL url = new URL(address);
        URLConnection urlConnection = url.openConnection();
        HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
        boolean bl = isSSL = address.startsWith("https");
        if (isSSL) {
            TrustManager[] tm = new TrustManager[]{new TrustAnyTrustManager()};
            SSLContext sc = SSLContext.getInstance("SSL", "SunJSSE");
            sc.init(null, tm, new SecureRandom());
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)httpURLConnection;
            httpsURLConnection.setHostnameVerifier(new TrustAnyHostnameVerifier());
            httpsURLConnection.setSSLSocketFactory(sc.getSocketFactory());
        }
        httpURLConnection.setRequestProperty("User-Agent", this.getUserAgent());
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        httpURLConnection.setConnectTimeout(this.connectTimeout);
        httpURLConnection.setRequestMethod(method);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.connect();
        return httpURLConnection;
    }

    private String getUserAgent() {
        String version = System.getProperty("java.version");
        return "MQS/v2.0.1 Java/" + version;
    }

    public static int getReadBufSize() {
        return 4096;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }
}

