/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.client.namesrv;

import com.huawei.it.eip.ump.client.admin.UmpAdmin;
import com.huawei.it.eip.ump.client.config.ClientConfig;
import com.huawei.it.eip.ump.common.constant.UmpConstants;
import com.huawei.it.eip.ump.common.exception.UmpException;
import com.huawei.it.eip.ump.common.protocol.body.ConnectorInfo;
import com.huawei.it.eip.ump.common.protocol.body.ConnectorInfoWrapper;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.common.protocol.header.namesrv.GetKVConfigRequestHeader;
import org.apache.rocketmq.common.protocol.header.namesrv.GetKVConfigResponseHeader;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.RemotingClient;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyRemotingClient;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class NamesrvService
implements UmpAdmin {
    private ClientConfig clientConfig;
    private RemotingClient remotingClient = null;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    public static final String NS_FTS = "fts";
    public static final String KEY_FTS_URL = "fileServiceUrl";

    public NamesrvService(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.remotingClient = new NettyRemotingClient(new NettyClientConfig(), null);
    }

    public void start() {
        this.remotingClient.start();
    }

    public List<ConnectorInfo> fetchConnectorUrl(String umpNamesrvUrl) throws UmpException {
        List connectorInfoList = Collections.emptyList();
        try {
            byte[] body;
            RemotingCommand request = RemotingCommand.createRequestCommand((int)11, null);
            request.addExtField("client_ip_address", this.clientConfig.getClientIp());
            request.addExtField("app_id", this.clientConfig.getAppId());
            RemotingCommand response = this.remotingClient.invokeSync(umpNamesrvUrl, request, UmpConstants.TIMEOUT_MILLIS);
            if (0 == response.getCode() && (body = response.getBody()) != null) {
                ConnectorInfoWrapper connectorInfoWrapper = (ConnectorInfoWrapper)ConnectorInfoWrapper.decode((byte[])body, ConnectorInfoWrapper.class);
                connectorInfoList = connectorInfoWrapper.getConnectorInfoList();
            }
        }
        catch (Exception e) {
            throw new UmpException(String.format("fetchConnectorUrl from umpNamesrvUrl=%s encounter exception.", umpNamesrvUrl), (Throwable)e);
        }
        return connectorInfoList;
    }

    public String fetchFileServiceUrl(String umpNamesrvUrl) throws UmpException {
        String fileServiceUrl = null;
        try {
            GetKVConfigResponseHeader responseHeader;
            GetKVConfigRequestHeader customHeader = new GetKVConfigRequestHeader();
            customHeader.setNamespace(NS_FTS);
            customHeader.setKey(KEY_FTS_URL);
            RemotingCommand request = RemotingCommand.createRequestCommand((int)7, (CommandCustomHeader)customHeader);
            request.addExtField("client_ip_address", this.clientConfig.getClientIp());
            RemotingCommand response = this.remotingClient.invokeSync(umpNamesrvUrl, request, UmpConstants.TIMEOUT_MILLIS);
            if (0 == response.getCode() && (responseHeader = (GetKVConfigResponseHeader)response.decodeCommandCustomHeader(GetKVConfigResponseHeader.class)) != null) {
                fileServiceUrl = responseHeader.getValue();
            }
        }
        catch (Exception e) {
            throw new UmpException(String.format("fetchFileServiceUrl from umpNamesrvUrl=%s encounter exception.", umpNamesrvUrl), (Throwable)e);
        }
        return fileServiceUrl;
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    public void shutdown() {
        if (this.closed.compareAndSet(false, true)) {
            this.remotingClient.shutdown();
        }
    }
}

