/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.client.netty;

import com.huawei.it.eip.ump.client.AbstractClient;
import com.huawei.it.eip.ump.client.netty.UmpNettyRemotingClient;
import com.huawei.it.eip.ump.client.producer.Producer;
import java.util.HashSet;
import java.util.Set;
import org.apache.rocketmq.remoting.InvokeCallback;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.exception.RemotingTooMuchRequestException;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class UmpNettyProxyRemotingClient
extends UmpNettyRemotingClient {
    private static Set<Integer> PROXY_EXCLUDES = new HashSet<Integer>();

    public UmpNettyProxyRemotingClient(NettyClientConfig nettyClientConfig, AbstractClient umpClient) {
        super(nettyClientConfig, null, umpClient);
    }

    private String getConnectorAddr() {
        return null;
    }

    private void proxyRequestWrapper(String addr, RemotingCommand request, String invokeType) {
        assert (request != null);
        if (!PROXY_EXCLUDES.contains(request.getCode())) {
            request.addExtField("org_rq_code", request.getCode() + "");
            request.addExtField("org_srv_addr", addr);
            request.addExtField("invoke_type", invokeType);
            if (this.umpClient instanceof Producer) {
                request.addExtField("org_client_type", "pub");
            }
            request.setCode(918);
        }
    }

    @Override
    public RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        this.proxyRequestWrapper(addr, request, "s");
        return super.invokeSync(this.getConnectorAddr(), request, timeoutMillis);
    }

    @Override
    public void invokeAsync(String addr, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        this.proxyRequestWrapper(addr, request, "a");
        super.invokeAsync(this.getConnectorAddr(), request, timeoutMillis, invokeCallback);
    }

    @Override
    public void invokeOneway(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        this.proxyRequestWrapper(addr, request, "o");
        super.invokeOneway(this.getConnectorAddr(), request, timeoutMillis);
    }

    static {
        PROXY_EXCLUDES.add(18);
        PROXY_EXCLUDES.add(19);
        PROXY_EXCLUDES.add(919);
    }
}

