/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.it.eip.ump.client.producer;

import com.alibaba.fastjson.JSON;
import com.huawei.it.eip.ump.client.AbstractClient;
import com.huawei.it.eip.ump.client.admin.UmpAdmin;
import com.huawei.it.eip.ump.client.config.ClientConfigMap;
import com.huawei.it.eip.ump.client.http.BodyStorageInfo;
import com.huawei.it.eip.ump.client.http.FsErrorRespException;
import com.huawei.it.eip.ump.client.http.HttpFsClient;
import com.huawei.it.eip.ump.client.producer.SendResult;
import com.huawei.it.eip.ump.common.exception.UmpException;
import com.huawei.it.eip.ump.common.util.CommonUtils;
import com.huawei.it.eip.ump.common.util.DigestUtils;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.rocketmq.client.ext.exception.MQClientException;
import org.apache.rocketmq.client.ext.impl.MQClientManager;
import org.apache.rocketmq.client.ext.producer.DefaultMQProducer;
import org.apache.rocketmq.client.ext.producer.MessageQueueSelector;
import org.apache.rocketmq.client.ext.producer.SendStatus;
import org.apache.rocketmq.client.ext.producer.selector.SelectMessageQueueByHash;
import org.apache.rocketmq.common.ServiceState;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.Message;

public class Producer
extends AbstractClient
implements UmpAdmin {
    public static final long LARGE_BODY_MAX_SIZE = 524288000L;
    public static final String LARGE_BODY_COMPRESS_TYPE = "zip";
    private static final Pattern messageGroupIdPattern = Pattern.compile("^\\p{Graph}{1,128}$");
    protected HttpFsClient httpFsClient;
    private DefaultMQProducer defaultMQProducer;
    private SelectMessageQueueByHash selectMessageQueueByHash;
    private final AtomicLong sendFailedCounter = new AtomicLong(0L);
    private int resetChannelPeriodTimes = 3;

    public Producer() {
        this.clientLoginCode = 19;
        this.clientName = "producer";
        this.httpFsClient = new HttpFsClient();
        this.selectMessageQueueByHash = new SelectMessageQueueByHash();
    }

    protected com.huawei.it.eip.ump.common.message.Message processMessageBeforeSend(com.huawei.it.eip.ump.common.message.Message message) throws UmpException {
        message.clearProperty("UmpLargeBodySize");
        message.clearProperty("UmpLargeBodyCompressed");
        if (this.getFileServiceUrl() == null || "".equals(this.getFileServiceUrl())) {
            return message;
        }
        int bodySize = message.getBody().length;
        if (bodySize > this.maxMessageSize) {
            if ((long)bodySize > 524288000L) {
                throw new UmpException("Message body too large, more than limit 524288000");
            }
            boolean compressed = false;
            byte[] body = message.getBody();
            if (this.isCompressLargeBody()) {
                try {
                    byte[] data = UtilAll.compress((byte[])body, (int)5);
                    if (data != null) {
                        body = data;
                        compressed = true;
                    }
                }
                catch (IOException e) {
                    logger.error("compress message body exception", (Throwable)e);
                }
            }
            try {
                String md5 = DigestUtils.md5AsHex((byte[])body);
                String uploadUrl = this.httpFsClient.buildUploadUrl(this.getFileServiceUrl(), md5);
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("appid", this.getAppId());
                headers.put("token", this.getAppSecret());
                headers.put("content-md5", md5);
                String resp = null;
                for (int retries = 3; retries > 0; --retries) {
                    try {
                        resp = this.httpFsClient.upload(uploadUrl, body, headers);
                        break;
                    }
                    catch (Exception e) {
                        if (retries > 0) {
                            FsErrorRespException respException;
                            if (e instanceof SocketTimeoutException) continue;
                            if (e instanceof FsErrorRespException && ((respException = (FsErrorRespException)e).getStatusCode() == 400 || respException.getStatusCode() == 500)) {
                                Thread.sleep(1000L);
                                continue;
                            }
                        }
                        throw new UmpException("Upload large body httpFsClient exception, " + uploadUrl, (Throwable)e);
                    }
                }
                message.setBody(this.buildContentForLargeBody(resp).getBytes("UTF-8"));
                message.setProperty("UmpLargeBodySize", String.valueOf(bodySize));
                if (compressed) {
                    message.setProperty("UmpLargeBodyCompressed", LARGE_BODY_COMPRESS_TYPE);
                }
            }
            catch (Exception e) {
                throw new UmpException("Failed to upload large message body", (Throwable)e);
            }
        }
        return message;
    }

    protected String buildContentForLargeBody(String fileServiceResponse) {
        String fileid = fileServiceResponse.trim();
        BodyStorageInfo bs = new BodyStorageInfo();
        bs.setFileid(fileid);
        bs.setUrl(this.httpFsClient.buildDownloadUrl(this.getFileServiceUrl(), fileid));
        bs.setRemark("Original body is stored in File Service.");
        return JSON.toJSONString((Object)bs);
    }

    @Deprecated
    public SendResult send(com.huawei.it.eip.ump.common.message.Message message, Object hashObject) throws UmpException {
        if (hashObject != null) {
            message.setMessageGroupId(String.valueOf(hashObject));
        }
        return this.send(message);
    }

    public SendResult send(com.huawei.it.eip.ump.common.message.Message message) throws UmpException {
        return this.send(message, this.sendMsgTimeout);
    }

    public SendResult send(com.huawei.it.eip.ump.common.message.Message message, long timeoutMillis) throws UmpException {
        if (timeoutMillis < (long)this.sendMsgTimeout) {
            timeoutMillis = this.sendMsgTimeout;
        }
        if (message.getBody() == null || message.getBody().length == 0) {
            throw new UmpException("Message body is required.");
        }
        if (!CommonUtils.verifyTags((String)this.fixClientConfig.getTags(), (String)message.getTags())) {
            String errorMessage = String.format("Message tag[%s] must be contained in producer's tags[%s].", message.getTags(), this.fixClientConfig.getTags());
            throw new UmpException(errorMessage);
        }
        if (!this.verifyMessageGroupId(message.getMessageGroupId())) {
            throw new UmpException("messageGroupId should contains printable characters only (but no space), and max length is 128.");
        }
        if (this.defaultMQProducer == null) {
            throw new UmpException("Producer is not started.");
        }
        this.processMessageBeforeSend(message);
        try {
            org.apache.rocketmq.client.ext.producer.SendResult result = null;
            result = CommonUtils.isEmpty((String)message.getMessageGroupId()) ? this.defaultMQProducer.send((Message)this.toMqMessage(message), timeoutMillis) : this.defaultMQProducer.send((Message)this.toMqMessage(message), (MessageQueueSelector)this.selectMessageQueueByHash, (Object)message.getMessageGroupId(), timeoutMillis);
            SendResult sendResult = new SendResult();
            sendResult.setMessageId(message.getMessageId());
            sendResult.setBusinessId(message.getBusinessId());
            boolean isOkay = result.getSendStatus() == SendStatus.SEND_OK || result.getSendStatus() == SendStatus.SLAVE_NOT_AVAILABLE;
            sendResult.setSuccess(isOkay);
            return sendResult;
        }
        catch (Throwable e) {
            if (this.sendFailedCounter.incrementAndGet() % (long)this.resetChannelPeriodTimes == 0L) {
                this.resetCurrentChannel();
                logger.warn("Reset the current channel, failed count: {}.", (Object)this.sendFailedCounter.get());
            }
            throw new UmpException(e);
        }
    }

    private DefaultMQProducer createProducer() {
        String appId = this.getAppId();
        String formatedAppId = appId.replaceAll("[^%|a-zA-Z0-9_-]", "-");
        String topic = this.getTopic();
        String producerGroup = formatedAppId + "_" + topic;
        this.defaultMQProducer = new DefaultMQProducer(producerGroup);
        String instanceName = producerGroup + "_" + this.getInstanceName();
        instanceName = instanceName + "_" + CommonUtils.formatAppId((String)"v2.0.1");
        this.defaultMQProducer.setInstanceName(instanceName);
        this.defaultMQProducer.setMaxMessageSize(this.maxMessageSize);
        this.defaultMQProducer.setCompressMsgBodyOverHowmuch(this.compressSize);
        this.defaultMQProducer.setNamesrvAddr(this.getConnectorUrl());
        ClientConfigMap.put(this.defaultMQProducer.buildMQClientId(), this);
        return this.defaultMQProducer;
    }

    @Override
    protected void startClient() throws MQClientException {
        super.startClient();
        this.fetchFileServiceUrl();
        this.createProducer().start();
    }

    @Override
    protected void shutdownClient() {
        if (this.defaultMQProducer != null) {
            if (this.defaultMQProducer.getDefaultMQProducerImpl() != null && this.defaultMQProducer.getDefaultMQProducerImpl().getmQClientFactory() != null && this.defaultMQProducer.getDefaultMQProducerImpl().getmQClientFactory().getScheduledExecutorService() != null) {
                this.defaultMQProducer.getDefaultMQProducerImpl().getmQClientFactory().getScheduledExecutorService().shutdown();
            }
            if (ServiceState.START_FAILED == this.defaultMQProducer.getDefaultMQProducerImpl().getServiceState()) {
                MQClientManager.getInstance().removeClientFactory(this.defaultMQProducer.buildMQClientId());
            }
            this.defaultMQProducer.shutdown();
            this.defaultMQProducer = null;
        }
    }

    public boolean verifyMessageGroupId(String messageGroupId) {
        if (CommonUtils.isEmpty((String)messageGroupId)) {
            return true;
        }
        return messageGroupIdPattern.matcher(messageGroupId).matches();
    }

    public int getResetChannelPeriodTimes() {
        return this.resetChannelPeriodTimes;
    }

    public void setResetChannelPeriodTimes(int resetChannelPeriodTimes) {
        if (resetChannelPeriodTimes <= 0) {
            resetChannelPeriodTimes = 3;
        }
        this.resetChannelPeriodTimes = resetChannelPeriodTimes;
    }

    @Deprecated
    public boolean isKeepHeartBeat() {
        return false;
    }

    @Deprecated
    public void setKeepHeartBeat(boolean keepHeartBeat) {
    }

    @Override
    public void setTopic(String topic) {
        if (this.isStarted()) {
            logger.warn("Can not change the topic after producer has been stared.");
        } else {
            super.setTopic(topic);
        }
    }
}

