/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.ext.exception;

import com.huawei.it.eip.ump.common.exception.FAQUrl;
import org.apache.rocketmq.common.UtilAll;

public class MQClientException
extends Exception {
    private static final long serialVersionUID = -5758410930844185841L;
    private int responseCode;
    private String errorMessage;

    public MQClientException(String errorMessage, Throwable cause) {
        super(FAQUrl.attachDefaultURL((String)errorMessage), cause);
        this.responseCode = -1;
        this.errorMessage = errorMessage;
    }

    public MQClientException(int responseCode, String errorMessage) {
        super(FAQUrl.attachDefaultURL((String)("CODE: " + UtilAll.responseCode2String((int)responseCode) + "  DESC: " + errorMessage)));
        this.responseCode = responseCode;
        this.errorMessage = errorMessage;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public MQClientException setResponseCode(int responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

