/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.ext.trace.hook;

import java.util.ArrayList;
import org.apache.rocketmq.client.ext.hook.SendMessageContext;
import org.apache.rocketmq.client.ext.hook.SendMessageHook;
import org.apache.rocketmq.client.ext.producer.SendStatus;
import org.apache.rocketmq.client.ext.trace.AsyncTraceDispatcher;
import org.apache.rocketmq.client.ext.trace.TraceBean;
import org.apache.rocketmq.client.ext.trace.TraceContext;
import org.apache.rocketmq.client.ext.trace.TraceDispatcher;
import org.apache.rocketmq.client.ext.trace.TraceType;
import org.apache.rocketmq.common.protocol.NamespaceUtil;

public class SendMessageTraceHookImpl
implements SendMessageHook {
    private TraceDispatcher localDispatcher;

    public SendMessageTraceHookImpl(TraceDispatcher localDispatcher) {
        this.localDispatcher = localDispatcher;
    }

    @Override
    public String hookName() {
        return "SendMessageTraceHook";
    }

    @Override
    public void sendMessageBefore(SendMessageContext context) {
        if (context == null || context.getMessage().getTopic().startsWith(((AsyncTraceDispatcher)this.localDispatcher).getTraceTopicName())) {
            return;
        }
        TraceContext tuxeContext = new TraceContext();
        tuxeContext.setTraceBeans(new ArrayList<TraceBean>(1));
        context.setMqTraceContext(tuxeContext);
        tuxeContext.setTraceType(TraceType.Pub);
        tuxeContext.setGroupName(NamespaceUtil.withoutNamespace((String)context.getProducerGroup()));
        TraceBean traceBean = new TraceBean();
        traceBean.setTopic(NamespaceUtil.withoutNamespace((String)context.getMessage().getTopic()));
        traceBean.setTags(context.getMessage().getTags());
        traceBean.setKeys(context.getMessage().getKeys());
        traceBean.setStoreHost(context.getBrokerAddr());
        traceBean.setBodyLength(context.getMessage().getBody().length);
        traceBean.setMsgType(context.getMsgType());
        tuxeContext.getTraceBeans().add(traceBean);
    }

    @Override
    public void sendMessageAfter(SendMessageContext context) {
        if (context == null || context.getMessage().getTopic().startsWith(((AsyncTraceDispatcher)this.localDispatcher).getTraceTopicName()) || context.getMqTraceContext() == null) {
            return;
        }
        if (context.getSendResult() == null) {
            return;
        }
        if (context.getSendResult().getRegionId() == null || !context.getSendResult().isTraceOn()) {
            return;
        }
        TraceContext tuxeContext = (TraceContext)context.getMqTraceContext();
        TraceBean traceBean = tuxeContext.getTraceBeans().get(0);
        int costTime = (int)((System.currentTimeMillis() - tuxeContext.getTimeStamp()) / (long)tuxeContext.getTraceBeans().size());
        tuxeContext.setCostTime(costTime);
        if (context.getSendResult().getSendStatus().equals((Object)SendStatus.SEND_OK)) {
            tuxeContext.setSuccess(true);
        } else {
            tuxeContext.setSuccess(false);
        }
        tuxeContext.setRegionId(context.getSendResult().getRegionId());
        traceBean.setMsgId(context.getSendResult().getMsgId());
        traceBean.setOffsetMsgId(context.getSendResult().getOffsetMsgId());
        traceBean.setStoreTime(tuxeContext.getTimeStamp() + (long)(costTime / 2));
        this.localDispatcher.append(tuxeContext);
    }
}

