/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.ext.utils;

import org.apache.rocketmq.client.ext.exception.MQClientException;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageAccessor;

public class MessageUtil {
    public static Message createReplyMessage(Message requestMessage, byte[] body) throws MQClientException {
        if (requestMessage != null) {
            Message replyMessage = new Message();
            String cluster = requestMessage.getProperty("CLUSTER");
            String replyTo = requestMessage.getProperty("REPLY_TO_CLIENT");
            String correlationId = requestMessage.getProperty("CORRELATION_ID");
            String ttl = requestMessage.getProperty("TTL");
            replyMessage.setBody(body);
            if (cluster != null) {
                String replyTopic = MixAll.getReplyTopic((String)cluster);
                replyMessage.setTopic(replyTopic);
                MessageAccessor.putProperty((Message)replyMessage, (String)"MSG_TYPE", (String)"reply");
                MessageAccessor.putProperty((Message)replyMessage, (String)"CORRELATION_ID", (String)correlationId);
                MessageAccessor.putProperty((Message)replyMessage, (String)"REPLY_TO_CLIENT", (String)replyTo);
                MessageAccessor.putProperty((Message)replyMessage, (String)"TTL", (String)ttl);
                return replyMessage;
            }
            throw new MQClientException(10007, "create reply message fail, requestMessage error, property[CLUSTER] is null.");
        }
        throw new MQClientException(10007, "create reply message fail, requestMessage cannot be null.");
    }

    public static String getReplyToClient(Message msg) {
        return msg.getProperty("REPLY_TO_CLIENT");
    }
}

