/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.RegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.annotation.Name;

public class RewriteRegexRule
extends RegexRule
implements Rule.ApplyURI {
    private String _replacement;
    private String _query;
    private boolean _queryGroup;

    public RewriteRegexRule() {
        this(null, null);
    }

    public RewriteRegexRule(@Name(value="regex") String regex, @Name(value="replacement") String replacement) {
        super(regex);
        this.setHandling(false);
        this.setTerminating(false);
        this.setReplacement(replacement);
    }

    public void setReplacement(String replacement) {
        if (replacement == null) {
            this._replacement = null;
            this._query = null;
            this._queryGroup = false;
        } else {
            String[] split = replacement.split("\\?", 2);
            this._replacement = split[0];
            this._query = split.length == 2 ? split[1] : null;
            this._queryGroup = this._query != null && this._query.contains("$Q");
        }
    }

    @Override
    public String apply(String target, HttpServletRequest request, HttpServletResponse response, Matcher matcher) throws IOException {
        target = this._replacement;
        String query = this._query;
        for (int g = 1; g <= matcher.groupCount(); ++g) {
            String group = matcher.group(g);
            group = group == null ? "" : Matcher.quoteReplacement(group);
            target = target.replaceAll("\\$" + g, group);
            if (query == null) continue;
            query = query.replaceAll("\\$" + g, group);
        }
        if (query != null) {
            if (this._queryGroup) {
                query = query.replace("$Q", request.getQueryString() == null ? "" : request.getQueryString());
            }
            request.setAttribute("org.eclipse.jetty.rewrite.handler.RewriteRegexRule.Q", query);
        }
        return target;
    }

    @Override
    public void applyURI(Request request, String oldURI, String newURI) throws IOException {
        if (this._query == null) {
            request.setURIPathQuery(newURI);
        } else {
            String query = (String)request.getAttribute("org.eclipse.jetty.rewrite.handler.RewriteRegexRule.Q");
            if (!this._queryGroup && request.getQueryString() != null) {
                query = request.getQueryString() + "&" + query;
            }
            request.setURIPathQuery(newURI);
            request.setQueryString(query);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this._replacement + "]";
    }
}

