/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.BooleanPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;

public final class BooleanPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<BooleanPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new BooleanPrototypeBuiltins();

    protected BooleanPrototypeBuiltins() {
        super("Boolean.prototype", BooleanPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, BooleanPrototype builtinEnum) {
        switch (builtinEnum) {
            case toString: {
                return BooleanPrototypeBuiltinsFactory.JSBooleanToStringNodeGen.create(context, builtin, BooleanPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case valueOf: {
                return BooleanPrototypeBuiltinsFactory.JSBooleanValueOfNodeGen.create(context, builtin, BooleanPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSBooleanValueOfNode
    extends JSBuiltinNode {
        public JSBooleanValueOfNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSBoolean(thisObj)"})
        protected boolean valueOf(DynamicObject thisObj) {
            return JSBoolean.valueOf(thisObj);
        }

        @Specialization(guards={"isBoolean(thisObj)"})
        protected boolean valueOfPrimitive(Object thisObj) {
            return (Boolean)thisObj;
        }

        @Specialization(guards={"isForeignObject(thisObj)"}, limit="InteropLibraryLimit")
        protected boolean valueOfForeignObject(Object thisObj, @CachedLibrary(value="thisObj") InteropLibrary interop) {
            if (interop.isBoolean(thisObj)) {
                try {
                    return interop.asBoolean(thisObj);
                }
                catch (UnsupportedMessageException ex) {
                    throw Errors.createTypeErrorUnboxException(thisObj, (InteropException)((Object)ex), this);
                }
            }
            return this.valueOfOther(thisObj);
        }

        @Fallback
        protected boolean valueOfOther(Object thisObj) {
            throw JSBoolean.noBooleanError();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSBooleanToStringNode
    extends JSBuiltinNode {
        public JSBooleanToStringNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSBoolean(thisObj)"})
        protected String toString(DynamicObject thisObj) {
            return String.valueOf(JSBoolean.valueOf(thisObj));
        }

        @Specialization(guards={"isBoolean(thisObj)"})
        protected String toStringPrimitive(Object thisObj) {
            return JSRuntime.booleanToString((Boolean)thisObj);
        }

        @Specialization(guards={"isForeignObject(thisObj)"}, limit="InteropLibraryLimit")
        protected String toStringForeignObject(Object thisObj, @CachedLibrary(value="thisObj") InteropLibrary interop) {
            if (interop.isBoolean(thisObj)) {
                try {
                    return JSRuntime.booleanToString(interop.asBoolean(thisObj));
                }
                catch (UnsupportedMessageException ex) {
                    throw Errors.createTypeErrorUnboxException(thisObj, (InteropException)((Object)ex), this);
                }
            }
            return this.toStringOther(thisObj);
        }

        @Fallback
        protected String toStringOther(Object thisObj) {
            throw JSBoolean.noBooleanError();
        }
    }

    public static enum BooleanPrototype implements BuiltinEnum<BooleanPrototype>
    {
        toString(0),
        valueOf(0);

        private final int length;

        private BooleanPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

