/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser.env;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.parser.env.Environment;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import java.util.Objects;

public final class BlockEnvironment
extends Environment {
    private final FrameDescriptor blockFrameDescriptor;
    private final FrameSlot parentSlot;
    private final int scopeLevel;
    private final FrameSlot[] parentSlots;
    private final boolean isFunctionBlock;

    public BlockEnvironment(Environment parent, NodeFactory factory, JSContext context, boolean isFunctionBlock) {
        super(parent, factory, context);
        this.blockFrameDescriptor = factory.createBlockFrameDescriptor();
        this.parentSlot = Objects.requireNonNull(this.blockFrameDescriptor.findFrameSlot(ScopeFrameNode.PARENT_SCOPE_IDENTIFIER));
        this.scopeLevel = parent.getScopeLevel() + 1;
        this.parentSlots = BlockEnvironment.prepend(parent.getParentSlots(), this.parentSlot);
        assert (this.parentSlots.length == this.scopeLevel);
        this.isFunctionBlock = isFunctionBlock;
        parent.function().getOrCreateBlockScopeSlot();
    }

    public BlockEnvironment(Environment parent, NodeFactory factory, JSContext context) {
        this(parent, factory, context, false);
    }

    @Override
    public FrameSlot findBlockFrameSlot(Object name) {
        FrameSlot slot = this.getBlockFrameDescriptor().findFrameSlot(name);
        if (slot != null && JSFrameUtil.isPrivateName(slot)) {
            return null;
        }
        return slot;
    }

    @Override
    public FrameDescriptor getBlockFrameDescriptor() {
        return this.blockFrameDescriptor;
    }

    public FrameSlot getParentSlot() {
        return this.parentSlot;
    }

    @Override
    public int getScopeLevel() {
        return this.scopeLevel;
    }

    @Override
    public FrameSlot[] getParentSlots() {
        return this.parentSlots;
    }

    @Override
    public FrameSlot getCurrentBlockScopeSlot() {
        return this.function().getBlockScopeSlot();
    }

    public boolean isFunctionBlock() {
        return this.isFunctionBlock;
    }

    private static FrameSlot[] prepend(FrameSlot[] srcArray, FrameSlot newSlot) {
        FrameSlot[] newArray = new FrameSlot[srcArray.length + 1];
        newArray[0] = newSlot;
        System.arraycopy(srcArray, 0, newArray, 1, srcArray.length);
        return newArray;
    }
}

