/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser.env;

import com.oracle.js.parser.ir.Symbol;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.ReadNode;
import com.oracle.truffle.js.nodes.RepeatableNode;
import com.oracle.truffle.js.nodes.access.EvalVariableNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.access.WritePropertyNode;
import com.oracle.truffle.js.parser.env.BlockEnvironment;
import com.oracle.truffle.js.parser.env.DebugEnvironment;
import com.oracle.truffle.js.parser.env.FunctionEnvironment;
import com.oracle.truffle.js.parser.env.GlobalEnvironment;
import com.oracle.truffle.js.parser.env.WithEnvironment;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.util.InternalSlotId;
import com.oracle.truffle.js.runtime.util.Pair;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public abstract class Environment {
    public static final String ARGUMENTS_NAME = "arguments";
    public static final String THIS_NAME = "this";
    public static final String SUPER_NAME = "super";
    public static final String NEW_TARGET_NAME = "new.target";
    private final Environment parent;
    private final FunctionEnvironment functionEnvironment;
    protected final NodeFactory factory;
    protected final JSContext context;

    public Environment(Environment parent, NodeFactory factory, JSContext context) {
        this.parent = parent;
        this.factory = factory;
        this.context = context;
        this.functionEnvironment = this instanceof FunctionEnvironment ? (FunctionEnvironment)this : (parent == null ? null : parent.functionEnvironment);
    }

    public FrameSlot declareLocalVar(Object name) {
        return this.function().declareLocalVar(name);
    }

    public boolean hasLocalVar(Object name) {
        return this.getFunctionFrameDescriptor().findFrameSlot(name) != null;
    }

    public VarRef findThisVar() {
        return this.findInternalSlot("<this>", true);
    }

    public void reserveThisSlot() {
        this.getBlockFrameDescriptor().findOrAddFrameSlot((Object)"<this>");
    }

    public VarRef findSuperVar() {
        assert (!this.function().isGlobal());
        return this.findInternalSlot("<super>");
    }

    public void reserveSuperSlot() {
        this.getBlockFrameDescriptor().findOrAddFrameSlot((Object)"<super>");
    }

    public VarRef findArgumentsVar() {
        assert (!this.function().isGlobal());
        return this.findInternalSlot("<arguments>");
    }

    public void reserveArgumentsSlot() {
        this.getBlockFrameDescriptor().findOrAddFrameSlot((Object)"<arguments>");
    }

    public VarRef findNewTargetVar() {
        assert (!this.function().isGlobal());
        return this.findInternalSlot("<new.target>");
    }

    public void reserveNewTargetSlot() {
        this.getBlockFrameDescriptor().findOrAddFrameSlot((Object)"<new.target>");
    }

    public VarRef findAsyncContextVar() {
        assert (!this.function().isGlobal() || this.function().isAsyncGeneratorFunction());
        this.declareLocalVar("<asynccontext>");
        return this.findInternalSlot("<asynccontext>");
    }

    public VarRef findAsyncResultVar() {
        assert (!this.function().isGlobal() || this.function().isAsyncGeneratorFunction());
        this.declareLocalVar("<asyncresult>");
        return this.findInternalSlot("<asyncresult>");
    }

    public VarRef findYieldValueVar() {
        assert (!this.function().isGlobal());
        this.declareLocalVar("<yieldvalue>");
        return this.findInternalSlot("<yieldvalue>");
    }

    public VarRef findDynamicScopeVar() {
        assert (!this.function().isGlobal());
        return this.findInternalSlot("<evalscope>");
    }

    public void reserveDynamicScopeSlot() {
        assert (!this.function().isGlobal());
        this.getBlockFrameDescriptor().findOrAddFrameSlot((Object)"<evalscope>");
    }

    public FrameSlot declareInternalSlot(Object name) {
        assert (name instanceof String || name instanceof InternalSlotId) : name;
        return this.getBlockFrameDescriptor().findOrAddFrameSlot(name);
    }

    public final JavaScriptNode createLocal(FrameSlot frameSlot, int frameLevel, int scopeLevel) {
        return this.factory.createReadFrameSlot(frameSlot, this.factory.createScopeFrame(frameLevel, scopeLevel, this.getParentSlots(frameLevel, scopeLevel), this.getBlockScopeSlot(frameLevel, scopeLevel)), false);
    }

    public final VarRef findInternalSlot(Object name) {
        return this.findInternalSlot(name, false);
    }

    protected final VarRef findInternalSlot(Object name, boolean allowDebug) {
        Environment current = this;
        int frameLevel = 0;
        int scopeLevel = 0;
        do {
            FrameSlot slot;
            if ((slot = current.findBlockFrameSlot(name)) != null) {
                return new FrameSlotVarRef(slot, scopeLevel, frameLevel, name, current);
            }
            if (current instanceof FunctionEnvironment) {
                ++frameLevel;
                scopeLevel = 0;
                continue;
            }
            if (current instanceof BlockEnvironment) {
                ++scopeLevel;
                continue;
            }
            if (!(current instanceof DebugEnvironment) || !(name instanceof String) || !allowDebug || !((DebugEnvironment)current).hasMember((String)name)) continue;
            return new DebugVarRef((String)name, frameLevel);
        } while ((current = current.getParent()) != null);
        return null;
    }

    public final VarRef findLocalVar(String name) {
        return this.findVar(name, true, true, false, true, true);
    }

    public final VarRef findVar(String name, boolean skipWith) {
        return this.findVar(name, skipWith, skipWith, false, false, false);
    }

    public final VarRef findVar(String name, boolean skipWith, boolean skipEval, boolean skipBlockScoped, boolean skipGlobal, boolean skipMapped) {
        assert (!name.equals("null"));
        Environment current = this;
        int frameLevel = 0;
        int scopeLevel = 0;
        WrapClosure wrapClosure = null;
        int wrapFrameLevel = 0;
        do {
            if (current instanceof WithEnvironment) {
                if (skipWith) continue;
                wrapClosure = this.makeWithWrapClosure(wrapClosure, name, ((WithEnvironment)current).getWithVarIdentifier());
                wrapFrameLevel = frameLevel;
                continue;
            }
            if (current instanceof GlobalEnvironment) {
                GlobalEnvironment globalEnv = (GlobalEnvironment)current;
                if (globalEnv.hasLexicalDeclaration(name) && !GlobalEnvironment.isGlobalObjectConstant(name)) {
                    return this.wrapIn(wrapClosure, wrapFrameLevel, new GlobalLexVarRef(name, globalEnv.hasConstDeclaration(name)));
                }
                if (globalEnv.hasVarDeclaration(name) || GlobalEnvironment.isGlobalObjectConstant(name)) continue;
                wrapClosure = this.makeGlobalWrapClosure(wrapClosure, name);
                continue;
            }
            if (current instanceof DebugEnvironment) {
                if (!((DebugEnvironment)current).hasMember(name)) continue;
                wrapClosure = this.makeDebugWrapClosure(wrapClosure, name, frameLevel);
                wrapFrameLevel = frameLevel;
                continue;
            }
            FrameSlot slot = current.findBlockFrameSlot(name);
            if (!(slot == null || skipBlockScoped && (JSFrameUtil.isConst(slot) || JSFrameUtil.isLet(slot)))) {
                AbstractFrameVarRef varRef;
                if (!skipMapped && Environment.isMappedArgumentsParameter(slot, current)) {
                    varRef = new MappedArgumentVarRef(slot, scopeLevel, frameLevel, name, current);
                } else if (JSFrameUtil.isArguments(slot)) {
                    assert (!(current.function().isArrowFunction() || current.function().isGlobal() || current.function().isEval()));
                    varRef = new ArgumentsVarRef(slot, scopeLevel, frameLevel, name, current);
                } else {
                    varRef = new FrameSlotVarRef(slot, scopeLevel, frameLevel, name, current);
                }
                return this.wrapIn(wrapClosure, wrapFrameLevel, varRef);
            }
            if (!skipEval && current.function().isDynamicallyScoped() && current.findBlockFrameSlot("<evalscope>") != null) {
                wrapClosure = this.makeEvalWrapClosure(wrapClosure, name, frameLevel, scopeLevel, current);
                wrapFrameLevel = frameLevel;
            }
            if (current instanceof FunctionEnvironment) {
                FunctionEnvironment fnEnv = current.function();
                if (fnEnv.isNamedFunctionExpression() && fnEnv.getFunctionName().equals(name)) {
                    return this.wrapIn(wrapClosure, wrapFrameLevel, new FunctionCalleeVarRef(scopeLevel, frameLevel, name, current));
                }
                ++frameLevel;
                scopeLevel = 0;
                continue;
            }
            if (!(current instanceof BlockEnvironment)) continue;
            ++scopeLevel;
        } while ((current = current.getParent()) != null);
        if (skipGlobal) {
            return null;
        }
        return this.wrapIn(wrapClosure, wrapFrameLevel, new GlobalVarRef(name));
    }

    void ensureFrameLevelAvailable(int frameLevel) {
        int level = 0;
        for (FunctionEnvironment currentFunction = this.function(); currentFunction != null && level < frameLevel; currentFunction = currentFunction.getParentFunction(), ++level) {
            currentFunction.setNeedsParentFrame(true);
        }
    }

    private WrapClosure makeEvalWrapClosure(WrapClosure wrapClosure, final String name, final int frameLevel, final int scopeLevel, final Environment current) {
        final FrameSlot dynamicScopeSlot = current.findBlockFrameSlot("<evalscope>");
        assert (dynamicScopeSlot != null);
        return WrapClosure.compose(wrapClosure, new WrapClosure(){

            @Override
            public JavaScriptNode apply(JavaScriptNode delegateNode, WrapAccess access) {
                JSTargetableNode scopeAccessNode;
                JavaScriptNode dynamicScopeNode = new FrameSlotVarRef(dynamicScopeSlot, scopeLevel, frameLevel, "<evalscope>", current).createReadNode();
                if (access == WrapAccess.Delete) {
                    scopeAccessNode = Environment.this.factory.createDeleteProperty(null, Environment.this.factory.createConstantString(name), Environment.this.isStrictMode(), Environment.this.context);
                } else if (access == WrapAccess.Write) {
                    assert (delegateNode instanceof WriteNode) : delegateNode;
                    scopeAccessNode = Environment.this.factory.createWriteProperty(null, name, null, Environment.this.context, Environment.this.isStrictMode());
                } else if (access == WrapAccess.Read) {
                    assert (delegateNode instanceof ReadNode || delegateNode instanceof RepeatableNode) : delegateNode;
                    scopeAccessNode = Environment.this.factory.createReadProperty(Environment.this.context, null, name);
                } else {
                    throw new IllegalArgumentException();
                }
                return new EvalVariableNode(Environment.this.context, name, delegateNode, dynamicScopeNode, scopeAccessNode);
            }
        });
    }

    private WrapClosure makeWithWrapClosure(WrapClosure wrapClosure, final String name, final Object withVarName) {
        return WrapClosure.compose(wrapClosure, new WrapClosure(){

            @Override
            public JavaScriptNode apply(JavaScriptNode delegateNode, WrapAccess access) {
                JSTargetableNode withAccessNode;
                VarRef withVarNameRef = Objects.requireNonNull(Environment.this.findInternalSlot(withVarName));
                if (access == WrapAccess.Delete) {
                    withAccessNode = Environment.this.factory.createDeleteProperty(null, Environment.this.factory.createConstantString(name), Environment.this.isStrictMode(), Environment.this.context);
                } else if (access == WrapAccess.Write) {
                    assert (delegateNode instanceof WriteNode) : delegateNode;
                    withAccessNode = Environment.this.factory.createWriteProperty(null, name, null, Environment.this.context, Environment.this.isStrictMode(), false, true);
                } else if (access == WrapAccess.Read) {
                    assert (delegateNode instanceof ReadNode || delegateNode instanceof RepeatableNode) : delegateNode;
                    withAccessNode = Environment.this.factory.createReadProperty(Environment.this.context, null, name);
                } else {
                    throw new IllegalArgumentException();
                }
                JavaScriptNode withTarget = Environment.this.factory.createWithTarget(Environment.this.context, name, withVarNameRef.createReadNode());
                return Environment.this.factory.createWithVarWrapper(name, withTarget, withAccessNode, delegateNode);
            }

            @Override
            public Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> applyCompound(Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> suppliers) {
                VarRef withTargetTempVar = Environment.this.createTempVar();
                VarRef withObjVar = Objects.requireNonNull(Environment.this.findInternalSlot(withVarName));
                Supplier<JavaScriptNode> innerReadSupplier = suppliers.getFirst();
                UnaryOperator<JavaScriptNode> innerWriteSupplier = suppliers.getSecond();
                Supplier<JavaScriptNode> readSupplier = () -> {
                    JSTargetableNode readWithProperty = Environment.this.factory.createReadProperty(Environment.this.context, null, name);
                    return Environment.this.factory.createWithVarWrapper(name, withTargetTempVar.createReadNode(), readWithProperty, (JavaScriptNode)((Object)((Object)innerReadSupplier.get())));
                };
                UnaryOperator writeSupplier = rhs -> {
                    JavaScriptNode withTarget = Environment.this.factory.createWithTarget(Environment.this.context, name, withObjVar.createReadNode());
                    WritePropertyNode writeWithProperty = Environment.this.factory.createWriteProperty(null, name, null, Environment.this.context, Environment.this.isStrictMode(), false, true);
                    return Environment.this.factory.createWithVarWrapper(name, withTargetTempVar.createWriteNode(withTarget), writeWithProperty, (JavaScriptNode)((Object)((Object)innerWriteSupplier.apply((JavaScriptNode)((Object)rhs)))));
                };
                return new Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>>(readSupplier, writeSupplier);
            }
        });
    }

    private WrapClosure makeGlobalWrapClosure(WrapClosure wrapClosure, final String name) {
        return WrapClosure.compose(wrapClosure, new WrapClosure(){

            @Override
            public JavaScriptNode apply(JavaScriptNode delegateNode, WrapAccess access) {
                JSTargetableNode scopeAccessNode;
                if (access == WrapAccess.Delete) {
                    scopeAccessNode = Environment.this.factory.createDeleteProperty(null, Environment.this.factory.createConstantString(name), Environment.this.isStrictMode(), Environment.this.context);
                } else if (access == WrapAccess.Write) {
                    assert (delegateNode instanceof WriteNode) : delegateNode;
                    scopeAccessNode = Environment.this.factory.createWriteProperty(null, name, null, Environment.this.context, true);
                } else if (access == WrapAccess.Read) {
                    assert (delegateNode instanceof ReadNode || delegateNode instanceof RepeatableNode) : delegateNode;
                    scopeAccessNode = Environment.this.factory.createReadProperty(Environment.this.context, null, name);
                } else {
                    throw new IllegalArgumentException();
                }
                JavaScriptNode globalScope = Environment.this.factory.createGlobalScope(Environment.this.context);
                return Environment.this.factory.createGlobalVarWrapper(name, delegateNode, globalScope, scopeAccessNode);
            }
        });
    }

    private WrapClosure makeDebugWrapClosure(WrapClosure wrapClosure, final String name, final int frameLevel) {
        this.ensureFrameLevelAvailable(frameLevel);
        return WrapClosure.compose(wrapClosure, new WrapClosure(){

            @Override
            public JavaScriptNode apply(JavaScriptNode delegateNode, WrapAccess access) {
                JSTargetableNode scopeAccessNode;
                if (access == WrapAccess.Delete) {
                    scopeAccessNode = Environment.this.factory.createDeleteProperty(null, Environment.this.factory.createConstantString(name), Environment.this.isStrictMode(), Environment.this.context);
                } else if (access == WrapAccess.Write) {
                    assert (delegateNode instanceof WriteNode) : delegateNode;
                    scopeAccessNode = Environment.this.factory.createWriteProperty(null, name, null, Environment.this.context, true);
                } else if (access == WrapAccess.Read) {
                    assert (delegateNode instanceof ReadNode || delegateNode instanceof RepeatableNode) : delegateNode;
                    scopeAccessNode = Environment.this.factory.createReadProperty(Environment.this.context, null, name);
                } else {
                    throw new IllegalArgumentException();
                }
                JavaScriptNode debugScope = Environment.this.factory.createDebugScope(Environment.this.context, Environment.this.factory.createAccessCallee(frameLevel - 1));
                return Environment.this.factory.createDebugVarWrapper(name, delegateNode, debugScope, scopeAccessNode);
            }
        });
    }

    private VarRef wrapIn(WrapClosure wrapClosure, int wrapFrameLevel, VarRef wrappee) {
        if (wrapClosure != null) {
            this.ensureFrameLevelAvailable(wrapFrameLevel);
            return new WrappedVarRef(wrappee.getName(), wrappee, wrapClosure);
        }
        return wrappee;
    }

    protected abstract FrameSlot findBlockFrameSlot(Object var1);

    public FrameDescriptor getBlockFrameDescriptor() {
        throw this.unsupported();
    }

    private static boolean isMappedArgumentsParameter(FrameSlot slot, Environment current) {
        FunctionEnvironment function = current.function();
        return function.hasMappedParameters() && !function.isStrictMode() && function.hasSimpleParameterList() && JSFrameUtil.isParam(slot);
    }

    public final Environment getParent() {
        return this.parent;
    }

    public final FunctionEnvironment function() {
        return this.functionEnvironment;
    }

    public final Environment getParentAt(int frameLevel, int scopeLevel) {
        Environment current = this;
        int currentFrameLevel = 0;
        int currentScopeLevel = 0;
        do {
            if (currentFrameLevel == frameLevel && currentScopeLevel == scopeLevel) {
                return current;
            }
            if (current instanceof FunctionEnvironment) {
                ++currentFrameLevel;
                currentScopeLevel = 0;
                continue;
            }
            if (!(current instanceof BlockEnvironment)) continue;
            ++currentScopeLevel;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public VarRef createTempVar() {
        FrameSlot var = this.declareTempVar("tmp");
        return this.findTempVar(var);
    }

    public VarRef findTempVar(final FrameSlot var) {
        return new VarRef(var.getIdentifier()){

            @Override
            public boolean isGlobal() {
                return false;
            }

            @Override
            public boolean isFunctionLocal() {
                return false;
            }

            @Override
            public FrameSlot getFrameSlot() {
                return var;
            }

            @Override
            public JavaScriptNode createReadNode() {
                return Environment.this.factory.createReadCurrentFrameSlot(var);
            }

            @Override
            public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
                return Environment.this.factory.createWriteCurrentFrameSlot(var, Environment.this.getFunctionFrameDescriptor(), rhs);
            }

            @Override
            public JavaScriptNode createDeleteNode() {
                throw Errors.shouldNotReachHere();
            }
        };
    }

    private FrameSlot declareTempVar(String prefix) {
        return this.declareLocalVar(this.factory.createInternalSlotId(prefix, this.getFunctionFrameDescriptor().getSize()));
    }

    public FrameDescriptor getFunctionFrameDescriptor() {
        return this.function().getFunctionFrameDescriptor();
    }

    public boolean isStrictMode() {
        return this.function().isStrictMode();
    }

    public int getScopeLevel() {
        throw this.unsupported();
    }

    public FrameSlot[] getParentSlots() {
        throw this.unsupported();
    }

    private UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException(this.getClass().getName());
    }

    public final FrameSlot[] getParentSlots(int frameLevel, int scopeLevel) {
        if (scopeLevel == 0) {
            return ScopeFrameNode.EMPTY_FRAME_SLOT_ARRAY;
        }
        Environment current = this;
        for (int currentFrameLevel = frameLevel; currentFrameLevel > 0; --currentFrameLevel) {
            current = current.function().getParent();
        }
        while (current != null) {
            if (current instanceof BlockEnvironment) {
                FrameSlot[] parentSlots = current.getParentSlots();
                assert (parentSlots.length >= scopeLevel);
                if (parentSlots.length == scopeLevel) {
                    return parentSlots;
                }
                return Arrays.copyOf(parentSlots, scopeLevel);
            }
            current = current.getParent();
        }
        return ScopeFrameNode.EMPTY_FRAME_SLOT_ARRAY;
    }

    public final FrameSlot getBlockScopeSlot(int frameLevel, int scopeLevel) {
        Environment current = this;
        for (int currentFrameLevel = frameLevel; currentFrameLevel > 0; --currentFrameLevel) {
            current = current.function().getParent();
        }
        int currentScopeLevel = scopeLevel;
        while (current != null) {
            if (current instanceof FunctionEnvironment) {
                assert (currentScopeLevel == 0);
                return null;
            }
            if (current instanceof BlockEnvironment) {
                if (currentScopeLevel == 0) {
                    return this.function().getBlockScopeSlot();
                }
                --currentScopeLevel;
            }
            current = current.getParent();
        }
        return null;
    }

    public FrameSlot getCurrentBlockScopeSlot() {
        return null;
    }

    public void addFrameSlotsFromSymbols(Iterable<Symbol> symbols) {
        this.addFrameSlotsFromSymbols(symbols, false, null);
    }

    public void addFrameSlotsFromSymbols(Iterable<Symbol> symbols, boolean onlyBlockScoped, Predicate<Symbol> filter) {
        for (Symbol symbol : symbols) {
            if (!symbol.isBlockScoped() && (onlyBlockScoped || !symbol.isVar() || symbol.isGlobal()) || filter != null && !filter.test(symbol)) continue;
            this.addFrameSlotFromSymbol(symbol);
        }
    }

    public void addFrameSlotFromSymbol(Symbol symbol) {
        assert (!this.getBlockFrameDescriptor().getIdentifiers().contains(symbol.getName()) || this instanceof FunctionEnvironment);
        int flags = symbol.getFlags() & 0x3E4113;
        this.getBlockFrameDescriptor().findOrAddFrameSlot((Object)symbol.getName(), (Object)FrameSlotFlags.of(flags), FrameSlotKind.Illegal);
    }

    public boolean isDynamicallyScoped() {
        return false;
    }

    public boolean isDynamicScopeContext() {
        return this.getParent() == null ? false : this.getParent().isDynamicScopeContext();
    }

    public Environment getVariableEnvironment() {
        return this.function().getVariableEnvironment();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Environment current = this;
        int frameLevel = 0;
        int scopeLevel = 0;
        do {
            if (current instanceof FunctionEnvironment) {
                sb.append("Function").append("(").append(frameLevel).append(")");
                sb.append(current.getFunctionFrameDescriptor().getIdentifiers().toString());
                ++frameLevel;
                scopeLevel = 0;
            } else if (current instanceof BlockEnvironment) {
                sb.append("Block").append("(").append(frameLevel).append(", ").append(scopeLevel).append(")");
                sb.append(current.getBlockFrameDescriptor().getIdentifiers().toString());
                ++scopeLevel;
            } else {
                sb.append(current.getClass().getSimpleName());
            }
            current = current.getParent();
            if (current == null) continue;
            sb.append('\n');
        } while (current != null);
        return sb.toString();
    }

    private static final class FrameSlotFlags {
        private static final Map<Integer, Integer> cachedFlags = new ConcurrentHashMap<Integer, Integer>();

        private FrameSlotFlags() {
        }

        static Integer of(int flags) {
            Integer boxed = flags;
            if (flags >= 128) {
                Integer cached = cachedFlags.get(boxed);
                if (cached != null) {
                    return cached;
                }
                cached = cachedFlags.putIfAbsent(boxed, boxed);
                if (cached != null) {
                    return cached;
                }
            }
            return boxed;
        }
    }

    class DebugVarRef
    extends VarRef {
        private final int frameLevel;

        DebugVarRef(String name, int frameLevel) {
            super(name);
            this.frameLevel = frameLevel;
            Environment.this.ensureFrameLevelAvailable(frameLevel);
        }

        @Override
        public JavaScriptNode createReadNode() {
            JavaScriptNode debugScope = Environment.this.factory.createDebugScope(Environment.this.context, Environment.this.factory.createAccessCallee(this.frameLevel - 1));
            return Environment.this.factory.createDebugVarWrapper(this.getName(), Environment.this.factory.createConstantUndefined(), debugScope, Environment.this.factory.createReadProperty(Environment.this.context, null, this.getName()));
        }

        @Override
        public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
            return Environment.this.factory.createWriteConstantVariable(rhs, Environment.this.isStrictMode());
        }

        @Override
        public JavaScriptNode createDeleteNode() {
            return Environment.this.factory.createConstantBoolean(false);
        }

        @Override
        public boolean isFunctionLocal() {
            return false;
        }

        @Override
        public boolean isGlobal() {
            return false;
        }
    }

    public class WrappedVarRef
    extends VarRef {
        private final VarRef wrappee;
        private final WrapClosure wrapClosure;

        public WrappedVarRef(Object name, VarRef wrappee, WrapClosure wrapClosure) {
            super(name);
            this.wrappee = wrappee;
            this.wrapClosure = wrapClosure;
            assert (!(wrappee instanceof WrappedVarRef));
        }

        @Override
        public JavaScriptNode createReadNode() {
            return this.wrapClosure.apply(this.wrappee.createReadNode(), WrapAccess.Read);
        }

        @Override
        public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
            JavaScriptNode writeNode = this.wrappee.isConst() ? Environment.this.factory.createWriteConstantVariable(rhs, true) : this.wrappee.createWriteNode(rhs);
            return this.wrapClosure.apply(writeNode, WrapAccess.Write);
        }

        @Override
        public JavaScriptNode createDeleteNode() {
            return this.wrapClosure.apply(this.wrappee.createDeleteNode(), WrapAccess.Delete);
        }

        @Override
        public Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> createCompoundAssignNode() {
            return this.wrapClosure.applyCompound(this.wrappee.createCompoundAssignNode());
        }

        @Override
        public boolean isFunctionLocal() {
            return this.wrappee.isFunctionLocal();
        }

        @Override
        public FrameSlot getFrameSlot() {
            return null;
        }

        @Override
        public boolean isGlobal() {
            return this.wrappee.isGlobal();
        }

        public VarRef getWrappee() {
            return this.wrappee;
        }

        @Override
        public VarRef withTDZCheck() {
            return new WrappedVarRef(this.name, this.wrappee.withTDZCheck(), this.wrapClosure);
        }

        @Override
        public VarRef withRequired(boolean required) {
            return new WrappedVarRef(this.name, this.wrappee.withRequired(required), this.wrapClosure);
        }

        @Override
        public boolean hasTDZCheck() {
            return this.wrappee.hasTDZCheck();
        }
    }

    public class GlobalLexVarRef
    extends VarRef {
        private final boolean isConst;
        private final boolean required;
        private final boolean checkTDZ;

        public GlobalLexVarRef(String name, boolean isConst) {
            this(name, isConst, true, false);
        }

        private GlobalLexVarRef(Object name, boolean isConst, boolean required, boolean checkTDZ) {
            super(name);
            assert (!name.equals("null") && !name.equals("undefined"));
            this.isConst = isConst;
            this.required = required;
            this.checkTDZ = checkTDZ;
        }

        @Override
        public JavaScriptNode createReadNode() {
            if (!this.required) {
                JavaScriptNode globalScope = Environment.this.factory.createGlobalScopeTDZCheck(Environment.this.context, this.getName(), this.checkTDZ);
                return Environment.this.factory.createReadProperty(Environment.this.context, globalScope, this.getName());
            }
            return Environment.this.factory.createReadLexicalGlobal(this.getName(), this.checkTDZ, Environment.this.context);
        }

        @Override
        public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
            JavaScriptNode globalScope = Environment.this.factory.createGlobalScopeTDZCheck(Environment.this.context, this.getName(), this.checkTDZ);
            return Environment.this.factory.createWriteProperty(globalScope, this.getName(), rhs, Environment.this.context, true, this.required, false);
        }

        @Override
        public boolean isFunctionLocal() {
            return Environment.this.function().isGlobal();
        }

        @Override
        public FrameSlot getFrameSlot() {
            return null;
        }

        @Override
        public boolean isGlobal() {
            return true;
        }

        @Override
        public boolean isConst() {
            return this.isConst;
        }

        @Override
        public JavaScriptNode createDeleteNode() {
            JavaScriptNode element = Environment.this.factory.createConstantString(this.getName());
            JavaScriptNode object = Environment.this.factory.createGlobalScope(Environment.this.context);
            return Environment.this.factory.createDeleteProperty(object, element, Environment.this.isStrictMode(), Environment.this.context);
        }

        @Override
        public VarRef withRequired(boolean required) {
            if (this.required != required) {
                return new GlobalLexVarRef(this.name, this.isConst, required, this.checkTDZ);
            }
            return this;
        }

        @Override
        public VarRef withTDZCheck() {
            if (!this.checkTDZ) {
                return new GlobalLexVarRef(this.name, this.isConst, this.required, true);
            }
            return this;
        }

        @Override
        public boolean hasTDZCheck() {
            return this.checkTDZ;
        }
    }

    public class GlobalVarRef
    extends VarRef {
        private final boolean required;

        public GlobalVarRef(String name) {
            this(name, true);
        }

        private GlobalVarRef(String name, boolean required) {
            super(name);
            assert (!name.equals("null"));
            this.required = required;
        }

        @Override
        public JavaScriptNode createReadNode() {
            if (this.name.equals("undefined")) {
                return Environment.this.factory.createConstantUndefined();
            }
            if (!this.required) {
                return Environment.this.factory.createReadProperty(Environment.this.context, Environment.this.factory.createGlobalObject(), this.getName());
            }
            return Environment.this.factory.createReadGlobalProperty(Environment.this.context, this.getName());
        }

        @Override
        public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
            return Environment.this.factory.createWriteProperty(Environment.this.factory.createGlobalObject(), this.getName(), rhs, Environment.this.context, Environment.this.isStrictMode(), this.isGlobal(), this.required);
        }

        @Override
        public boolean isFunctionLocal() {
            return false;
        }

        @Override
        public FrameSlot getFrameSlot() {
            return null;
        }

        @Override
        public boolean isGlobal() {
            return true;
        }

        @Override
        public JavaScriptNode createDeleteNode() {
            JavaScriptNode element = Environment.this.factory.createConstantString(this.getName());
            JavaScriptNode object = Environment.this.factory.createGlobalObject();
            return Environment.this.factory.createDeleteProperty(object, element, Environment.this.isStrictMode(), Environment.this.context);
        }

        @Override
        public VarRef withRequired(boolean required) {
            if (this.required != required) {
                return new GlobalVarRef(this.getName(), required);
            }
            return this;
        }
    }

    public class MappedArgumentVarRef
    extends AbstractArgumentsVarRef {
        private final FrameSlot frameSlot;
        private final int parameterIndex;
        private final FrameSlot argumentsSlot;

        public MappedArgumentVarRef(FrameSlot frameSlot, int scopeLevel, int frameLevel, String name, Environment current) {
            super(scopeLevel, frameLevel, name, current);
            assert (!JSFrameUtil.hasTemporalDeadZone(frameSlot));
            assert (current.function().hasSimpleParameterList());
            assert (!current.function().isDirectArgumentsAccess());
            this.argumentsSlot = Objects.requireNonNull(current.getBlockFrameDescriptor().findFrameSlot((Object)"<arguments>"));
            this.frameSlot = frameSlot;
            this.parameterIndex = current.function().getMappedParameterIndex(frameSlot);
        }

        private JavaScriptNode createReadArgumentsObject() {
            return Environment.this.factory.createReadFrameSlot(this.argumentsSlot, this.createScopeFrameNode());
        }

        @Override
        public JavaScriptNode createReadNode() {
            JavaScriptNode readArgumentsObject = this.createReadArgumentsObject();
            ReadElementNode readArgumentsObjectElement = Environment.this.factory.createReadElementNode(Environment.this.context, Environment.this.factory.copy(readArgumentsObject), Environment.this.factory.createConstantInteger(this.parameterIndex));
            return Environment.this.factory.createGuardDisconnectedArgumentRead(this.parameterIndex, readArgumentsObjectElement, readArgumentsObject, this.frameSlot);
        }

        @Override
        public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
            JavaScriptNode readArgumentsObject = this.createReadArgumentsObject();
            WriteElementNode writeArgumentsObjectElement = Environment.this.factory.createWriteElementNode(Environment.this.factory.copy(readArgumentsObject), Environment.this.factory.createConstantInteger(this.parameterIndex), null, Environment.this.context, false);
            return Environment.this.factory.createGuardDisconnectedArgumentWrite(this.parameterIndex, writeArgumentsObjectElement, readArgumentsObject, rhs, this.frameSlot);
        }
    }

    private final class ArgumentsVarRef
    extends AbstractArgumentsVarRef {
        private final FrameSlot frameSlot;

        ArgumentsVarRef(FrameSlot frameSlot, int scopeLevel, int frameLevel, String name, Environment current) {
            super(scopeLevel, frameLevel, name, current);
            this.frameSlot = frameSlot;
        }

        @Override
        public JavaScriptNode createReadNode() {
            JavaScriptNode argumentsVarNode = Environment.this.factory.createReadFrameSlot(this.frameSlot, this.createScopeFrameNode());
            if (Environment.this.function().isDirectArgumentsAccess()) {
                FunctionEnvironment currentFunction = this.current.function();
                JavaScriptNode createArgumentsObjectNode = Environment.this.factory.createArgumentsObjectNode(Environment.this.context, Environment.this.isStrictMode(), currentFunction.getLeadingArgumentCount());
                JSWriteFrameSlotNode writeNode = Environment.this.factory.createWriteFrameSlot(this.frameSlot, this.createScopeFrameNode(), this.current.getBlockFrameDescriptor(), createArgumentsObjectNode);
                return Environment.this.factory.createAccessArgumentsArrayDirectly(writeNode, argumentsVarNode, currentFunction.getLeadingArgumentCount());
            }
            return argumentsVarNode;
        }

        @Override
        public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
            assert (!this.current.function().isDirectArgumentsAccess());
            return Environment.this.factory.createWriteFrameSlot(this.frameSlot, this.createScopeFrameNode(), this.current.getBlockFrameDescriptor(), rhs);
        }

        @Override
        public FrameSlot getFrameSlot() {
            return this.frameSlot;
        }
    }

    private final class FunctionCalleeVarRef
    extends AbstractArgumentsVarRef {
        FunctionCalleeVarRef(int scopeLevel, int frameLevel, String name, Environment current) {
            super(scopeLevel, frameLevel, name, current);
        }

        @Override
        public JavaScriptNode createReadNode() {
            return Environment.this.factory.createAccessCallee(this.frameLevel);
        }

        @Override
        public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
            return Environment.this.factory.createWriteConstantVariable(rhs, Environment.this.isStrictMode());
        }
    }

    private abstract class AbstractArgumentsVarRef
    extends AbstractFrameVarRef {
        AbstractArgumentsVarRef(int scopeLevel, int frameLevel, String name, Environment current) {
            super(scopeLevel, frameLevel, name, current);
        }

        @Override
        public FrameSlot getFrameSlot() {
            return null;
        }
    }

    public class FrameSlotVarRef
    extends AbstractFrameVarRef {
        protected final FrameSlot frameSlot;
        private final boolean checkTDZ;

        public FrameSlotVarRef(FrameSlot frameSlot, int scopeLevel, int frameLevel, Object name, Environment current) {
            this(frameSlot, scopeLevel, frameLevel, name, current, JSFrameUtil.needsTemporalDeadZoneCheck(frameSlot, frameLevel));
        }

        public FrameSlotVarRef(FrameSlot frameSlot, int scopeLevel, int frameLevel, Object name, Environment current, boolean checkTDZ) {
            super(scopeLevel, frameLevel, name, current);
            this.frameSlot = frameSlot;
            this.checkTDZ = checkTDZ;
        }

        @Override
        public FrameSlot getFrameSlot() {
            return this.frameSlot;
        }

        @Override
        public boolean isConst() {
            return JSFrameUtil.isConst(this.frameSlot);
        }

        @Override
        public JavaScriptNode createReadNode() {
            JavaScriptNode readNode = Environment.this.factory.createReadFrameSlot(this.frameSlot, this.createScopeFrameNode(), this.checkTDZ);
            if (JSFrameUtil.isImportBinding(this.frameSlot)) {
                return Environment.this.factory.createReadImportBinding(readNode);
            }
            return readNode;
        }

        @Override
        public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
            return Environment.this.factory.createWriteFrameSlot(this.frameSlot, this.createScopeFrameNode(), this.current.getBlockFrameDescriptor(), rhs, this.checkTDZ);
        }

        @Override
        public VarRef withTDZCheck() {
            if (this.checkTDZ || !JSFrameUtil.hasTemporalDeadZone(this.frameSlot)) {
                return this;
            }
            return new FrameSlotVarRef(this.frameSlot, this.scopeLevel, this.frameLevel, this.name, this.current, true);
        }

        @Override
        public boolean hasTDZCheck() {
            return this.checkTDZ;
        }
    }

    public abstract class AbstractFrameVarRef
    extends VarRef {
        protected final int scopeLevel;
        protected final int frameLevel;
        protected final Environment current;

        public AbstractFrameVarRef(int scopeLevel, int frameLevel, Object name, Environment current) {
            super(name);
            this.scopeLevel = scopeLevel;
            this.frameLevel = frameLevel;
            this.current = current;
            Environment.this.ensureFrameLevelAvailable(frameLevel);
        }

        public int getScopeLevel() {
            return this.scopeLevel;
        }

        public int getFrameLevel() {
            return this.frameLevel;
        }

        @Override
        public boolean isFunctionLocal() {
            return this.frameLevel == 0;
        }

        @Override
        public boolean isGlobal() {
            return false;
        }

        @Override
        public JavaScriptNode createDeleteNode() {
            return Environment.this.factory.createConstantBoolean(false);
        }

        public ScopeFrameNode createScopeFrameNode() {
            int effectiveScopeLevel = this.getEffectiveScopeLevel();
            return Environment.this.factory.createScopeFrame(this.frameLevel, effectiveScopeLevel, Environment.this.getParentSlots(this.frameLevel, effectiveScopeLevel), this.getBlockScopeSlot());
        }

        public FrameDescriptor getFrameDescriptor() {
            return this.current.getBlockFrameDescriptor();
        }

        public FrameSlot getBlockScopeSlot() {
            return this.current.getCurrentBlockScopeSlot();
        }

        public int getEffectiveScopeLevel() {
            return this.current instanceof FunctionEnvironment && this.frameLevel == 0 ? 0 : this.scopeLevel;
        }
    }

    public static abstract class VarRef {
        protected final Object name;

        protected VarRef(Object name) {
            assert (name instanceof String || name instanceof InternalSlotId) : name;
            this.name = name;
        }

        public abstract JavaScriptNode createReadNode();

        public abstract JavaScriptNode createWriteNode(JavaScriptNode var1);

        public abstract boolean isFunctionLocal();

        public boolean isFrameVar() {
            return this.getFrameSlot() != null;
        }

        public abstract boolean isGlobal();

        public boolean isConst() {
            return false;
        }

        public FrameSlot getFrameSlot() {
            return null;
        }

        public String getName() {
            assert (this.name instanceof String) : this.name;
            return (String)this.name;
        }

        public abstract JavaScriptNode createDeleteNode();

        public Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> createCompoundAssignNode() {
            return new Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>>(this::createReadNode, this::createWriteNode);
        }

        public VarRef withTDZCheck() {
            return this;
        }

        public VarRef withRequired(boolean required) {
            return this;
        }

        public boolean hasTDZCheck() {
            return false;
        }
    }

    @FunctionalInterface
    static interface WrapClosure {
        public JavaScriptNode apply(JavaScriptNode var1, WrapAccess var2);

        default public Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> applyCompound(Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> suppliers) {
            Supplier<JavaScriptNode> readSupplier = suppliers.getFirst();
            UnaryOperator<JavaScriptNode> writeSupplier = suppliers.getSecond();
            return new Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>>(() -> this.apply((JavaScriptNode)((Object)((Object)readSupplier.get())), WrapAccess.Read), rhs -> this.apply((JavaScriptNode)((Object)((Object)writeSupplier.apply((JavaScriptNode)((Object)rhs)))), WrapAccess.Write));
        }

        public static WrapClosure compose(final WrapClosure inner, final WrapClosure before) {
            Objects.requireNonNull(before);
            if (inner == null) {
                return before;
            }
            return new WrapClosure(){

                @Override
                public JavaScriptNode apply(JavaScriptNode v, WrapAccess w) {
                    return inner.apply(before.apply(v, w), w);
                }

                @Override
                public Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> applyCompound(Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> suppliers) {
                    return inner.applyCompound(before.applyCompound(suppliers));
                }
            };
        }
    }

    static enum WrapAccess {
        Read,
        Write,
        Delete;

    }
}

