/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSRealm;
import java.util.List;

public abstract class JavaScriptRootNode
extends RootNode {
    private static final FrameDescriptor SHARED_EMPTY_FRAMEDESCRIPTOR = new FrameDescriptor();
    private final SourceSection sourceSection;

    protected JavaScriptRootNode() {
        this(null, null, null);
    }

    protected JavaScriptRootNode(JavaScriptLanguage lang, SourceSection sourceSection, FrameDescriptor frameDescriptor) {
        super((TruffleLanguage)lang, JavaScriptRootNode.substituteNullWithSharedEmptyFrameDescriptor(frameDescriptor));
        this.sourceSection = sourceSection;
    }

    private static FrameDescriptor substituteNullWithSharedEmptyFrameDescriptor(FrameDescriptor frameDescriptor) {
        return frameDescriptor == null ? SHARED_EMPTY_FRAMEDESCRIPTOR : frameDescriptor;
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public boolean isInternal() {
        SourceSection sc = this.getSourceSection();
        if (sc != null) {
            return sc.getSource().isInternal();
        }
        return false;
    }

    public boolean isFunction() {
        return false;
    }

    public boolean isResumption() {
        return false;
    }

    public boolean isCaptureFramesForTrace() {
        return this.isFunction() || this.isResumption();
    }

    protected boolean countsTowardsStackTraceLimit() {
        return false;
    }

    public static List<TruffleStackTraceElement> findAsynchronousFrames(JavaScriptRootNode rootNode, Frame frame) {
        return rootNode.findAsynchronousFrames(frame);
    }

    protected final JSRealm getRealm() {
        return JSRealm.get((Node)this);
    }

    protected final JavaScriptLanguage getLanguage() {
        return JavaScriptLanguage.get((Node)this);
    }
}

