/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector;

import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.chromeinspector.DebuggerSuspendedInfo;
import com.oracle.truffle.tools.chromeinspector.InspectorDebugger;
import com.oracle.truffle.tools.chromeinspector.InspectorExecutionContext;
import com.oracle.truffle.tools.chromeinspector.LanguageChecks;
import com.oracle.truffle.tools.chromeinspector.OutputHandler;
import com.oracle.truffle.tools.chromeinspector.ScriptsHandler;
import com.oracle.truffle.tools.chromeinspector.SuspendThreadExecutable;
import com.oracle.truffle.tools.chromeinspector.commands.Params;
import com.oracle.truffle.tools.chromeinspector.domains.RuntimeDomain;
import com.oracle.truffle.tools.chromeinspector.events.Event;
import com.oracle.truffle.tools.chromeinspector.instrument.Enabler;
import com.oracle.truffle.tools.chromeinspector.server.CommandProcessException;
import com.oracle.truffle.tools.chromeinspector.server.InspectServerSession;
import com.oracle.truffle.tools.chromeinspector.types.CallArgument;
import com.oracle.truffle.tools.chromeinspector.types.CustomPreview;
import com.oracle.truffle.tools.chromeinspector.types.ExceptionDetails;
import com.oracle.truffle.tools.chromeinspector.types.InternalPropertyDescriptor;
import com.oracle.truffle.tools.chromeinspector.types.Location;
import com.oracle.truffle.tools.chromeinspector.types.PropertyDescriptor;
import com.oracle.truffle.tools.chromeinspector.types.RemoteObject;
import com.oracle.truffle.tools.chromeinspector.types.TypeInfo;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.graalvm.collections.Pair;

public final class InspectorRuntime
extends RuntimeDomain {
    private static final Pattern WHITESPACES_PATTERN = Pattern.compile("\\s+");
    private static final String FUNCTION_COMPLETION = InspectorRuntime.eliminateWhiteSpaces("function getCompletions(");
    private static final String FUNCTION_SET_PROPERTY = InspectorRuntime.eliminateWhiteSpaces("function(a, b) { this[a] = b; }");
    private static final String FUNCTION_GET_ARRAY_NUM_PROPS = InspectorRuntime.eliminateWhiteSpaces("function() { return [this.length, Object.keys(this).length - this.length + 2]; }");
    private static final String FUNCTION_GET_BUFFER_NUM_PROPS = InspectorRuntime.eliminateWhiteSpaces("function() { return [this.length, 0]; }");
    private static final String FUNCTION_GET_COLLECTION_NUM_PROPS = InspectorRuntime.eliminateWhiteSpaces("function() { return [0, Object.keys(this).length + 1]; }");
    private static final Pattern FUNCTION_GETTER_PATTERN1 = Pattern.compile("function\\s+(?<invokeGetter>\\w+)\\((?<arrayStr>\\w+)\\)\\s*\\{\\s*\\w+\\s+(?<result>\\w+)\\s*=\\s*this;\\s*\\w*\\s*(?<properties>\\w+)\\s*=\\s*JSON.parse\\(\\k<arrayStr>\\);\\s*for\\s*\\(\\w+\\s+(?<i>\\w+)\\s*=.*(\\+\\+\\k<i>|\\k<i>\\+\\+|\\-\\-\\k<i>|\\k<i>\\-\\-)\\)\\s*\\{?\\s*\\k<result>\\s*=\\s*\\k<result>\\[\\k<properties>\\[\\k<i>\\]\\];\\s*\\}?\\s*return\\s+\\k<result>;\\s*\\}");
    private static final Pattern FUNCTION_GETTER_PATTERN2 = Pattern.compile("function\\s+(?<invokeGetter>\\w+)\\((?<propName>\\w+)\\)\\s*\\{\\s*return\\s+this\\[\\k<propName>\\];\\s*\\}");
    private static final Pattern FUNCTION_GET_INDEXED_VARS_PATTERN = Pattern.compile("function\\s+(?<getIndexedVariables>\\w+)\\((?<start>\\w+),\\s*(?<count>\\w+)\\)\\s*\\{\\s*\\w+\\s+(?<result>\\w+)\\s*=\\s*\\[\\];\\s*for\\s*\\(\\w+\\s+(?<i>\\w+)\\s*=\\s*\\k<start>;\\s*\\k<i>\\s*\\<\\s*\\(\\k<start>\\s*\\+\\s*\\k<count>\\);\\s*(\\+\\+\\k<i>|\\k<i>\\+\\+)\\)\\s*\\{?\\s*\\k<result>\\[\\k<i>\\]\\s*=\\s*this\\[\\k<i>\\];\\s*\\}?\\s*return\\s+\\k<result>;\\s*\\}");
    private static final Pattern FUNCTION_GET_NAMED_VARS_PATTERN = Pattern.compile("function\\s+(?<getNamedVariables>\\w+)\\((?<start>\\w+),\\s*(?<count>\\w+)\\)\\s*\\{\\s*\\w+\\s+(?<result>\\w+)\\s*=\\s*\\[\\];\\s*\\w+\\s+(?<ownProps>\\w+)\\s*=\\s*Object.getOwnPropertyNames\\s*\\(this\\);\\s*for\\s*\\(\\w+\\s+(?<i>\\w+)\\s*=\\s*\\k<start>;\\s*\\k<i>\\s*\\<\\s*\\(\\k<start>\\s*\\+\\s*\\k<count>\\);\\s*(\\+\\+\\k<i>|\\k<i>\\+\\+)\\)\\s*\\{?\\s*\\k<result>\\[\\k<i>\\]\\s*=\\s*\\k<ownProps>\\[\\k<i>\\];\\s*\\}?\\s*return\\s+\\k<result>;\\s*\\}");
    private final InspectorExecutionContext context;
    private InspectorExecutionContext.Listener contextListener;
    private ScriptsHandler slh;
    private Enabler enabler;
    private List<ConsoleOutputListener> outputListeners;

    public InspectorRuntime(InspectorExecutionContext context) {
        this.context = context;
    }

    @Override
    public void doEnable() {
        assert (this.contextListener == null);
        this.slh = this.context.acquireScriptsHandler();
        this.contextListener = new ContextListener();
        this.context.addListener(this.contextListener);
        InstrumentInfo instrumentInfo = (InstrumentInfo)this.context.getEnv().getInstruments().get("OutputProviderInstrument");
        this.enabler = (Enabler)this.context.getEnv().lookup(instrumentInfo, Enabler.class);
        this.enabler.enable();
        OutputHandler oh = ((OutputHandler.Provider)this.context.getEnv().lookup(instrumentInfo, OutputHandler.Provider.class)).getOutputHandler();
        ConsoleOutputListener outL = new ConsoleOutputListener("log");
        ConsoleOutputListener errL = new ConsoleOutputListener("error");
        oh.setOutListener(outL);
        oh.setErrListener(errL);
        this.outputListeners = Arrays.asList(outL, errL);
    }

    @Override
    public void notifyClosing() {
        if (this.outputListeners != null) {
            for (ConsoleOutputListener listener : this.outputListeners) {
                listener.flush();
            }
        }
    }

    @Override
    public void doDisable() {
        assert (this.contextListener != null);
        this.context.removeListener(this.contextListener);
        this.contextListener = null;
        this.enabler.disable();
        this.enabler = null;
        this.slh = null;
        this.context.releaseScriptsHandler();
    }

    private Source createSource(String expression, String sourceURL) {
        String name;
        String language = this.context.getLastLanguage();
        String mimeType = this.context.getLastMimeType();
        String string = name = sourceURL != null ? sourceURL : "eval";
        if (language == null) {
            language = Source.findLanguage((String)mimeType);
        }
        Source.LiteralBuilder builder = Source.newBuilder((String)language, (CharSequence)expression, (String)name).name(name).mimeType(mimeType);
        if (sourceURL != null && !sourceURL.isEmpty()) {
            URI ownUri = null;
            try {
                ownUri = new URI(sourceURL);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (ownUri != null) {
                builder.uri(ownUri);
            }
        }
        return builder.build();
    }

    @Override
    public Params compileScript(String expression, String sourceURL, boolean persistScript, long executionContextId) throws CommandProcessException {
        if (expression == null) {
            throw new CommandProcessException("An expression required.");
        }
        final JSONObject ret = new JSONObject();
        final Source source = this.createSource(expression, sourceURL);
        boolean parsed = false;
        final String[] exceptionText = new String[1];
        if (this.context.getSuspendedInfo() != null) {
            try {
                parsed = this.context.executeInSuspendThread(new SuspendThreadExecutable<Boolean>(){

                    @Override
                    public Boolean executeCommand() throws CommandProcessException {
                        LanguageInfo languageInfo = InspectorRuntime.this.context.getSuspendedInfo().getSuspendedEvent().getTopStackFrame().getLanguage();
                        if (languageInfo == null || !languageInfo.isInteractive()) {
                            exceptionText[0] = InspectorDebugger.getEvalNonInteractiveMessage();
                            return false;
                        }
                        try {
                            InspectorRuntime.this.context.getEnv().parse(source, new String[0]);
                            return true;
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable ex) {
                            exceptionText[0] = ex.getLocalizedMessage();
                            return false;
                        }
                    }

                    @Override
                    public Boolean processException(DebugException ex) {
                        InspectorRuntime.this.fillExceptionDetails(ret, ex);
                        return false;
                    }
                });
            }
            catch (InspectorExecutionContext.NoSuspendedThreadException ex) {
                exceptionText[0] = ex.getLocalizedMessage();
            }
        } else {
            parsed = false;
            exceptionText[0] = "<Not suspended>";
        }
        if (parsed && persistScript) {
            int id = this.slh.assureLoaded(source).getId();
            ret.put("scriptId", (Object)Integer.toString(id));
        }
        if (exceptionText[0] != null) {
            this.fillExceptionDetails(ret, exceptionText[0]);
        }
        return new Params(ret);
    }

    @Override
    public Params evaluate(final String expression, final String objectGroup, boolean includeCommandLineAPI, boolean silent, int contextId, final boolean returnByValue, final boolean generatePreview, boolean awaitPromise) throws CommandProcessException {
        if (expression == null) {
            throw new CommandProcessException("An expression required.");
        }
        final JSONObject json = new JSONObject();
        final DebuggerSuspendedInfo suspendedInfo = this.context.getSuspendedInfo();
        if (suspendedInfo != null) {
            try {
                this.context.executeInSuspendThread(new SuspendThreadExecutable<Void>(){

                    @Override
                    public Void executeCommand() throws CommandProcessException {
                        JSONObject result;
                        suspendedInfo.lastEvaluatedValue.set(null);
                        LanguageInfo languageInfo = InspectorRuntime.this.context.getSuspendedInfo().getSuspendedEvent().getTopStackFrame().getLanguage();
                        if (languageInfo == null || !languageInfo.isInteractive()) {
                            InspectorRuntime.this.fillExceptionDetails(json, InspectorDebugger.getEvalNonInteractiveMessage());
                            return null;
                        }
                        DebugValue value = null;
                        if (suspendedInfo.getCallFrames().length > 0) {
                            value = InspectorDebugger.getVarValue(expression, suspendedInfo.getCallFrames()[0]);
                        }
                        if (value == null) {
                            value = suspendedInfo.getSuspendedEvent().getTopStackFrame().eval(expression);
                            suspendedInfo.refreshFrames();
                        }
                        if (returnByValue) {
                            result = RemoteObject.createJSONResultValue(value, InspectorRuntime.this.context.areToStringSideEffectsAllowed(), InspectorRuntime.this.context.getErr());
                        } else {
                            RemoteObject ro = new RemoteObject(value, generatePreview, InspectorRuntime.this.context);
                            InspectorRuntime.this.context.getRemoteObjectsHandler().register(ro, objectGroup);
                            result = ro.toJSON();
                            if (!ro.isReplicable()) {
                                suspendedInfo.lastEvaluatedValue.set((Pair<DebugValue, Object>)Pair.create((Object)value, (Object)ro.getRawValue()));
                            }
                        }
                        json.put("result", (Object)result);
                        return null;
                    }

                    @Override
                    public Void processException(DebugException ex) {
                        InspectorRuntime.this.fillExceptionDetails(json, ex);
                        return null;
                    }
                });
            }
            catch (InspectorExecutionContext.NoSuspendedThreadException ex) {
                this.fillExceptionDetails(json, ex.getLocalizedMessage());
            }
        } else {
            this.fillExceptionDetails(json, "<Not suspended>");
        }
        return new Params(json);
    }

    @Override
    public Params getProperties(String objectId, boolean ownProperties, boolean accessorPropertiesOnly, final boolean generatePreview) throws CommandProcessException {
        if (objectId == null) {
            throw new CommandProcessException("An objectId required.");
        }
        final RemoteObject object = this.context.getRemoteObjectsHandler().getRemote(objectId);
        final String objectGroup = this.context.getRemoteObjectsHandler().getObjectGroupOf(objectId);
        final JSONObject json = new JSONObject();
        if (object != null) {
            final DebugValue value = object.getDebugValue();
            final RemoteObject.IndexRange indexRange = object.getIndexRange();
            try {
                if (value != null) {
                    this.context.executeInSuspendThread(new SuspendThreadExecutable<Void>(){

                        @Override
                        public Void executeCommand() throws CommandProcessException {
                            List array;
                            RemoteObject.TypeMark typeMark = object.getTypeMark();
                            if (typeMark != null) {
                                switch (typeMark) {
                                    case MAP_ENTRIES: {
                                        InspectorRuntime.this.putMapEntries(json, value, indexRange, generatePreview, objectGroup);
                                        break;
                                    }
                                    case MAP_ENTRY: {
                                        InspectorRuntime.this.putMapEntry(json, value, generatePreview, objectGroup);
                                        break;
                                    }
                                    default: {
                                        throw new CommandProcessException("Unknown type mark " + (Object)((Object)typeMark));
                                    }
                                }
                                return null;
                            }
                            List<Object> properties = null;
                            if (!value.hasHashEntries()) {
                                properties = value.getProperties();
                            }
                            if (properties == null) {
                                properties = Collections.emptyList();
                            } else if (indexRange != null && indexRange.isNamed()) {
                                ArrayList list = new ArrayList(properties);
                                properties = list.subList(indexRange.start(), indexRange.end());
                            }
                            if (!value.isArray()) {
                                array = Collections.emptyList();
                            } else if (indexRange != null && !indexRange.isNamed()) {
                                List arr = value.getArray();
                                array = arr.subList(indexRange.start(), indexRange.end());
                            } else {
                                array = value.getArray();
                            }
                            InspectorRuntime.this.putResultProperties(json, value, properties, array, generatePreview, objectGroup);
                            return null;
                        }

                        @Override
                        public Void processException(DebugException ex) {
                            InspectorRuntime.this.fillExceptionDetails(json, ex);
                            return null;
                        }
                    });
                } else {
                    final DebugScope scope = object.getScope();
                    this.context.executeInSuspendThread(new SuspendThreadExecutable<Void>(){

                        @Override
                        public Void executeCommand() throws CommandProcessException {
                            ArrayList<DebugValue> properties = new ArrayList<DebugValue>();
                            DebugValue scopeReceiver = object.getScopeReceiver();
                            if (scopeReceiver != null) {
                                properties.add(scopeReceiver);
                            }
                            for (DebugValue p : scope.getDeclaredValues()) {
                                properties.add(p);
                            }
                            InspectorRuntime.this.putResultProperties(json, null, properties, Collections.emptyList(), generatePreview, objectGroup);
                            return null;
                        }

                        @Override
                        public Void processException(DebugException ex) {
                            InspectorRuntime.this.fillExceptionDetails(json, ex);
                            return null;
                        }
                    });
                }
            }
            catch (InspectorExecutionContext.NoSuspendedThreadException ex) {
                json.put("result", (Object)new JSONArray());
            }
        }
        return new Params(json);
    }

    private void putMapEntries(JSONObject json, DebugValue value, RemoteObject.IndexRange indexRange, boolean generatePreview, String objectGroup) {
        int start = 0;
        int end = Integer.MAX_VALUE;
        if (indexRange != null && !indexRange.isNamed()) {
            start = indexRange.start();
            end = indexRange.end();
        }
        JSONArray result = new JSONArray();
        for (int index = 0; value.hasIteratorNextElement() && index < end; ++index) {
            DebugValue next = value.getIteratorNextElement();
            if (index < start) continue;
            String name = Integer.toString(index);
            JSONObject jsonEntry = this.createPropertyJSON(next, name, generatePreview, objectGroup, RemoteObject.TypeMark.MAP_ENTRY);
            result.put((Object)jsonEntry);
        }
        json.put("result", (Object)result);
    }

    private void putMapEntry(JSONObject json, DebugValue entry, boolean generatePreview, String objectGroup) {
        List entryArray = entry.getArray();
        DebugValue key = (DebugValue)entryArray.get(0);
        DebugValue value = (DebugValue)entryArray.get(1);
        JSONArray result = new JSONArray();
        result.put((Object)this.createMapEntryElement("key", key, generatePreview, objectGroup));
        result.put((Object)this.createMapEntryElement("value", value, generatePreview, objectGroup));
        json.put("result", (Object)result);
    }

    private JSONObject createMapEntryElement(String name, DebugValue v, boolean generatePreview, String objectGroup) {
        RemoteObject rv = new RemoteObject(v, false, generatePreview, this.context, (RemoteObject.TypeMark)null);
        this.context.getRemoteObjectsHandler().register(rv, objectGroup);
        JSONObject json = new JSONObject();
        json.put("name", (Object)name);
        json.put("value", (Object)rv.toJSON());
        json.put("writable", v.isWritable());
        return json;
    }

    private void putResultProperties(JSONObject json, DebugValue value, Collection<DebugValue> properties, Collection<DebugValue> arrayElements, boolean generatePreview, String objectGroup) {
        boolean hasFunctionLocation;
        String nameExc;
        DebugException exception;
        JSONArray internals;
        JSONArray result;
        block20: {
            String functionLocation = "[[FunctionLocation]]";
            result = new JSONArray();
            internals = new JSONArray();
            boolean hasArray = !arrayElements.isEmpty();
            HashSet<String> storedPropertyNames = hasArray && properties != null ? new HashSet<String>(properties.size()) : null;
            exception = null;
            nameExc = null;
            hasFunctionLocation = value == null || !value.canExecute();
            try {
                DebugValue prototype;
                boolean isJS = false;
                if (properties != null) {
                    LanguageInfo language = value != null ? value.getOriginalLanguage() : null;
                    isJS = LanguageChecks.isJS(language);
                    Iterator<DebugValue> propertiesIterator = properties.iterator();
                    while (propertiesIterator.hasNext()) {
                        DebugValue v = null;
                        try {
                            v = propertiesIterator.next();
                            if (!v.isReadable()) continue;
                            if (!v.isInternal()) {
                                result.put((Object)this.createPropertyJSON(v, generatePreview, objectGroup));
                                if (storedPropertyNames != null) {
                                    storedPropertyNames.add(v.getName());
                                }
                            } else {
                                internals.put((Object)this.createPropertyJSON(v, generatePreview, objectGroup));
                            }
                            if (hasFunctionLocation || !"[[FunctionLocation]]".equals(v.getName())) continue;
                            hasFunctionLocation = true;
                        }
                        catch (DebugException ex) {
                            if (exception != null) continue;
                            exception = ex;
                            nameExc = v != null ? v.getName() : "<unknown>";
                        }
                    }
                }
                int i = 0;
                for (DebugValue v : arrayElements) {
                    String name = Integer.toString(i++);
                    try {
                        if (!v.isReadable() || storedPropertyNames != null && storedPropertyNames.contains(name)) continue;
                        result.put((Object)this.createPropertyJSON(v, name, generatePreview, objectGroup));
                    }
                    catch (DebugException ex) {
                        if (exception != null) continue;
                        exception = ex;
                        nameExc = name;
                    }
                }
                if (isJS && (prototype = value.getProperty("__proto__")) != null && !prototype.isNull()) {
                    result.put((Object)this.createPropertyJSON(prototype, null, generatePreview, true, false, objectGroup, false, null));
                }
                if (value != null && value.hasHashEntries()) {
                    DebugValue entries = value.getHashEntriesIterator();
                    JSONObject map2 = this.createPropertyJSON(entries, "[[Entries]]", false, false, true, objectGroup, true, RemoteObject.TypeMark.MAP_ENTRIES);
                    internals.put((Object)map2);
                }
            }
            catch (DebugException ex) {
                if (exception != null) break block20;
                exception = ex;
            }
        }
        if (!hasFunctionLocation) {
            int scriptId;
            SourceSection sourceLocation;
            block21: {
                sourceLocation = null;
                try {
                    sourceLocation = value.getSourceLocation();
                }
                catch (DebugException ex) {
                    if (exception != null) break block21;
                    exception = ex;
                }
            }
            if (sourceLocation != null && (scriptId = this.slh.getScriptId(sourceLocation.getSource())) >= 0) {
                JSONObject location = new JSONObject();
                location.put("name", (Object)"[[FunctionLocation]]");
                JSONObject locationValue = new JSONObject();
                locationValue.put("type", (Object)"object");
                locationValue.put("subtype", (Object)"internal#location");
                locationValue.put("description", (Object)"Object");
                locationValue.put("value", (Object)new Location(scriptId, sourceLocation.getStartLine(), sourceLocation.getStartColumn()).toJSON());
                location.put("value", (Object)locationValue);
                internals.put((Object)location);
            }
        }
        json.put("result", (Object)result);
        json.put("internalProperties", (Object)internals);
        if (exception != null) {
            PrintWriter err;
            this.fillExceptionDetails(json, exception);
            if (exception.isInternalError() && (err = this.context.getErr()) != null) {
                err.println("Exception while retrieving variable " + nameExc);
                exception.printStackTrace(err);
            }
        }
    }

    @Override
    public Params callFunctionOn(final String objectId, String functionDeclaration, final JSONArray arguments, boolean silent, final boolean returnByValue, final boolean generatePreview, boolean awaitPromise, int executionContextId, final String objectGroup) throws CommandProcessException {
        if (objectId == null) {
            throw new CommandProcessException("An objectId required.");
        }
        final RemoteObject object = this.context.getRemoteObjectsHandler().getRemote(objectId);
        final JSONObject json = new JSONObject();
        if (object != null) {
            final DebugValue value = object.getDebugValue();
            final DebugScope scope = object.getScope();
            final RemoteObject.IndexRange indexRange = object.getIndexRange();
            final DebuggerSuspendedInfo suspendedInfo = this.context.getSuspendedInfo();
            if (suspendedInfo != null) {
                try {
                    final String functionTrimmed = functionDeclaration.trim();
                    final String functionNoWS = InspectorRuntime.eliminateWhiteSpaces(functionDeclaration);
                    this.context.executeInSuspendThread(new SuspendThreadExecutable<Void>(){

                        @Override
                        public Void executeCommand() throws CommandProcessException {
                            JSONObject result;
                            if (functionNoWS.startsWith(FUNCTION_COMPLETION)) {
                                result = InspectorRuntime.createCodecompletion(value, scope, InspectorRuntime.this.context, true);
                            } else if (functionNoWS.equals(FUNCTION_SET_PROPERTY)) {
                                if (arguments == null || arguments.length() < 2) {
                                    throw new CommandProcessException("Insufficient number of arguments: " + (arguments != null ? arguments.length() : 0) + ", expecting: 2");
                                }
                                Object property = ((JSONObject)arguments.get(0)).get("value");
                                CallArgument newValue = CallArgument.get((JSONObject)arguments.get(1));
                                InspectorRuntime.this.setPropertyValue(value, scope, property, object.getTypeMark(), newValue, (Pair<DebugValue, Object>)suspendedInfo.lastEvaluatedValue.getAndSet(null));
                                result = new JSONObject();
                            } else if (functionNoWS.equals(FUNCTION_GET_ARRAY_NUM_PROPS)) {
                                if (!value.isArray()) {
                                    throw new CommandProcessException("Expecting an Array the function is called on.");
                                }
                                JSONArray arr = new JSONArray();
                                if (indexRange != null && !indexRange.isNamed()) {
                                    List array = value.getArray();
                                    if (indexRange.start() < 0 || indexRange.end() > array.size()) {
                                        throw new CommandProcessException("Array range out of bounds.");
                                    }
                                    arr.put(indexRange.end() - indexRange.start());
                                } else {
                                    arr.put(value.getArray().size());
                                }
                                Collection props = value.getProperties();
                                if (props == null) {
                                    arr.put(0);
                                } else if (indexRange != null && indexRange.isNamed()) {
                                    ArrayList list = new ArrayList(props);
                                    if (indexRange.start() < 0 || indexRange.end() > list.size()) {
                                        throw new CommandProcessException("Named range out of bounds.");
                                    }
                                    arr.put(indexRange.end() - indexRange.start());
                                } else if (LanguageChecks.isJS(value.getOriginalLanguage())) {
                                    arr.put(props.size() + 1);
                                } else {
                                    arr.put(props.size());
                                }
                                result = new JSONObject();
                                result.put("value", (Object)arr);
                            } else if (functionNoWS.equals(FUNCTION_GET_BUFFER_NUM_PROPS)) {
                                if (!value.isArray()) {
                                    throw new CommandProcessException("Expecting a Buffer the function is called on.");
                                }
                                JSONArray arr = new JSONArray();
                                if (indexRange != null && !indexRange.isNamed()) {
                                    List array = value.getArray();
                                    if (indexRange.start() < 0 || indexRange.end() > array.size()) {
                                        throw new CommandProcessException("Array range out of bounds.");
                                    }
                                    arr.put(indexRange.end() - indexRange.start());
                                } else {
                                    arr.put(value.getArray().size());
                                }
                                if (LanguageChecks.isJS(value.getOriginalLanguage())) {
                                    arr.put(1);
                                } else {
                                    arr.put(0);
                                }
                                result = new JSONObject();
                                result.put("value", (Object)arr);
                            } else if (functionNoWS.equals(FUNCTION_GET_COLLECTION_NUM_PROPS)) {
                                Collection props = value.getProperties();
                                if (props == null) {
                                    throw new CommandProcessException("Expecting an Object the function is called on.");
                                }
                                JSONArray arr = new JSONArray();
                                arr.put(0);
                                if (indexRange != null && indexRange.isNamed()) {
                                    ArrayList list = new ArrayList(props);
                                    if (indexRange.start() < 0 || indexRange.end() > list.size()) {
                                        throw new CommandProcessException("Named range out of bounds.");
                                    }
                                    arr.put(indexRange.end() - indexRange.start());
                                } else if (LanguageChecks.isJS(value.getOriginalLanguage())) {
                                    arr.put(props.size() + 1);
                                } else {
                                    arr.put(props.size());
                                }
                                result = new JSONObject();
                                result.put("value", (Object)arr);
                            } else if (FUNCTION_GETTER_PATTERN1.matcher(functionTrimmed).matches()) {
                                if (arguments == null || arguments.length() < 1) {
                                    throw new CommandProcessException("Expecting an argument to invokeGetter function.");
                                }
                                String propertyNames = ((JSONObject)arguments.get(0)).getString("value");
                                JSONArray properties = new JSONArray(propertyNames);
                                DebugValue v = value;
                                for (int i = 0; i < properties.length() && (i == 0 || v != null); ++i) {
                                    String propertyName = properties.getString(i);
                                    v = v != null ? v.getProperty(propertyName) : scope.getDeclaredValue(propertyName);
                                }
                                result = this.asResult(v);
                            } else if (FUNCTION_GETTER_PATTERN2.matcher(functionTrimmed).matches()) {
                                if (arguments == null || arguments.length() < 1) {
                                    throw new CommandProcessException("Expecting an argument to invokeGetter function.");
                                }
                                String propertyName = ((JSONObject)arguments.get(0)).getString("value");
                                DebugValue p = value != null ? value.getProperty(propertyName) : scope.getDeclaredValue(propertyName);
                                result = this.asResult(p);
                            } else if (FUNCTION_GET_INDEXED_VARS_PATTERN.matcher(functionTrimmed).matches()) {
                                if (!value.isArray()) {
                                    throw new CommandProcessException("Expecting an Array the function is called on.");
                                }
                                if (arguments == null || arguments.length() < 2) {
                                    throw new CommandProcessException("Insufficient number of arguments: " + (arguments != null ? arguments.length() : 0) + ", expecting: 2");
                                }
                                int start = ((JSONObject)arguments.get(0)).getInt("value");
                                int count = ((JSONObject)arguments.get(1)).getInt("value");
                                RemoteObject ro = new RemoteObject(value, true, generatePreview, InspectorRuntime.this.context, new RemoteObject.IndexRange(start, start + count, false));
                                InspectorRuntime.this.context.getRemoteObjectsHandler().register(ro, objectGroup);
                                result = ro.toJSON();
                            } else if (FUNCTION_GET_NAMED_VARS_PATTERN.matcher(functionTrimmed).matches()) {
                                Collection props = value.getProperties();
                                if (props == null) {
                                    throw new CommandProcessException("Expecting an Object the function is called on.");
                                }
                                if (arguments == null || arguments.length() < 2) {
                                    throw new CommandProcessException("Insufficient number of arguments: " + (arguments != null ? arguments.length() : 0) + ", expecting: 2");
                                }
                                int start = ((JSONObject)arguments.get(0)).getInt("value");
                                int count = ((JSONObject)arguments.get(1)).getInt("value");
                                RemoteObject ro = new RemoteObject(value, true, generatePreview, InspectorRuntime.this.context, new RemoteObject.IndexRange(start, start + count, true));
                                InspectorRuntime.this.context.getRemoteObjectsHandler().register(ro, objectGroup);
                                result = ro.toJSON();
                            } else {
                                DebugValue body;
                                JSONObject argObj;
                                Object id;
                                Object arg0;
                                if (arguments != null && arguments.length() > 0 && (arg0 = arguments.get(0)) instanceof JSONObject && (id = (argObj = (JSONObject)arg0).opt("objectId")) instanceof String && (body = InspectorRuntime.this.context.getRemoteObjectsHandler().getCustomPreviewBody((String)id)) != null) {
                                    DebugValue config = InspectorRuntime.this.context.getRemoteObjectsHandler().getCustomPreviewConfig(objectId);
                                    DebugValue bodyML = config != null ? body.execute(new DebugValue[]{object.getDebugValue(), config}) : body.execute(new DebugValue[]{object.getDebugValue()});
                                    Object bodyjson = CustomPreview.value2JSON(bodyML, InspectorRuntime.this.context);
                                    JSONObject result2 = new JSONObject();
                                    result2.put("type", (Object)"object");
                                    result2.put("value", bodyjson);
                                    json.put("result", (Object)result2);
                                    return null;
                                }
                                StringBuilder code = new StringBuilder();
                                code.append("(").append(functionTrimmed).append(").apply(").append(value != null ? value.getName() : "null");
                                if (arguments != null) {
                                    code.append(",[");
                                    for (int i = 0; i < arguments.length(); ++i) {
                                        Object id2;
                                        JSONObject arg = arguments.getJSONObject(i);
                                        if (i > 0) {
                                            code.append(",");
                                        }
                                        if ((id2 = arg.opt("objectId")) instanceof String) {
                                            RemoteObject remoteArg = InspectorRuntime.this.context.getRemoteObjectsHandler().getRemote((String)id2);
                                            if (remoteArg == null) {
                                                throw new CommandProcessException("Cannot resolve argument by its objectId: " + id2);
                                            }
                                            code.append(remoteArg.getDebugValue().getName());
                                            continue;
                                        }
                                        code.append(JSONObject.valueToString((Object)arg.get("value")));
                                    }
                                    code.append("]");
                                }
                                code.append(")");
                                DebugValue eval = suspendedInfo.getSuspendedEvent().getTopStackFrame().eval(code.toString());
                                suspendedInfo.refreshFrames();
                                result = this.asResult(eval);
                            }
                            json.put("result", (Object)result);
                            return null;
                        }

                        @Override
                        public Void processException(DebugException ex) {
                            InspectorRuntime.this.fillExceptionDetails(json, ex);
                            return null;
                        }

                        private JSONObject asResult(DebugValue v) {
                            JSONObject result;
                            if (v == null) {
                                LanguageInfo language = suspendedInfo.getSuspendedEvent().getTopStackFrame().getLanguage();
                                result = RemoteObject.createNullObject(InspectorRuntime.this.context.getEnv(), language).toJSON();
                            } else if (!returnByValue) {
                                RemoteObject ro = new RemoteObject(v, true, generatePreview, InspectorRuntime.this.context);
                                InspectorRuntime.this.context.getRemoteObjectsHandler().register(ro, objectGroup);
                                result = ro.toJSON();
                            } else {
                                result = RemoteObject.createJSONResultValue(v, InspectorRuntime.this.context.areToStringSideEffectsAllowed(), InspectorRuntime.this.context.getErr());
                            }
                            return result;
                        }
                    });
                }
                catch (InspectorExecutionContext.NoSuspendedThreadException ex) {
                    json.put("result", (Object)new JSONObject());
                }
            }
        }
        return new Params(json);
    }

    @Override
    public void releaseObject(String objectId) {
        this.context.getRemoteObjectsHandler().releaseObject(objectId);
    }

    @Override
    public void releaseObjectGroup(String objectGroup) {
        this.context.getRemoteObjectsHandler().releaseObjectGroup(objectGroup);
    }

    private void setPropertyValue(DebugValue object, DebugScope scope, Object property, RemoteObject.TypeMark typeMark, CallArgument newValue, Pair<DebugValue, Object> evaluatedValue) throws CommandProcessException {
        DebugValue propValue;
        Number index = null;
        if (object != null && object.isArray()) {
            if (property instanceof Number) {
                index = (Number)property;
            } else {
                try {
                    index = Integer.parseUnsignedInt(property.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (index != null) {
            List array = object.getArray();
            int i = index.intValue();
            if (i < 0 || array.size() <= i) {
                throw new CommandProcessException("Bad array index: " + i + " array size = " + array.size());
            }
            propValue = (DebugValue)array.get(i);
        } else {
            if (object != null) {
                if (typeMark != null) {
                    int entryIndex;
                    switch (typeMark) {
                        case MAP_ENTRY: {
                            if ("key".equals(property)) {
                                entryIndex = 0;
                                break;
                            }
                            if ("value".equals(property)) {
                                entryIndex = 1;
                                break;
                            }
                            throw new CommandProcessException("Unknown entry: " + property);
                        }
                        default: {
                            throw new CommandProcessException("Unsupported type: " + (Object)((Object)typeMark));
                        }
                    }
                    propValue = (DebugValue)object.getArray().get(entryIndex);
                } else {
                    propValue = object.getProperty(property.toString());
                }
            } else {
                propValue = scope.getDeclaredValue(property.toString());
            }
            if (propValue == null) {
                throw new CommandProcessException("No property named " + property.toString() + " was found.");
            }
        }
        if (evaluatedValue != null && Objects.equals(evaluatedValue.getRight(), newValue.getPrimitiveValue())) {
            propValue.set((DebugValue)evaluatedValue.getLeft());
        } else {
            this.context.setValue(propValue, newValue);
        }
    }

    static JSONObject createCodecompletion(DebugValue value, DebugScope scope, InspectorExecutionContext context, boolean resultItems) {
        Iterable properties;
        JSONObject result;
        block6: {
            result = new JSONObject();
            properties = null;
            try {
                properties = value != null ? value.getProperties() : scope.getDeclaredValues();
            }
            catch (DebugException ex) {
                PrintWriter err;
                InspectorRuntime.fillExceptionDetails(result, ex, context);
                if (!ex.isInternalError() || (err = context.getErr()) == null) break block6;
                err.println("getProperties(" + (value != null ? value.getName() : scope.getName()) + ") has caused: " + (Object)((Object)ex));
                ex.printStackTrace(err);
            }
        }
        JSONArray valueArray = new JSONArray();
        JSONArray items = new JSONArray();
        if (properties != null) {
            for (DebugValue property : properties) {
                items.put((Object)property.getName());
            }
        }
        if (resultItems) {
            JSONObject itemsObj = new JSONObject();
            itemsObj.put("items", (Object)items);
            valueArray.put((Object)itemsObj);
        } else {
            valueArray.put((Object)items);
        }
        result.put("type", (Object)"object");
        result.put("value", (Object)valueArray);
        return result;
    }

    private void fillExceptionDetails(JSONObject obj, DebugException ex) {
        InspectorRuntime.fillExceptionDetails(obj, ex, this.context);
    }

    static void fillExceptionDetails(JSONObject obj, DebugException ex, InspectorExecutionContext context) {
        ExceptionDetails exceptionDetails = new ExceptionDetails(ex);
        obj.put("exceptionDetails", (Object)exceptionDetails.createJSON(context));
    }

    private void fillExceptionDetails(JSONObject obj, String errorMessage) {
        ExceptionDetails exceptionDetails = new ExceptionDetails(errorMessage);
        obj.put("exceptionDetails", (Object)exceptionDetails.createJSON(this.context));
    }

    @Override
    public void runIfWaitingForDebugger(InspectServerSession.CommandPostProcessor postProcessor) {
        postProcessor.setPostProcessJob(() -> this.context.doRunIfWaitingForDebugger());
    }

    @Override
    public void notifyConsoleAPICalled(String type, Object text) {
        this.eventHandler.event(new Event("Runtime.consoleAPICalled", Params.createConsoleAPICalled(type, text, this.context.getId())));
    }

    @Override
    public void setCustomObjectFormatterEnabled(boolean enabled) {
        this.context.setCustomObjectFormatterEnabled(enabled);
    }

    private JSONObject createPropertyJSON(DebugValue v, boolean generatePreview, String objectGroup) {
        return this.createPropertyJSON(v, null, generatePreview, objectGroup);
    }

    private JSONObject createPropertyJSON(DebugValue v, String defaultName, boolean generatePreview, String objectGroup) {
        return this.createPropertyJSON(v, defaultName, generatePreview, false, true, objectGroup, false, null);
    }

    private JSONObject createPropertyJSON(DebugValue v, String defaultName, boolean generatePreview, String objectGroup, RemoteObject.TypeMark typeMark) {
        return this.createPropertyJSON(v, defaultName, generatePreview, false, true, objectGroup, false, typeMark);
    }

    private JSONObject createPropertyJSON(DebugValue v, String defaultName, boolean generatePreview, boolean readEagerly, boolean enumerable, String objectGroup, boolean forceInternal, RemoteObject.TypeMark typeMark) {
        RemoteObject rv = new RemoteObject(v, readEagerly, generatePreview, this.context, typeMark);
        this.context.getRemoteObjectsHandler().register(rv, objectGroup);
        String name = v.getName();
        if (name == null && defaultName != null) {
            name = defaultName;
        }
        if (!forceInternal && !v.isInternal()) {
            RemoteObject getter;
            RemoteObject setter;
            if (readEagerly) {
                setter = null;
                getter = null;
            } else {
                getter = InspectorRuntime.findGetter(v);
                setter = InspectorRuntime.findSetter(v);
            }
            PropertyDescriptor pd = new PropertyDescriptor(name, rv, v.isWritable(), getter, setter, true, enumerable, null, true, null);
            return pd.toJSON();
        }
        InternalPropertyDescriptor ipd = new InternalPropertyDescriptor(name, rv);
        return ipd.toJSON();
    }

    private static RemoteObject findGetter(DebugValue v) {
        if (!v.hasReadSideEffects()) {
            return null;
        }
        return RemoteObject.createSimpleObject(TypeInfo.TYPE.FUNCTION, "Function", "");
    }

    private static RemoteObject findSetter(DebugValue v) {
        if (!v.hasWriteSideEffects()) {
            return null;
        }
        return RemoteObject.createSimpleObject(TypeInfo.TYPE.FUNCTION, "Function", "");
    }

    private static String eliminateWhiteSpaces(String str) {
        return WHITESPACES_PATTERN.matcher(str).replaceAll("");
    }

    private class ConsoleOutputListener
    implements OutputHandler.Listener {
        private final String type;
        private final StringBuilder output = new StringBuilder();

        ConsoleOutputListener(String type) {
            this.type = type;
        }

        @Override
        public void outputText(String str) {
            this.output.append(str);
            do {
                int end;
                int in = this.output.lastIndexOf("\n");
                int ir = this.output.lastIndexOf("\r");
                if (in < 0 && ir < 0) break;
                int endText = end = Math.max(in, ir);
                if (ir >= 0 && in == ir + 1) {
                    --endText;
                }
                String text = this.output.substring(0, endText);
                InspectorRuntime.this.notifyConsoleAPICalled(this.type, text);
                this.output.delete(0, end + 1);
            } while (this.output.length() > 0);
        }

        void flush() {
            String text = this.output.toString();
            if (!text.isEmpty()) {
                this.output.delete(0, text.length());
                InspectorRuntime.this.notifyConsoleAPICalled(this.type, text);
            }
        }
    }

    private class ContextListener
    implements InspectorExecutionContext.Listener {
        private ContextListener() {
        }

        @Override
        public void contextCreated(long id, String name) {
            InspectorRuntime.this.executionContextCreated(id, name);
        }

        @Override
        public void contextDestroyed(long id, String name) {
            InspectorRuntime.this.executionContextDestroyed(id);
        }
    }
}

