/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.tools.chromeinspector.objects.AbstractInspectorArray;

@GeneratedBy(value=AbstractInspectorArray.class)
final class AbstractInspectorArrayGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private AbstractInspectorArrayGen() {
    }

    static {
        LibraryExport.register(AbstractInspectorArray.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=AbstractInspectorArray.class)
    static class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, AbstractInspectorArray.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof AbstractInspectorArray);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof AbstractInspectorArray);
            return new Cached(receiver);
        }

        @GeneratedBy(value=AbstractInspectorArray.class)
        static class Uncached
        extends InteropLibrary {
            private final Class<? extends AbstractInspectorArray> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((AbstractInspectorArray)receiver).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            public final boolean isAdoptable() {
                return false;
            }

            public final NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractInspectorArray)receiver).getArraySize();
            }

            @CompilerDirectives.TruffleBoundary
            public Object readArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractInspectorArray)receiver).readArrayElement(index);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractInspectorArray)receiver).hasArrayElements();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isArrayElementReadable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractInspectorArray)receiver).isArrayElementReadable(index);
            }
        }

        @GeneratedBy(value=AbstractInspectorArray.class)
        static class Cached
        extends InteropLibrary {
            private final Class<? extends AbstractInspectorArray> receiverClass_;

            protected Cached(Object receiver) {
                AbstractInspectorArray castReceiver = (AbstractInspectorArray)receiver;
                this.receiverClass_ = castReceiver.getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            public long getArraySize(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractInspectorArray)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).getArraySize();
            }

            public Object readArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractInspectorArray)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).readArrayElement(index);
            }

            public boolean hasArrayElements(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractInspectorArray)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).hasArrayElements();
            }

            public boolean isArrayElementReadable(Object receiver, long index) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((AbstractInspectorArray)CompilerDirectives.castExact((Object)receiver, this.receiverClass_)).isArrayElementReadable(index);
            }
        }
    }
}

