/*
 * Decompiled with CFR 0.152.
 */
package http;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.BindException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import json.JSONArray;
import json.JSONObject;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import util.TimeCalcUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHelperAsync {
    private static Logger logger = LoggerFactory.getLogger(HttpHelperAsync.class);
    private static final int DEFAULT_ASYNC_TIME_OUT = 10000;
    private static final int MAX_TOTEL = Integer.parseInt(PropertiesUtils.HTTP_MAX_CONNECTION);
    private static final int MAX_CONNECTION_PER_ROUTE = Integer.parseInt(PropertiesUtils.HTTP_MAX_CONNECTION_PER_ROUTE);
    public static final String UTF8 = "UTF-8";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static Get get = new Get();
    private static Post post = new Post();
    private static PostJSON postJSON = new PostJSON();

    private static final void headerLog(HttpResponse response) {
        if (PropertiesUtils.debug) {
            Header[] headers = response.getAllHeaders();
            HttpHelperAsync.headerLog(headers);
        }
    }

    private static final void headerLog(Header[] headers) {
        for (Header header : headers) {
            String key = header.getName();
            String value = header.getValue();
            if (null != key) {
                logger.info(key + ": " + value);
                continue;
            }
            logger.info(value);
        }
    }

    public static Response get(String url, Headers headers, Map<String, Object> parameters, long timeoutMillis) throws Exception {
        TimeCalcUtil.setReqType("Get");
        return get.request(url, headers, parameters, timeoutMillis);
    }

    public static Response post(String url, Headers headers, Map<String, Object> parameters, long timeoutMillis) throws Exception {
        TimeCalcUtil.setReqType("Post");
        return post.request(url, headers, parameters, timeoutMillis);
    }

    public static Response postJSON(String url, Headers headers, JSONObject parameters, long timeoutMillis) throws Exception {
        TimeCalcUtil.setReqType("Post");
        return postJSON.request(url, headers, parameters, timeoutMillis);
    }

    public static void main(String[] args) throws Exception {
        JSONObject parameters = JSONObject.parseObject("{\"from\":{\"no\":\"10109\",\"nonce\":\"0.6917891008699647\",\"pub\":\"XT-102200\",\"pubtoken\":\"123c34f11ada8219f0eeeb913d679b362c3f0810\",\"time\":\"1430471411\"},\"msg\":{\"todo\":\"1\",\"appid\":\"10009103\",\"text\":\"\u5404\u4f4d\u91d1\u8776\u540c\u4e8b\uff0c\u4e3a\u4e86\u7ed9\u7528\u6237\u63d0\u4f9b\u66f4\u597d\u7684\u4e91\u4e4b\u5bb6\u670d\u52a1\uff0c\u8fd1\u4e00\u5468\u5185\uff0c\u6211\u4eec\u4f1a\u5728\u975e\u9ad8\u5cf0\u4f7f\u7528\u65f6\u6bb5\u5bf9\u4e91\u4e4b\u5bb6\u670d\u52a1\u505a\u5fc5\u8981\u7684\u6027\u80fd\u6d4b\u8bd5\u53ca\u4f18\u5316\uff0c\u6d4b\u8bd5\u548c\u4f18\u5316\u8303\u56f4\u4ec5\u9650\u91d1\u8776\u5185\u90e8\u7528\u6237\uff0c\u5916\u90e8\u5ba2\u6237\u4e0d\u53d7\u4efb\u4f55\u5f71\u54cd\u3002\n\u5728\u6b64\u671f\u95f4\uff0c\u5982\u9047\u4efb\u4f55\u5f02\u5e38\u4f7f\u7528\u95ee\u9898\uff0c\u8bf7\u53ca\u65f6\u4e0e\u6211\u4eec\u8054\u7cfb\uff1a\u6797\u6bd3\u94ee 0755-86072654\u3002\u8c22\u8c22\u5927\u5bb6\uff01\"},\"to\":[{\"no\":\"10109\",\"user\":[\"8b1096ec-90be-42a8-bde2-e1c6a7ed4371\"]}],\"type\":2}");
        HttpHelperAsync.postJSON("http://192.168.22.144/pubacc/api/pubsend", null, parameters, 0L);
    }

    private static class PostJSON
    extends HttpAsyncRequest {
        private PostJSON() {
        }

        public HttpEntity setHttpEntity(Object params) throws Exception {
            JSONObject jsonParams = JSONObject.parseObject(params.toString());
            StringEntity stringEntity = new StringEntity(jsonParams.toString(), HttpHelperAsync.UTF8);
            stringEntity.setContentType(HttpHelperAsync.APPLICATION_JSON);
            return stringEntity;
        }
    }

    private static class Post
    extends HttpAsyncRequest {
        private Post() {
        }
    }

    private static class Get
    extends HttpAsyncRequest {
        private Get() {
        }

        public HttpUriRequest setHttpUriRequest(String url, HttpEntity httpEntity) throws Exception {
            String param = EntityUtils.toString((HttpEntity)httpEntity);
            url = url + (url.indexOf(63) != -1 ? "&" : "?") + param;
            HttpGet get = new HttpGet(url);
            return get;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UrlParam
    implements Serializable {
        private static final long serialVersionUID = -5041417788475125724L;
        private String url;
        private Map<String, Object> parameters;

        public UrlParam(String url, Map<String, Object> parameters) {
            this.url = url;
            this.parameters = parameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class HttpAsyncRequest {
        private HttpAsyncRequest() {
        }

        public Object setParameter(JSONObject parameters) {
            logger.info("{} Params: {}", (Object)TimeCalcUtil.getReqType(), (Object)parameters);
            return parameters;
        }

        public Object setParameter(Map<String, Object> parameters) {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            if (null == parameters || parameters.isEmpty()) {
                return params;
            }
            Iterator<String> iterator = parameters.keySet().iterator();
            StringBuffer paramsBuffer = new StringBuffer();
            while (iterator.hasNext()) {
                String name = iterator.next();
                String value = parameters.get(name).toString();
                params.add(new BasicNameValuePair(name, value));
                if (iterator.hasNext()) {
                    paramsBuffer.append(name).append("=").append(value).append("&");
                    continue;
                }
                paramsBuffer.append(name).append("=").append(value);
            }
            logger.info("{} Params: {}", (Object)TimeCalcUtil.getReqType(), (Object)paramsBuffer);
            return params;
        }

        public HttpEntity setHttpEntity(Object params) throws Exception {
            List nameValuePairs = (List)params;
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(nameValuePairs, HttpHelperAsync.UTF8);
            return urlEncodedFormEntity;
        }

        public HttpUriRequest setHttpUriRequest(String url, HttpEntity httpEntity) throws Exception {
            HttpPost post = new HttpPost(url);
            post.setEntity(httpEntity);
            return post;
        }

        private void headers(HttpUriRequest request, Headers headers) {
            if (null != headers && !headers.isEmpty()) {
                Set set = headers.keySet();
                for (String name : set) {
                    String value = "" + headers.get(name);
                    logger.info("{}: {}", (Object)name, (Object)value);
                    request.addHeader(name, value);
                }
            }
        }

        public Response request(String url, Headers headers, Map<String, Object> parameters, long timeoutMillis) throws Exception {
            try {
                this.preOpera(url, timeoutMillis);
                UrlParam urlParam = this.parseUrlParam(url, parameters);
                Object contentTypeObject = null == headers ? null : (Object)headers.get("Content-Type");
                String contentType = null == contentTypeObject ? HttpHelperAsync.APPLICATION_X_WWW_FORM_URLENCODED : contentTypeObject.toString();
                Response response = null;
                if (contentType.contains(HttpHelperAsync.APPLICATION_JSON)) {
                    response = this.applicationJSON(url, headers, JSONObject.parseObject(JSONObject.toJSON(parameters).toString()), timeoutMillis);
                } else {
                    Object params = this.setParameter(urlParam.parameters);
                    params = params == null ? new Object() : params;
                    HttpEntity httpEntity = this.setHttpEntity(params);
                    HttpUriRequest request = this.setHttpUriRequest(urlParam.url, httpEntity);
                    this.headers(request, headers);
                    response = HttpHelperAsyncClient.getInstance().execute(request, timeoutMillis);
                }
                return response;
            }
            catch (AssertionError e) {
                throw new Exception((Throwable)((Object)e));
            }
        }

        public Response request(String url, Headers headers, JSONObject parameters, long timeoutMillis) throws Exception {
            try {
                this.preOpera(url, timeoutMillis);
                return this.applicationJSON(url, headers, parameters, timeoutMillis);
            }
            catch (AssertionError e) {
                throw new Exception((Throwable)((Object)e));
            }
        }

        private void preOpera(String url, long timeoutMillis) {
            Assert.assertFalse((String)"url is null or empty!", (boolean)StringUtils.isEmpty((String)url));
            TimeCalcUtil.setStartTimeUrl(System.currentTimeMillis(), url);
            if (0L == timeoutMillis) {
                timeoutMillis = 10000L;
            }
        }

        private UrlParam parseUrlParam(String url, Map<String, Object> params) {
            boolean hasUrlParam;
            Assert.assertFalse((String)"url is null or empty!", (boolean)StringUtils.isEmpty((String)url));
            int wenhao = url.indexOf("?");
            boolean bl = hasUrlParam = -1 != wenhao && -1 != url.indexOf("=");
            if (null == params && hasUrlParam) {
                params = new HashMap<String, Object>();
            }
            if (hasUrlParam) {
                String srcUrl = url;
                url = url.substring(0, wenhao);
                String keyValues = srcUrl.substring(wenhao + 1);
                if (StringUtils.isNotEmpty((String)keyValues)) {
                    String[] keyValueArray;
                    for (String keyValue : keyValueArray = keyValues.split("&")) {
                        String[] valuePair;
                        if (!StringUtils.isNotEmpty((String)keyValue) || 2 != (valuePair = keyValue.split("=")).length) continue;
                        String name = valuePair[0];
                        String value = valuePair[1];
                        if (!StringUtils.isNotEmpty((String)name) || !StringUtils.isNotEmpty((String)value)) continue;
                        params.put(name, value);
                    }
                }
            }
            return new UrlParam(url, params);
        }

        private Response applicationJSON(String url, Headers headers, JSONObject parameters, long timeoutMillis) throws Exception {
            Object params = this.setParameter(parameters);
            params = params == null ? new Object() : params;
            HttpEntity httpEntity = this.setHttpEntity(params);
            HttpUriRequest request = this.setHttpUriRequest(url, httpEntity);
            this.headers(request, headers);
            Response response = HttpHelperAsyncClient.getInstance().execute(request, timeoutMillis);
            return response;
        }
    }

    public static class Response {
        private int code = 400;
        private String content;
        private String error;

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public int getCode() {
            return this.code;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public JSONObject getJsonContent() {
            return JSONObject.parseObject(this.content);
        }

        public JSONArray getJsonArrayContent() {
            return JSONArray.parseArray(this.content);
        }

        public JSONObject getJsonError() {
            return JSONObject.parseObject(this.error);
        }

        public String toString() {
            return JSONObject.toJSON(this).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Headers
    extends HashMap<String, Object> {
        private static final long serialVersionUID = -6699349634305847872L;

        public Headers() {
            this.put("Content-Type", HttpHelperAsync.APPLICATION_X_WWW_FORM_URLENCODED);
        }
    }

    private static class HttpHelperAsyncClient {
        private CloseableHttpAsyncClient httpClient;
        private PoolingNHttpClientConnectionManager cm;
        private DefaultConnectingIOReactor ioReactor;
        private static HttpHelperAsyncClient instance;
        private Logger logger = LoggerFactory.getLogger(HttpHelperAsyncClient.class);

        private HttpHelperAsyncClient() {
        }

        public static HttpHelperAsyncClient getInstance() {
            instance = HttpHelperAsyncClientHolder.instance;
            try {
                instance.init();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return instance;
        }

        private void init() throws Exception {
            this.ioReactor = new DefaultConnectingIOReactor();
            this.ioReactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ex) {
                    return ex instanceof BindException;
                }

                public boolean handle(RuntimeException ex) {
                    return ex instanceof UnsupportedOperationException;
                }
            });
            this.cm = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)this.ioReactor);
            this.cm.setMaxTotal(MAX_TOTEL);
            this.cm.setDefaultMaxPerRoute(MAX_CONNECTION_PER_ROUTE);
            this.httpClient = HttpAsyncClients.custom().addInterceptorFirst(new HttpRequestInterceptor(){

                public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                    if (!request.containsHeader("Accept-Encoding")) {
                        request.addHeader("Accept-Encoding", "gzip");
                    }
                }
            }).addInterceptorFirst(new HttpResponseInterceptor(){

                public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                    Header ceheader;
                    HttpEntity entity = response.getEntity();
                    if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                        HeaderElement[] codecs = ceheader.getElements();
                        for (int i = 0; i < codecs.length; ++i) {
                            if (!codecs[i].getName().equalsIgnoreCase("gzip")) continue;
                            response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                            return;
                        }
                    }
                }
            }).setConnectionManager((NHttpClientConnectionManager)this.cm).build();
            this.httpClient.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Response execute(HttpUriRequest request, long timeoutmillis) throws Exception {
            Response respObject;
            Future rsp;
            HttpEntity entity;
            block9: {
                Response response;
                entity = null;
                rsp = null;
                respObject = new Response();
                respObject.setCode(400);
                if (request == null) {
                    return respObject;
                }
                try {
                    if (this.httpClient != null) break block9;
                    StringBuilder sbuilder = new StringBuilder();
                    sbuilder.append("\n{").append(request.getURI().toString()).append("}\nreturn error {HttpHelperAsync.httpClient \u83b7\u53d6\u5f02\u5e38\uff01}");
                    this.logger.info(sbuilder.toString());
                    respObject.setError(sbuilder.toString());
                    response = respObject;
                }
                catch (Throwable throwable) {
                    EntityUtils.consumeQuietly(entity);
                    throw throwable;
                }
                EntityUtils.consumeQuietly((HttpEntity)entity);
                return response;
            }
            rsp = this.httpClient.execute(request, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    HttpHelperAsyncClient.this.logger.info("completed successful!");
                }

                public void failed(Exception ex) {
                    HttpHelperAsyncClient.this.logger.info("excute failed:", (Throwable)ex);
                }

                public void cancelled() {
                    HttpHelperAsyncClient.this.logger.info("excute canclled!");
                }
            });
            HttpResponse resp = null;
            resp = timeoutmillis > 0L ? (HttpResponse)rsp.get(timeoutmillis, TimeUnit.MILLISECONDS) : (HttpResponse)rsp.get(10000L, TimeUnit.MILLISECONDS);
            entity = resp.getEntity();
            StatusLine statusLine = resp.getStatusLine();
            respObject.setCode(statusLine.getStatusCode());
            this.logger.info("Response:");
            this.logger.info(statusLine.toString());
            HttpHelperAsync.headerLog(resp);
            String result = new String();
            if (respObject.getCode() == 200) {
                String encoding = ("" + resp.getFirstHeader("Content-Encoding")).toLowerCase();
                if (encoding.indexOf("gzip") > 0) {
                    entity = new GzipDecompressingEntity(entity);
                }
                result = new String(EntityUtils.toByteArray((HttpEntity)entity), HttpHelperAsync.UTF8);
                respObject.setContent(result);
            } else {
                StringBuilder sbuilder = new StringBuilder();
                sbuilder.append("\n{").append(request.getURI().toString()).append("}\nreturn error {").append(resp.getStatusLine().getStatusCode()).append("}");
                this.logger.info(sbuilder.toString());
                try {
                    result = new String(EntityUtils.toByteArray((HttpEntity)entity), HttpHelperAsync.UTF8);
                    respObject.setError(result);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    result = e.getMessage();
                }
            }
            TimeCalcUtil.logRunTime();
            this.logger.info(result);
            EntityUtils.consumeQuietly((HttpEntity)entity);
            return respObject;
        }
    }

    private static class HttpHelperAsyncClientHolder {
        private static HttpHelperAsyncClient instance = new HttpHelperAsyncClient();

        private HttpHelperAsyncClientHolder() {
        }
    }

    private static class PropertiesUtils {
        static Properties defaultProperty;
        public static String HTTP_MAX_CONNECTION;
        public static String HTTP_MAX_CONNECTION_PER_ROUTE;
        public static boolean debug;

        private PropertiesUtils() {
        }

        public static void init(String config) throws Exception {
            if (defaultProperty != null) {
                defaultProperty.clear();
            }
            defaultProperty = new Properties();
            InputStream in = PropertiesUtils.class.getClassLoader().getResourceAsStream(config);
            defaultProperty.load(in);
        }

        public static String getProperty(String property, String defaultValue) {
            if (StringUtils.isEmpty((String)property)) {
                logger.error("property name is null or empty!");
                return null;
            }
            return defaultProperty.getProperty(property, defaultValue);
        }

        static {
            try {
                PropertiesUtils.init("log4j.properties");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            HTTP_MAX_CONNECTION = PropertiesUtils.getProperty("HTTP_MAX_CONNECTION", "1000");
            HTTP_MAX_CONNECTION_PER_ROUTE = PropertiesUtils.getProperty("HTTP_MAX_CONNECTION_PER_ROUTE", "1000");
            debug = Boolean.valueOf(PropertiesUtils.getProperty("http.debug", "true"));
        }
    }
}

