/*
 * Decompiled with CFR 0.152.
 */
package json.parser.deserializer;

import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;
import json.parser.DefaultJSONParser;
import json.parser.JSONLexer;
import json.parser.deserializer.ObjectDeserializer;
import json.util.TypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanDeserializer
implements ObjectDeserializer {
    public static final BooleanDeserializer instance = new BooleanDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Boolean boolObj;
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 6) {
            lexer.nextToken(16);
            boolObj = Boolean.TRUE;
        } else if (lexer.token() == 7) {
            lexer.nextToken(16);
            boolObj = Boolean.FALSE;
        } else if (lexer.token() == 2) {
            int intValue = lexer.intValue();
            lexer.nextToken(16);
            boolObj = intValue == 1 ? Boolean.TRUE : Boolean.FALSE;
        } else {
            Object value = parser.parse();
            if (value == null) {
                return null;
            }
            boolObj = TypeUtils.castToBoolean(value);
        }
        if (null == boolObj) {
            return null;
        }
        if (clazz == AtomicBoolean.class) {
            return (T)new AtomicBoolean(boolObj);
        }
        return (T)boolObj;
    }

    @Override
    public int getFastMatchToken() {
        return 6;
    }
}

