/*
 * Decompiled with CFR 0.152.
 */
package json.parser.deserializer;

import java.lang.reflect.Type;
import json.JSON;
import json.parser.DefaultJSONParser;
import json.parser.JSONLexer;
import json.parser.deserializer.ObjectDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharArrayDeserializer
implements ObjectDeserializer {
    public static final CharArrayDeserializer instance = new CharArrayDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        return CharArrayDeserializer.deserialze(parser);
    }

    public static <T> T deserialze(DefaultJSONParser parser) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 4) {
            String val = lexer.stringVal();
            lexer.nextToken(16);
            return (T)val.toCharArray();
        }
        if (lexer.token() == 2) {
            Number val = lexer.integerValue();
            lexer.nextToken(16);
            return (T)val.toString().toCharArray();
        }
        Object value = parser.parse();
        if (value == null) {
            return null;
        }
        return (T)JSON.toJSONString(value).toCharArray();
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

