/*
 * Decompiled with CFR 0.152.
 */
package json.parser.deserializer;

import java.awt.Font;
import java.lang.reflect.Type;
import json.JSONException;
import json.parser.DefaultJSONParser;
import json.parser.JSONLexer;
import json.parser.deserializer.ObjectDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontDeserializer
implements ObjectDeserializer {
    public static final FontDeserializer instance = new FontDeserializer();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 8) {
            lexer.nextToken(16);
            return null;
        }
        if (lexer.token() != 12 && lexer.token() != 16) {
            throw new JSONException("syntax error");
        }
        lexer.nextToken();
        int size = 0;
        int style = 0;
        String name = null;
        while (true) {
            if (lexer.token() == 13) break;
            if (lexer.token() != 4) {
                throw new JSONException("syntax error");
            }
            String key = lexer.stringVal();
            lexer.nextTokenWithColon(2);
            if (key.equalsIgnoreCase("name")) {
                if (lexer.token() != 4) throw new JSONException("syntax error");
                name = lexer.stringVal();
                lexer.nextToken();
            } else if (key.equalsIgnoreCase("style")) {
                if (lexer.token() != 2) throw new JSONException("syntax error");
                style = lexer.intValue();
                lexer.nextToken();
            } else {
                if (!key.equalsIgnoreCase("size")) throw new JSONException("syntax error, " + key);
                if (lexer.token() != 2) throw new JSONException("syntax error");
                size = lexer.intValue();
                lexer.nextToken();
            }
            if (lexer.token() != 16) continue;
            lexer.nextToken(4);
        }
        lexer.nextToken();
        return (T)new Font(name, style, size);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

