/*
 * Decompiled with CFR 0.152.
 */
package json.parser.deserializer;

import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;
import json.JSONException;
import json.parser.DefaultJSONParser;
import json.parser.deserializer.ObjectDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetAddressDeserializer
implements ObjectDeserializer {
    public static final InetAddressDeserializer instance = new InetAddressDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        String host = (String)parser.parse();
        if (host == null) {
            return null;
        }
        if (host.length() == 0) {
            return null;
        }
        try {
            return (T)InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new JSONException("deserialize error", e);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

