/*
 * Decompiled with CFR 0.152.
 */
package json.parser.deserializer;

import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import json.JSONException;
import json.parser.DefaultJSONParser;
import json.parser.JSONLexer;
import json.parser.deserializer.ObjectDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetSocketAddressDeserializer
implements ObjectDeserializer {
    public static final InetSocketAddressDeserializer instance = new InetSocketAddressDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 8) {
            lexer.nextToken();
            return null;
        }
        parser.accept(12);
        InetAddress address = null;
        int port = 0;
        while (true) {
            String key = lexer.stringVal();
            lexer.nextToken(17);
            if (key.equals("address")) {
                parser.accept(17);
                address = parser.parseObject(InetAddress.class);
            } else if (key.equals("port")) {
                parser.accept(17);
                if (lexer.token() != 2) {
                    throw new JSONException("port is not int");
                }
                port = lexer.intValue();
                lexer.nextToken();
            } else {
                parser.accept(17);
                parser.parse();
            }
            if (lexer.token() != 16) break;
            lexer.nextToken();
        }
        parser.accept(13);
        return (T)new InetSocketAddress(address, port);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

