/*
 * Decompiled with CFR 0.152.
 */
package json.parser.deserializer;

import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicLong;
import json.parser.DefaultJSONParser;
import json.parser.JSONLexer;
import json.parser.deserializer.ObjectDeserializer;
import json.util.TypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongDeserializer
implements ObjectDeserializer {
    public static final LongDeserializer instance = new LongDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Long longObject;
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 2) {
            long longValue = lexer.longValue();
            lexer.nextToken(16);
            longObject = longValue;
        } else {
            Object value = parser.parse();
            if (value == null) {
                return null;
            }
            longObject = TypeUtils.castToLong(value);
        }
        if (null == longObject) {
            return null;
        }
        if (clazz == AtomicLong.class) {
            return (T)new AtomicLong(longObject);
        }
        return (T)longObject;
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

