/*
 * Decompiled with CFR 0.152.
 */
package json.parser.deserializer;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import json.JSONException;
import json.parser.DefaultJSONParser;
import json.parser.JSONScanner;
import json.parser.deserializer.AbstractDateDeserializer;
import json.parser.deserializer.ObjectDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDateDeserializer
extends AbstractDateDeserializer
implements ObjectDeserializer {
    public static final SqlDateDeserializer instance = new SqlDateDeserializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T cast(DefaultJSONParser parser, Type clazz, Object fieldName, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            val = new java.sql.Date(((Date)val).getTime());
        } else if (val instanceof Number) {
            val = new java.sql.Date(((Number)val).longValue());
        } else {
            if (val instanceof String) {
                long longVal;
                block16: {
                    String strVal = (String)val;
                    if (strVal.length() == 0) {
                        return null;
                    }
                    JSONScanner dateLexer = new JSONScanner(strVal);
                    try {
                        java.sql.Date date;
                        if (dateLexer.scanISO8601DateIfMatch()) {
                            Calendar calendar = dateLexer.getCalendar();
                            if (null == calendar) {
                                T t = null;
                                return t;
                            }
                            longVal = calendar.getTimeInMillis();
                            break block16;
                        }
                        DateFormat dateFormat = parser.getDateFormat();
                        try {
                            java.sql.Date sqlDate;
                            Date date2 = dateFormat.parse(strVal);
                            date = sqlDate = new java.sql.Date(date2.getTime());
                        }
                        catch (ParseException parseException) {
                            longVal = Long.parseLong(strVal);
                            break block16;
                        }
                        return (T)date;
                    }
                    finally {
                        dateLexer.close();
                    }
                }
                return (T)new java.sql.Date(longVal);
            }
            throw new JSONException("parse error : " + val);
        }
        return (T)val;
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

