/*
 * Decompiled with CFR 0.152.
 */
package json.parser.deserializer;

import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import json.JSONException;
import json.parser.DefaultJSONParser;
import json.parser.deserializer.AbstractDateDeserializer;
import json.parser.deserializer.ObjectDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimestampDeserializer
extends AbstractDateDeserializer
implements ObjectDeserializer {
    public static final TimestampDeserializer instance = new TimestampDeserializer();

    @Override
    protected <T> T cast(DefaultJSONParser parser, Type clazz, Object fieldName, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            return (T)new Timestamp(((Date)val).getTime());
        }
        if (val instanceof Number) {
            return (T)new Timestamp(((Number)val).longValue());
        }
        if (val instanceof String) {
            String strVal = (String)val;
            if (strVal.length() == 0) {
                return null;
            }
            DateFormat dateFormat = parser.getDateFormat();
            try {
                Date date = dateFormat.parse(strVal);
                return (T)new Timestamp(date.getTime());
            }
            catch (ParseException date) {
                long longVal = Long.parseLong(strVal);
                return (T)new Timestamp(longVal);
            }
        }
        throw new JSONException("parse error");
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

