/*
 * Decompiled with CFR 0.152.
 */
package json.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import json.serializer.JSONSerializer;
import json.serializer.ObjectSerializer;
import json.serializer.SerializeWriter;
import json.serializer.SerializerFeature;

public class BigIntegerSerializer
implements ObjectSerializer {
    public static final BigIntegerSerializer instance = new BigIntegerSerializer();

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
                out.write('0');
            } else {
                out.writeNull();
            }
            return;
        }
        BigInteger val = (BigInteger)object;
        out.write(val.toString());
    }
}

