/*
 * Decompiled with CFR 0.152.
 */
package json.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import json.serializer.JSONSerializer;
import json.serializer.ObjectSerializer;
import json.serializer.SerializeWriter;
import json.serializer.SerializerFeature;

public class EnumSerializer
implements ObjectSerializer {
    public static final EnumSerializer instance = new EnumSerializer();

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            serializer.getWriter().writeNull();
            return;
        }
        if (serializer.isEnabled(SerializerFeature.WriteEnumUsingToString)) {
            Enum e = (Enum)object;
            serializer.write(e.name());
        } else {
            Enum e = (Enum)object;
            out.writeInt(e.ordinal());
        }
    }
}

