/*
 * Decompiled with CFR 0.152.
 */
package json.serializer;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import json.serializer.JSONSerializer;
import json.serializer.ObjectSerializer;
import json.serializer.SerialContext;
import json.serializer.SerializeWriter;
import json.serializer.SerializerFeature;

public final class ListSerializer
implements ObjectSerializer {
    public static final ListSerializer instance = new ListSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        boolean writeClassName = serializer.isEnabled(SerializerFeature.WriteClassName);
        SerializeWriter out = serializer.getWriter();
        Type elementType = null;
        if (writeClassName && fieldType instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)fieldType;
            elementType = param.getActualTypeArguments()[0];
        }
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        List list = (List)object;
        int size = list.size();
        int end = size - 1;
        if (end == -1) {
            out.append("[]");
            return;
        }
        SerialContext context = serializer.getContext();
        serializer.setContext(context, object, fieldName);
        ObjectSerializer itemSerializer = null;
        try {
            if (size > 1 && out.isEnabled(SerializerFeature.PrettyFormat)) {
                out.append('[');
                serializer.incrementIndent();
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        out.append(',');
                    }
                    serializer.println();
                    Object item = list.get(i);
                    if (item != null) {
                        if (serializer.containsReference(item)) {
                            serializer.writeReference(item);
                            continue;
                        }
                        itemSerializer = serializer.getObjectWriter(item.getClass());
                        SerialContext itemContext = new SerialContext(context, object, fieldName);
                        serializer.setContext(itemContext);
                        itemSerializer.write(serializer, item, i, elementType);
                        continue;
                    }
                    serializer.getWriter().writeNull();
                }
                serializer.decrementIdent();
                serializer.println();
                out.append(']');
                return;
            }
            out.append('[');
            for (int i = 0; i < end; ++i) {
                Object item = list.get(i);
                if (item == null) {
                    out.append("null,");
                    continue;
                }
                Class<?> clazz = item.getClass();
                if (clazz == Integer.class) {
                    out.writeIntAndChar((Integer)item, ',');
                    continue;
                }
                if (clazz == Long.class) {
                    long val = (Long)item;
                    if (writeClassName) {
                        out.writeLongAndChar(val, 'L');
                        out.write(',');
                        continue;
                    }
                    out.writeLongAndChar(val, ',');
                    continue;
                }
                SerialContext itemContext = new SerialContext(context, object, fieldName);
                serializer.setContext(itemContext);
                if (serializer.containsReference(item)) {
                    serializer.writeReference(item);
                } else {
                    itemSerializer = serializer.getObjectWriter(item.getClass());
                    itemSerializer.write(serializer, item, i, elementType);
                }
                out.append(',');
            }
            Object item = list.get(end);
            if (item == null) {
                out.append("null]");
            } else {
                Class<?> clazz = item.getClass();
                if (clazz == Integer.class) {
                    out.writeIntAndChar((Integer)item, ']');
                } else if (clazz == Long.class) {
                    if (writeClassName) {
                        out.writeLongAndChar((Long)item, 'L');
                        out.write(']');
                    } else {
                        out.writeLongAndChar((Long)item, ']');
                    }
                } else {
                    SerialContext itemContext = new SerialContext(context, object, fieldName);
                    serializer.setContext(itemContext);
                    if (serializer.containsReference(item)) {
                        serializer.writeReference(item);
                    } else {
                        itemSerializer = serializer.getObjectWriter(item.getClass());
                        itemSerializer.write(serializer, item, end, elementType);
                    }
                    out.append(']');
                }
            }
        }
        finally {
            serializer.setContext(context);
        }
    }
}

