/*
 * Decompiled with CFR 0.152.
 */
package json.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import json.serializer.JSONSerializer;
import json.serializer.ObjectSerializer;
import json.serializer.SerializeWriter;
import json.serializer.SerializerFeature;

public class LongArraySerializer
implements ObjectSerializer {
    public static LongArraySerializer instance = new LongArraySerializer();

    public final void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        long[] array = (long[])object;
        out.write('[');
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                out.write(',');
            }
            out.writeLong(array[i]);
        }
        out.write(']');
    }
}

