/*
 * Decompiled with CFR 0.152.
 */
package json.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import json.serializer.JSONSerializer;
import json.serializer.ObjectSerializer;
import json.serializer.SerializeWriter;
import json.serializer.SerializerFeature;

public class LongSerializer
implements ObjectSerializer {
    public static LongSerializer instance = new LongSerializer();

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
                out.write('0');
            } else {
                out.writeNull();
            }
            return;
        }
        long value = (Long)object;
        out.writeLong(value);
        if (serializer.isEnabled(SerializerFeature.WriteClassName) && value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE && fieldType != Long.class) {
            out.write('L');
        }
    }
}

