/*
 * Decompiled with CFR 0.152.
 */
package json.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import json.JSON;
import json.serializer.JSONSerializer;
import json.serializer.NameFilter;
import json.serializer.ObjectSerializer;
import json.serializer.PropertyFilter;
import json.serializer.PropertyPreFilter;
import json.serializer.SerialContext;
import json.serializer.SerializeWriter;
import json.serializer.SerializerFeature;
import json.serializer.ValueFilter;

public class MapSerializer
implements ObjectSerializer {
    public static MapSerializer instance = new MapSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            out.writeNull();
            return;
        }
        TreeMap map = (TreeMap)object;
        if (out.isEnabled(SerializerFeature.SortField) && !(map instanceof SortedMap) && !(map instanceof LinkedHashMap)) {
            try {
                map = new TreeMap(map);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (serializer.containsReference(object)) {
            serializer.writeReference(object);
            return;
        }
        SerialContext parent = serializer.getContext();
        serializer.setContext(parent, object, fieldName);
        try {
            out.write('{');
            serializer.incrementIndent();
            Class<?> preClazz = null;
            ObjectSerializer preWriter = null;
            boolean first = true;
            if (out.isEnabled(SerializerFeature.WriteClassName)) {
                out.writeFieldName(JSON.DEFAULT_TYPE_KEY);
                out.writeString(object.getClass().getName());
                first = false;
            }
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                Object entryKey = entry.getKey();
                if (entryKey == null || entryKey instanceof String) {
                    List<ValueFilter> list;
                    List<NameFilter> nameFilters;
                    List<PropertyFilter> propertyFilters;
                    String key = (String)entryKey;
                    List<PropertyPreFilter> namePreFilters = serializer.getPropertyPreFiltersDirect();
                    if (namePreFilters != null) {
                        boolean apply = true;
                        for (PropertyPreFilter propertyPreFilter : namePreFilters) {
                            if (propertyPreFilter.apply(serializer, object, key)) continue;
                            apply = false;
                            break;
                        }
                        if (!apply) continue;
                    }
                    if ((propertyFilters = serializer.getPropertyFiltersDirect()) != null) {
                        boolean apply = true;
                        for (PropertyFilter propertyFilter : propertyFilters) {
                            if (propertyFilter.apply(object, key, value)) continue;
                            apply = false;
                            break;
                        }
                        if (!apply) continue;
                    }
                    if ((nameFilters = serializer.getNameFiltersDirect()) != null) {
                        for (NameFilter nameFilter3 : nameFilters) {
                            key = nameFilter3.process(object, key, value);
                        }
                    }
                    if ((list = serializer.getValueFiltersDirect()) != null) {
                        for (ValueFilter valueFilter : list) {
                            value = valueFilter.process(object, key, value);
                        }
                    }
                    if (value == null && !serializer.isEnabled(SerializerFeature.WriteMapNullValue)) continue;
                    if (!first) {
                        out.write(',');
                    }
                    if (out.isEnabled(SerializerFeature.PrettyFormat)) {
                        serializer.println();
                    }
                    out.writeFieldName(key, true);
                } else {
                    if (!first) {
                        out.write(',');
                    }
                    serializer.write(entryKey);
                    out.write(':');
                }
                first = false;
                if (value == null) {
                    out.writeNull();
                    continue;
                }
                Class<?> clazz = value.getClass();
                if (clazz == preClazz) {
                    preWriter.write(serializer, value, entryKey, null);
                    continue;
                }
                preClazz = clazz;
                preWriter = serializer.getObjectWriter(clazz);
                preWriter.write(serializer, value, entryKey, null);
            }
        }
        finally {
            serializer.setContext(parent);
        }
        serializer.decrementIdent();
        if (out.isEnabled(SerializerFeature.PrettyFormat) && map.size() > 0) {
            serializer.println();
        }
        out.write('}');
    }
}

