/*
 * Decompiled with CFR 0.152.
 */
package json.serializer;

import java.awt.Rectangle;
import java.io.IOException;
import java.lang.reflect.Type;
import json.JSON;
import json.serializer.JSONSerializer;
import json.serializer.ObjectSerializer;
import json.serializer.SerializeWriter;
import json.serializer.SerializerFeature;

public class RectangleSerializer
implements ObjectSerializer {
    public static final RectangleSerializer instance = new RectangleSerializer();

    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        Rectangle rectangle = (Rectangle)object;
        if (rectangle == null) {
            out.writeNull();
            return;
        }
        int sep = 123;
        if (out.isEnabled(SerializerFeature.WriteClassName)) {
            out.write('{');
            out.writeFieldName(JSON.DEFAULT_TYPE_KEY);
            out.writeString(Rectangle.class.getName());
            sep = 44;
        }
        out.writeFieldValue((char)sep, "x", rectangle.getX());
        out.writeFieldValue(',', "y", rectangle.getY());
        out.writeFieldValue(',', "width", rectangle.getWidth());
        out.writeFieldValue(',', "height", rectangle.getHeight());
        out.write('}');
    }
}

