/*
 * Decompiled with CFR 0.152.
 */
package json.serializer;

import java.io.File;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import json.JSON;
import json.JSONException;
import json.annotation.JSONType;
import json.serializer.ASMSerializerFactory;
import json.serializer.AppendableSerializer;
import json.serializer.AtomicBooleanSerializer;
import json.serializer.AtomicIntegerArraySerializer;
import json.serializer.AtomicIntegerSerializer;
import json.serializer.AtomicLongArraySerializer;
import json.serializer.AtomicLongSerializer;
import json.serializer.BigDecimalSerializer;
import json.serializer.BigIntegerSerializer;
import json.serializer.BooleanArraySerializer;
import json.serializer.BooleanSerializer;
import json.serializer.ByteArraySerializer;
import json.serializer.ByteSerializer;
import json.serializer.CharArraySerializer;
import json.serializer.CharacterSerializer;
import json.serializer.CharsetSerializer;
import json.serializer.ClassSerializer;
import json.serializer.ColorSerializer;
import json.serializer.DateFormatSerializer;
import json.serializer.DoubleArraySerializer;
import json.serializer.DoubleSerializer;
import json.serializer.FileSerializer;
import json.serializer.FloatArraySerializer;
import json.serializer.FloatSerializer;
import json.serializer.FontSerializer;
import json.serializer.InetAddressSerializer;
import json.serializer.InetSocketAddressSerializer;
import json.serializer.IntArraySerializer;
import json.serializer.IntegerSerializer;
import json.serializer.JavaBeanSerializer;
import json.serializer.LocaleSerializer;
import json.serializer.LongArraySerializer;
import json.serializer.LongSerializer;
import json.serializer.ObjectArraySerializer;
import json.serializer.ObjectSerializer;
import json.serializer.PatternSerializer;
import json.serializer.PointSerializer;
import json.serializer.RectangleSerializer;
import json.serializer.ReferenceSerializer;
import json.serializer.ShortArraySerializer;
import json.serializer.ShortSerializer;
import json.serializer.StringSerializer;
import json.serializer.TimeZoneSerializer;
import json.serializer.URISerializer;
import json.serializer.URLSerializer;
import json.serializer.UUIDSerializer;
import json.util.ASMUtils;
import json.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializeConfig
extends IdentityHashMap<Type, ObjectSerializer> {
    private static final SerializeConfig globalInstance = new SerializeConfig();
    private boolean asm = !ASMUtils.isAndroid();
    private final ASMSerializerFactory asmFactory = new ASMSerializerFactory();
    private String typeKey = JSON.DEFAULT_TYPE_KEY;

    public String getTypeKey() {
        return this.typeKey;
    }

    public void setTypeKey(String typeKey) {
        this.typeKey = typeKey;
    }

    public final ObjectSerializer createASMSerializer(Class<?> clazz) throws Exception {
        return this.asmFactory.createJavaBeanSerializer(clazz);
    }

    public ObjectSerializer createJavaBeanSerializer(Class<?> clazz) {
        JSONType annotation;
        if (!Modifier.isPublic(clazz.getModifiers())) {
            return new JavaBeanSerializer(clazz);
        }
        boolean asm = this.asm;
        if (asm && this.asmFactory.isExternalClass(clazz) || clazz == Serializable.class || clazz == Object.class) {
            asm = false;
        }
        if ((annotation = clazz.getAnnotation(JSONType.class)) != null && !annotation.asm()) {
            asm = false;
        }
        if (asm) {
            try {
                return this.createASMSerializer(clazz);
            }
            catch (ClassCastException e) {
                return new JavaBeanSerializer(clazz);
            }
            catch (Throwable e) {
                throw new JSONException("create asm serializer error, class " + clazz, e);
            }
        }
        return new JavaBeanSerializer(clazz);
    }

    public boolean isAsmEnable() {
        return this.asm;
    }

    public void setAsmEnable(boolean asmEnable) {
        this.asm = asmEnable;
    }

    public static final SerializeConfig getGlobalInstance() {
        return globalInstance;
    }

    public SerializeConfig() {
        this(1024);
    }

    public SerializeConfig(int tableSize) {
        super(tableSize);
        this.put(Boolean.class, BooleanSerializer.instance);
        this.put(Character.class, CharacterSerializer.instance);
        this.put(Byte.class, ByteSerializer.instance);
        this.put(Short.class, ShortSerializer.instance);
        this.put(Integer.class, IntegerSerializer.instance);
        this.put(Long.class, LongSerializer.instance);
        this.put(Float.class, FloatSerializer.instance);
        this.put(Double.class, DoubleSerializer.instance);
        this.put(BigDecimal.class, BigDecimalSerializer.instance);
        this.put(BigInteger.class, BigIntegerSerializer.instance);
        this.put(String.class, StringSerializer.instance);
        this.put(byte[].class, ByteArraySerializer.instance);
        this.put(short[].class, ShortArraySerializer.instance);
        this.put(int[].class, IntArraySerializer.instance);
        this.put(long[].class, LongArraySerializer.instance);
        this.put(float[].class, FloatArraySerializer.instance);
        this.put(double[].class, DoubleArraySerializer.instance);
        this.put(boolean[].class, BooleanArraySerializer.instance);
        this.put(char[].class, CharArraySerializer.instance);
        this.put(Object[].class, ObjectArraySerializer.instance);
        this.put(Class.class, ClassSerializer.instance);
        this.put(SimpleDateFormat.class, DateFormatSerializer.instance);
        this.put(Locale.class, LocaleSerializer.instance);
        this.put(TimeZone.class, TimeZoneSerializer.instance);
        this.put(UUID.class, UUIDSerializer.instance);
        this.put(InetAddress.class, InetAddressSerializer.instance);
        this.put(Inet4Address.class, InetAddressSerializer.instance);
        this.put(Inet6Address.class, InetAddressSerializer.instance);
        this.put(InetSocketAddress.class, InetSocketAddressSerializer.instance);
        this.put(File.class, FileSerializer.instance);
        this.put(URI.class, URISerializer.instance);
        this.put(URL.class, URLSerializer.instance);
        this.put(Appendable.class, AppendableSerializer.instance);
        this.put(StringBuffer.class, AppendableSerializer.instance);
        this.put(StringBuilder.class, AppendableSerializer.instance);
        this.put(Pattern.class, PatternSerializer.instance);
        this.put(Charset.class, CharsetSerializer.instance);
        this.put(AtomicBoolean.class, AtomicBooleanSerializer.instance);
        this.put(AtomicInteger.class, AtomicIntegerSerializer.instance);
        this.put(AtomicLong.class, AtomicLongSerializer.instance);
        this.put(AtomicReference.class, ReferenceSerializer.instance);
        this.put(AtomicIntegerArray.class, AtomicIntegerArraySerializer.instance);
        this.put(AtomicLongArray.class, AtomicLongArraySerializer.instance);
        this.put(WeakReference.class, ReferenceSerializer.instance);
        this.put(SoftReference.class, ReferenceSerializer.instance);
        try {
            this.put(Class.forName("java.awt.Color"), ColorSerializer.instance);
            this.put(Class.forName("java.awt.Font"), FontSerializer.instance);
            this.put(Class.forName("java.awt.Point"), PointSerializer.instance);
            this.put(Class.forName("java.awt.Rectangle"), RectangleSerializer.instance);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

