/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.util;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Locale;

public final class LMBCSUtil {
    private static final String ULMBCS_GRP_L1 = "0x01";
    private static final String ULMBCS_GRP_GR = "0x02";
    private static final String ULMBCS_GRP_HE = "0x03";
    private static final String ULMBCS_GRP_AR = "0x04";
    private static final String ULMBCS_GRP_RU = "0x05";
    private static final String ULMBCS_GRP_L2 = "0x06";
    private static final String ULMBCS_GRP_TR = "0x08";
    private static final String ULMBCS_GRP_TH = "0x0B";
    private static final String ULMBCS_GRP_JA = "0x10";
    private static final String ULMBCS_GRP_KO = "0x11";
    private static final String ULMBCS_GRP_TW = "0x12";
    private static final String ULMBCS_GRP_CN = "0x13";
    private static final String ULMBCS_GRP_UNICODE = "0x14";
    private static Hashtable groupMap = new Hashtable();

    public static byte getLMBCGroupId(Locale locale) {
        byte groupId = Byte.decode(ULMBCS_GRP_L1);
        if (null == groupMap.get(locale)) {
            String language = locale.getLanguage();
            Locale l = new Locale(language, "");
            if (null != groupMap.get(l)) {
                groupId = Byte.decode(groupMap.get(l).toString());
            }
        } else {
            groupId = Byte.decode(groupMap.get(locale).toString());
        }
        return groupId;
    }

    public static byte getDefaultGroupId() {
        return LMBCSUtil.getLMBCGroupId(Locale.getDefault());
    }

    public static byte[] getLMBCSLocalGroupBytes(String input) {
        byte[] groupId = new byte[]{LMBCSUtil.getDefaultGroupId()};
        byte[] bytes = input.getBytes();
        byte[] result = null;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            Character ch = new Character(c);
            String s = ch.toString();
            if (s.getBytes()[0] < 0) {
                result = LMBCSUtil.concatenate(result, groupId);
            }
            result = LMBCSUtil.concatenate(result, s.getBytes());
        }
        return result;
    }

    public static byte[] getLMBCSUnicodeGroupBytes(String input) {
        byte[] unicodeGroupId = new byte[]{Byte.decode(ULMBCS_GRP_UNICODE)};
        String s = null;
        byte[] unicodeBytes = null;
        byte[] LMBCSBytes = null;
        for (int i = 0; i < input.length(); ++i) {
            s = new Character(input.charAt(i)).toString();
            try {
                unicodeBytes = s.getBytes("Unicode");
                byte highByte = unicodeBytes[2];
                byte lowByte = unicodeBytes[3];
                if (highByte == 0) {
                    LMBCSBytes = LMBCSUtil.concatenate(LMBCSBytes, new byte[]{lowByte});
                    continue;
                }
                LMBCSBytes = LMBCSUtil.concatenate(LMBCSBytes, unicodeGroupId);
                LMBCSBytes = LMBCSUtil.concatenate(LMBCSBytes, new byte[]{highByte});
                LMBCSBytes = LMBCSUtil.concatenate(LMBCSBytes, new byte[]{lowByte});
                continue;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return LMBCSBytes;
    }

    public static byte[] concatenate(byte[] a, byte[] b) {
        if (a == null) {
            return b;
        }
        byte[] bytes = new byte[a.length + b.length];
        System.arraycopy(a, 0, bytes, 0, a.length);
        System.arraycopy(b, 0, bytes, a.length, b.length);
        return bytes;
    }

    static {
        groupMap.put(new Locale("ar", ""), ULMBCS_GRP_AR);
        groupMap.put(new Locale("be", ""), ULMBCS_GRP_RU);
        groupMap.put(new Locale("bg", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("cs", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("el", ""), ULMBCS_GRP_GR);
        groupMap.put(new Locale("he", ""), ULMBCS_GRP_HE);
        groupMap.put(new Locale("hu", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("iw", ""), ULMBCS_GRP_HE);
        groupMap.put(new Locale("ja", ""), ULMBCS_GRP_JA);
        groupMap.put(new Locale("ko", ""), ULMBCS_GRP_KO);
        groupMap.put(new Locale("mk", ""), ULMBCS_GRP_RU);
        groupMap.put(new Locale("pl", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("ro", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("ru", ""), ULMBCS_GRP_RU);
        groupMap.put(new Locale("sh", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("sk", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("sl", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("sq", ""), ULMBCS_GRP_L2);
        groupMap.put(new Locale("sr", ""), ULMBCS_GRP_RU);
        groupMap.put(new Locale("th", ""), ULMBCS_GRP_TH);
        groupMap.put(new Locale("tr", ""), ULMBCS_GRP_TR);
        groupMap.put(new Locale("uk", ""), ULMBCS_GRP_RU);
        groupMap.put(new Locale("zh", "TW"), ULMBCS_GRP_TW);
        groupMap.put(new Locale("zh", "HK"), ULMBCS_GRP_TW);
        groupMap.put(new Locale("zh", ""), ULMBCS_GRP_CN);
        groupMap.put(new Locale("zh", "CN"), ULMBCS_GRP_CN);
    }
}

