/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.api;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.ImmutableDecimal;
import org.decimal4j.api.MutableDecimal;
import org.decimal4j.factory.DecimalFactory;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.truncate.OverflowMode;
import org.decimal4j.truncate.TruncationPolicy;

public interface Decimal<S extends ScaleMetrics>
extends Comparable<Decimal<S>> {
    public S getScaleMetrics();

    public int getScale();

    public long unscaledValue();

    public DecimalFactory<S> getFactory();

    public Decimal<S> integralPart();

    public Decimal<S> fractionalPart();

    public byte byteValue();

    public byte byteValueExact();

    public short shortValue();

    public short shortValueExact();

    public int intValue();

    public int intValueExact();

    public long longValue();

    public long longValueExact();

    public float floatValue();

    public double doubleValue();

    public BigInteger toBigInteger();

    public BigInteger toBigIntegerExact();

    public BigDecimal toBigDecimal();

    public ImmutableDecimal<S> toImmutableDecimal();

    public MutableDecimal<S> toMutableDecimal();

    public long longValue(RoundingMode var1);

    public float floatValue(RoundingMode var1);

    public double doubleValue(RoundingMode var1);

    public BigInteger toBigInteger(RoundingMode var1);

    public BigDecimal toBigDecimal(int var1, RoundingMode var2);

    public Decimal<S> round(int var1);

    public Decimal<S> round(int var1, RoundingMode var2);

    public Decimal<S> round(int var1, TruncationPolicy var2);

    public Decimal<?> scale(int var1);

    public <S extends ScaleMetrics> Decimal<S> scale(S var1);

    public Decimal<?> scale(int var1, RoundingMode var2);

    public <S extends ScaleMetrics> Decimal<S> scale(S var1, RoundingMode var2);

    public Decimal<S> add(Decimal<S> var1);

    public Decimal<S> add(Decimal<S> var1, OverflowMode var2);

    public Decimal<S> add(Decimal<?> var1, RoundingMode var2);

    public Decimal<S> add(Decimal<?> var1, TruncationPolicy var2);

    public Decimal<S> add(long var1);

    public Decimal<S> add(long var1, OverflowMode var3);

    public Decimal<S> add(double var1);

    public Decimal<S> add(double var1, RoundingMode var3);

    public Decimal<S> addUnscaled(long var1);

    public Decimal<S> addUnscaled(long var1, OverflowMode var3);

    public Decimal<S> addUnscaled(long var1, int var3);

    public Decimal<S> addUnscaled(long var1, int var3, RoundingMode var4);

    public Decimal<S> addUnscaled(long var1, int var3, TruncationPolicy var4);

    public Decimal<S> addSquared(Decimal<S> var1);

    public Decimal<S> addSquared(Decimal<S> var1, RoundingMode var2);

    public Decimal<S> addSquared(Decimal<S> var1, TruncationPolicy var2);

    public Decimal<S> subtract(Decimal<S> var1);

    public Decimal<S> subtract(Decimal<S> var1, OverflowMode var2);

    public Decimal<S> subtract(Decimal<?> var1, RoundingMode var2);

    public Decimal<S> subtract(Decimal<?> var1, TruncationPolicy var2);

    public Decimal<S> subtract(long var1);

    public Decimal<S> subtract(long var1, OverflowMode var3);

    public Decimal<S> subtract(double var1);

    public Decimal<S> subtract(double var1, RoundingMode var3);

    public Decimal<S> subtractUnscaled(long var1);

    public Decimal<S> subtractUnscaled(long var1, OverflowMode var3);

    public Decimal<S> subtractUnscaled(long var1, int var3);

    public Decimal<S> subtractUnscaled(long var1, int var3, RoundingMode var4);

    public Decimal<S> subtractUnscaled(long var1, int var3, TruncationPolicy var4);

    public Decimal<S> subtractSquared(Decimal<S> var1);

    public Decimal<S> subtractSquared(Decimal<S> var1, RoundingMode var2);

    public Decimal<S> subtractSquared(Decimal<S> var1, TruncationPolicy var2);

    public Decimal<S> multiply(Decimal<S> var1);

    public Decimal<S> multiply(Decimal<S> var1, RoundingMode var2);

    public Decimal<S> multiply(Decimal<S> var1, TruncationPolicy var2);

    public Decimal<S> multiplyBy(Decimal<?> var1);

    public Decimal<S> multiplyBy(Decimal<?> var1, RoundingMode var2);

    public Decimal<S> multiplyBy(Decimal<?> var1, TruncationPolicy var2);

    public Decimal<?> multiplyExact(Decimal<?> var1);

    public Decimal<S> multiply(long var1);

    public Decimal<S> multiply(long var1, OverflowMode var3);

    public Decimal<S> multiply(double var1);

    public Decimal<S> multiply(double var1, RoundingMode var3);

    public Decimal<S> multiplyUnscaled(long var1);

    public Decimal<S> multiplyUnscaled(long var1, RoundingMode var3);

    public Decimal<S> multiplyUnscaled(long var1, TruncationPolicy var3);

    public Decimal<S> multiplyUnscaled(long var1, int var3);

    public Decimal<S> multiplyUnscaled(long var1, int var3, RoundingMode var4);

    public Decimal<S> multiplyUnscaled(long var1, int var3, TruncationPolicy var4);

    public Decimal<S> multiplyByPowerOfTen(int var1);

    public Decimal<S> multiplyByPowerOfTen(int var1, RoundingMode var2);

    public Decimal<S> multiplyByPowerOfTen(int var1, TruncationPolicy var2);

    public Decimal<S> divide(Decimal<S> var1);

    public Decimal<S> divide(Decimal<S> var1, RoundingMode var2);

    public Decimal<S> divide(Decimal<S> var1, TruncationPolicy var2);

    public Decimal<S> divideBy(Decimal<?> var1);

    public Decimal<S> divideBy(Decimal<?> var1, RoundingMode var2);

    public Decimal<S> divideBy(Decimal<?> var1, TruncationPolicy var2);

    public Decimal<S> divideTruncate(Decimal<S> var1);

    public Decimal<S> divideExact(Decimal<S> var1);

    public Decimal<S> divide(long var1);

    public Decimal<S> divide(long var1, RoundingMode var3);

    public Decimal<S> divide(long var1, TruncationPolicy var3);

    public Decimal<S> divide(double var1);

    public Decimal<S> divide(double var1, RoundingMode var3);

    public Decimal<S> divideUnscaled(long var1);

    public Decimal<S> divideUnscaled(long var1, RoundingMode var3);

    public Decimal<S> divideUnscaled(long var1, TruncationPolicy var3);

    public Decimal<S> divideUnscaled(long var1, int var3);

    public Decimal<S> divideUnscaled(long var1, int var3, RoundingMode var4);

    public Decimal<S> divideUnscaled(long var1, int var3, TruncationPolicy var4);

    public Decimal<S> divideByPowerOfTen(int var1);

    public Decimal<S> divideByPowerOfTen(int var1, RoundingMode var2);

    public Decimal<S> divideByPowerOfTen(int var1, TruncationPolicy var2);

    public Decimal<S> divideToIntegralValue(Decimal<S> var1);

    public Decimal<S> divideToIntegralValue(Decimal<S> var1, OverflowMode var2);

    public long divideToLongValue(Decimal<S> var1);

    public long divideToLongValue(Decimal<S> var1, OverflowMode var2);

    public Decimal<S>[] divideAndRemainder(Decimal<S> var1);

    public Decimal<S>[] divideAndRemainder(Decimal<S> var1, OverflowMode var2);

    public Decimal<S> remainder(Decimal<S> var1);

    public Decimal<S> negate();

    public Decimal<S> negate(OverflowMode var1);

    public Decimal<S> abs();

    public Decimal<S> abs(OverflowMode var1);

    public Decimal<S> invert();

    public Decimal<S> invert(RoundingMode var1);

    public Decimal<S> invert(TruncationPolicy var1);

    public Decimal<S> square();

    public Decimal<S> square(RoundingMode var1);

    public Decimal<S> square(TruncationPolicy var1);

    public Decimal<S> sqrt();

    public Decimal<S> sqrt(RoundingMode var1);

    public int signum();

    public Decimal<S> shiftLeft(int var1);

    public Decimal<S> shiftLeft(int var1, RoundingMode var2);

    public Decimal<S> shiftLeft(int var1, TruncationPolicy var2);

    public Decimal<S> shiftRight(int var1);

    public Decimal<S> shiftRight(int var1, RoundingMode var2);

    public Decimal<S> shiftRight(int var1, TruncationPolicy var2);

    public Decimal<S> pow(int var1);

    public Decimal<S> pow(int var1, RoundingMode var2);

    public Decimal<S> pow(int var1, TruncationPolicy var2);

    @Override
    public int compareTo(Decimal<S> var1);

    public boolean isEqualTo(Decimal<S> var1);

    public boolean isGreaterThan(Decimal<S> var1);

    public boolean isGreaterThanOrEqualTo(Decimal<S> var1);

    public boolean isLessThan(Decimal<S> var1);

    public boolean isLessThanOrEqualTo(Decimal<S> var1);

    public Decimal<S> min(Decimal<S> var1);

    public Decimal<S> max(Decimal<S> var1);

    public Decimal<S> avg(Decimal<S> var1);

    public Decimal<S> avg(Decimal<S> var1, RoundingMode var2);

    public boolean isZero();

    public boolean isOne();

    public boolean isMinusOne();

    public boolean isUlp();

    public boolean isPositive();

    public boolean isNonNegative();

    public boolean isNegative();

    public boolean isNonPositive();

    public boolean isIntegral();

    public boolean isIntegralPartZero();

    public boolean isBetweenZeroAndOne();

    public boolean isBetweenZeroAndMinusOne();

    public int compareToNumerically(Decimal<?> var1);

    public boolean isEqualToNumerically(Decimal<?> var1);

    public int hashCode();

    public boolean equals(Object var1);

    public String toString();
}

