/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.api;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.truncate.OverflowMode;
import org.decimal4j.truncate.TruncationPolicy;

public interface DecimalArithmetic {
    public int getScale();

    public ScaleMetrics getScaleMetrics();

    public RoundingMode getRoundingMode();

    public OverflowMode getOverflowMode();

    public TruncationPolicy getTruncationPolicy();

    public DecimalArithmetic deriveArithmetic(int var1);

    public DecimalArithmetic deriveArithmetic(RoundingMode var1);

    public DecimalArithmetic deriveArithmetic(RoundingMode var1, OverflowMode var2);

    public DecimalArithmetic deriveArithmetic(OverflowMode var1);

    public DecimalArithmetic deriveArithmetic(TruncationPolicy var1);

    public long one();

    public int signum(long var1);

    public int compare(long var1, long var3);

    public int compareToUnscaled(long var1, long var3, int var5);

    public long add(long var1, long var3);

    public long addLong(long var1, long var3);

    public long addUnscaled(long var1, long var3, int var5);

    public long subtract(long var1, long var3);

    public long subtractLong(long var1, long var3);

    public long subtractUnscaled(long var1, long var3, int var5);

    public long multiply(long var1, long var3);

    public long multiplyByLong(long var1, long var3);

    public long multiplyByUnscaled(long var1, long var3, int var5);

    public long multiplyByPowerOf10(long var1, int var3);

    public long divide(long var1, long var3);

    public long divideByLong(long var1, long var3);

    public long divideByUnscaled(long var1, long var3, int var5);

    public long divideByPowerOf10(long var1, int var3);

    public long avg(long var1, long var3);

    public long abs(long var1);

    public long negate(long var1);

    public long invert(long var1);

    public long square(long var1);

    public long sqrt(long var1);

    public long pow(long var1, int var3);

    public long shiftLeft(long var1, int var3);

    public long shiftRight(long var1, int var3);

    public long round(long var1, int var3);

    public long fromLong(long var1);

    public long fromFloat(float var1);

    public long fromDouble(double var1);

    public long fromBigInteger(BigInteger var1);

    public long fromBigDecimal(BigDecimal var1);

    public long fromUnscaled(long var1, int var3);

    public long parse(String var1);

    public long parse(CharSequence var1, int var2, int var3);

    public long toLong(long var1);

    public long toUnscaled(long var1, int var3);

    public float toFloat(long var1);

    public double toDouble(long var1);

    public BigDecimal toBigDecimal(long var1);

    public BigDecimal toBigDecimal(long var1, int var3);

    public String toString(long var1);

    public void toString(long var1, Appendable var3) throws IOException;
}

