/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.api.DecimalArithmetic;
import org.decimal4j.arithmetic.BigDecimalConversion;
import org.decimal4j.arithmetic.BigIntegerConversion;
import org.decimal4j.arithmetic.Compare;
import org.decimal4j.scale.Scales;
import org.decimal4j.truncate.OverflowMode;
import org.decimal4j.truncate.TruncationPolicy;

public abstract class AbstractArithmetic
implements DecimalArithmetic {
    @Override
    public final DecimalArithmetic deriveArithmetic(int scale) {
        if (scale != this.getScale()) {
            return Scales.getScaleMetrics(scale).getArithmetic(this.getTruncationPolicy());
        }
        return this;
    }

    @Override
    public final DecimalArithmetic deriveArithmetic(RoundingMode roundingMode) {
        return this.deriveArithmetic(roundingMode, this.getOverflowMode());
    }

    @Override
    public final DecimalArithmetic deriveArithmetic(RoundingMode roundingMode, OverflowMode overflowMode) {
        if (roundingMode != this.getRoundingMode() | overflowMode != this.getOverflowMode()) {
            return overflowMode.isChecked() ? this.getScaleMetrics().getCheckedArithmetic(roundingMode) : this.getScaleMetrics().getArithmetic(roundingMode);
        }
        return this;
    }

    @Override
    public final DecimalArithmetic deriveArithmetic(OverflowMode overflowMode) {
        return this.deriveArithmetic(this.getRoundingMode(), overflowMode);
    }

    @Override
    public final DecimalArithmetic deriveArithmetic(TruncationPolicy truncationPolicy) {
        return this.deriveArithmetic(truncationPolicy.getRoundingMode(), truncationPolicy.getOverflowMode());
    }

    @Override
    public final int signum(long uDecimal) {
        return Long.signum(uDecimal);
    }

    @Override
    public final int compare(long uDecimal1, long uDecimal2) {
        return Long.compare(uDecimal1, uDecimal2);
    }

    @Override
    public final int compareToUnscaled(long uDecimal, long unscaled, int scale) {
        return Compare.compareUnscaled(uDecimal, this.getScale(), unscaled, scale);
    }

    @Override
    public final long fromBigInteger(BigInteger value) {
        return BigIntegerConversion.bigIntegerToUnscaled(this.getScaleMetrics(), value);
    }

    @Override
    public final BigDecimal toBigDecimal(long uDecimal) {
        return BigDecimalConversion.unscaledToBigDecimal(this.getScaleMetrics(), uDecimal);
    }

    @Override
    public final BigDecimal toBigDecimal(long uDecimal, int scale) {
        return BigDecimalConversion.unscaledToBigDecimal(this.getScaleMetrics(), this.getRoundingMode(), uDecimal, scale);
    }
}

