/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;

final class BigDecimalConversion {
    public static final long bigDecimalToLong(RoundingMode roundingMode, BigDecimal value) {
        BigInteger scaled = value.setScale(0, roundingMode).toBigInteger();
        if (scaled.bitLength() <= 63) {
            return scaled.longValue();
        }
        throw new IllegalArgumentException("Overflow: cannot convert " + value + " to long");
    }

    public static final long bigDecimalToUnscaled(ScaleMetrics scaleMetrics, RoundingMode roundingMode, BigDecimal value) {
        BigInteger scaled = value.multiply(scaleMetrics.getScaleFactorAsBigDecimal()).setScale(0, roundingMode).toBigInteger();
        if (scaled.bitLength() <= 63) {
            return scaled.longValue();
        }
        throw new IllegalArgumentException("Overflow: cannot convert " + value + " to Decimal with scale " + scaleMetrics.getScale());
    }

    public static final BigDecimal unscaledToBigDecimal(ScaleMetrics scaleMetrics, long uDecimal) {
        return BigDecimal.valueOf(uDecimal, scaleMetrics.getScale());
    }

    public static final BigDecimal unscaledToBigDecimal(ScaleMetrics scaleMetrics, RoundingMode roundingMode, long uDecimal, int targetScale) {
        int sourceScale = scaleMetrics.getScale();
        if (targetScale == sourceScale) {
            return BigDecimalConversion.unscaledToBigDecimal(scaleMetrics, uDecimal);
        }
        if (targetScale < sourceScale) {
            int diff = sourceScale - targetScale;
            if (diff <= 18) {
                ScaleMetrics diffMetrics = Scales.getScaleMetrics(diff);
                long rescaled = diffMetrics.getArithmetic(roundingMode).divideByPowerOf10(uDecimal, diff);
                return BigDecimal.valueOf(rescaled, targetScale);
            }
        } else {
            ScaleMetrics diffMetrics;
            int diff = targetScale - sourceScale;
            if (diff <= 18 && (diffMetrics = Scales.getScaleMetrics(diff)).isValidIntegerValue(uDecimal)) {
                long rescaled = diffMetrics.multiplyByScaleFactor(uDecimal);
                return BigDecimal.valueOf(rescaled, targetScale);
            }
        }
        return BigDecimal.valueOf(uDecimal, sourceScale).setScale(targetScale, roundingMode);
    }

    private BigDecimalConversion() {
    }
}

