/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.api.DecimalArithmetic;

final class Checked {
    static final boolean isAddOverflow(long long1, long long2, long result) {
        return (long1 ^ long2) >= 0L & (long1 ^ result) < 0L;
    }

    static final boolean isSubtractOverflow(long minuend, long subtrahend, long result) {
        return (minuend ^ subtrahend) < 0L & (minuend ^ result) < 0L;
    }

    static final boolean isDivideOverflow(long dividend, long divisor) {
        return dividend == Long.MIN_VALUE & divisor == -1L;
    }

    public static final long addLong(long long1, long long2) {
        long result = long1 + long2;
        if (Checked.isAddOverflow(long1, long2, result)) {
            throw new ArithmeticException("Overflow: " + long1 + " + " + long2 + " = " + result);
        }
        return result;
    }

    public static final long add(DecimalArithmetic arith, long uDecimal1, long uDecimal2) {
        long result;
        if ((uDecimal1 ^ uDecimal2) >= 0L & (uDecimal1 ^ (result = uDecimal1 + uDecimal2)) < 0L) {
            throw new ArithmeticException("Overflow: " + arith.toString(uDecimal1) + " + " + arith.toString(uDecimal2) + " = " + arith.toString(result));
        }
        return result;
    }

    public static final long subtractLong(long lMinuend, long lSubtrahend) {
        long result = lMinuend - lSubtrahend;
        if (Checked.isSubtractOverflow(lMinuend, lSubtrahend, result)) {
            throw new ArithmeticException("Overflow: " + lMinuend + " - " + lSubtrahend + " = " + result);
        }
        return result;
    }

    public static final long subtract(DecimalArithmetic arith, long uDecimalMinuend, long uDecimalSubtrahend) {
        long result = uDecimalMinuend - uDecimalSubtrahend;
        if (Checked.isSubtractOverflow(uDecimalMinuend, uDecimalSubtrahend, result)) {
            throw new ArithmeticException("Overflow: " + arith.toString(uDecimalMinuend) + " - " + arith.toString(uDecimalSubtrahend) + " = " + arith.toString(result));
        }
        return result;
    }

    public static final long multiplyLong(long lValue1, long lValue2) {
        int leadingZeros = Long.numberOfLeadingZeros(lValue1) + Long.numberOfLeadingZeros(lValue1 ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(lValue2) + Long.numberOfLeadingZeros(lValue2 ^ 0xFFFFFFFFFFFFFFFFL);
        long result = lValue1 * lValue2;
        if (leadingZeros > 65) {
            return result;
        }
        if (leadingZeros < 64 || lValue1 < 0L & lValue2 == Long.MIN_VALUE || lValue1 != 0L && result / lValue1 != lValue2) {
            throw new ArithmeticException("Overflow: " + lValue1 + " * " + lValue2 + " = " + result);
        }
        return result;
    }

    public static final long multiplyByLong(DecimalArithmetic arith, long uDecimal, long lValue) {
        int leadingZeros = Long.numberOfLeadingZeros(uDecimal) + Long.numberOfLeadingZeros(uDecimal ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(lValue) + Long.numberOfLeadingZeros(lValue ^ 0xFFFFFFFFFFFFFFFFL);
        long result = uDecimal * lValue;
        if (leadingZeros > 65) {
            return result;
        }
        if (leadingZeros < 64 || uDecimal < 0L & lValue == Long.MIN_VALUE || uDecimal != 0L && result / uDecimal != lValue) {
            throw new ArithmeticException("Overflow: " + arith.toString(uDecimal) + " * " + lValue + " = " + arith.toString(result));
        }
        return result;
    }

    public static final long divideLong(long lDividend, long lDivisor) {
        if (lDivisor == -1L & lDividend == Long.MIN_VALUE) {
            throw new ArithmeticException("Overflow: " + lDividend + " / " + lDivisor + " = " + Long.MIN_VALUE);
        }
        return lDividend / lDivisor;
    }

    public static final long divideByLong(DecimalArithmetic arith, long uDecimalDividend, long lDivisor) {
        if (lDivisor == 0L) {
            throw new ArithmeticException("Division by zero: " + arith.toString(uDecimalDividend) + " / " + lDivisor);
        }
        if (lDivisor == -1L & uDecimalDividend == Long.MIN_VALUE) {
            throw new ArithmeticException("Overflow: " + arith.toString(uDecimalDividend) + " / " + lDivisor + " = " + arith.toString(Long.MIN_VALUE));
        }
        return uDecimalDividend / lDivisor;
    }

    public static final long abs(DecimalArithmetic arith, long value) {
        long abs = Math.abs(value);
        if (abs < 0L) {
            throw new ArithmeticException("Overflow: abs(" + arith.toString(value) + ") = " + abs);
        }
        return abs;
    }

    public static final long negate(DecimalArithmetic arith, long value) {
        long neg;
        if (value != 0L & (value ^ (neg = -value)) >= 0L) {
            throw new ArithmeticException("Overflow: -" + arith.toString(value) + " = " + neg);
        }
        return neg;
    }

    private Checked() {
    }
}

