/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.decimal4j.arithmetic.AbstractCheckedScale0fArithmetic;
import org.decimal4j.arithmetic.Add;
import org.decimal4j.arithmetic.Avg;
import org.decimal4j.arithmetic.BigDecimalConversion;
import org.decimal4j.arithmetic.Div;
import org.decimal4j.arithmetic.DoubleConversion;
import org.decimal4j.arithmetic.FloatConversion;
import org.decimal4j.arithmetic.Invert;
import org.decimal4j.arithmetic.Mul;
import org.decimal4j.arithmetic.Pow;
import org.decimal4j.arithmetic.Pow10;
import org.decimal4j.arithmetic.Round;
import org.decimal4j.arithmetic.Shift;
import org.decimal4j.arithmetic.Sqrt;
import org.decimal4j.arithmetic.StringConversion;
import org.decimal4j.arithmetic.Sub;
import org.decimal4j.arithmetic.UnscaledConversion;
import org.decimal4j.truncate.CheckedRounding;
import org.decimal4j.truncate.DecimalRounding;

public final class CheckedScale0fRoundingArithmetic
extends AbstractCheckedScale0fArithmetic {
    private final DecimalRounding rounding;

    public CheckedScale0fRoundingArithmetic(RoundingMode roundingMode) {
        this(DecimalRounding.valueOf(roundingMode));
    }

    public CheckedScale0fRoundingArithmetic(DecimalRounding rounding) {
        this.rounding = rounding;
    }

    @Override
    public final RoundingMode getRoundingMode() {
        return this.rounding.getRoundingMode();
    }

    @Override
    public final CheckedRounding getTruncationPolicy() {
        return CheckedRounding.valueOf(this.getRoundingMode());
    }

    @Override
    public final long addUnscaled(long uDecimal, long unscaled, int scale) {
        return Add.addUnscaledUnscaledChecked(this, this.rounding, uDecimal, unscaled, scale);
    }

    @Override
    public final long subtractUnscaled(long uDecimal, long unscaled, int scale) {
        return Sub.subtractUnscaledUnscaledChecked(this, this.rounding, uDecimal, unscaled, scale);
    }

    @Override
    public final long multiplyByUnscaled(long uDecimal, long unscaled, int scale) {
        return Mul.multiplyByUnscaledChecked(this, this.rounding, uDecimal, unscaled, scale);
    }

    @Override
    public final long divideByUnscaled(long uDecimal, long unscaled, int scale) {
        return Div.divideByUnscaledChecked(this, this.rounding, uDecimal, unscaled, scale);
    }

    @Override
    public final long divide(long uDecimalDividend, long uDecimalDivisor) {
        return Div.divideChecked(this, this.rounding, uDecimalDividend, uDecimalDivisor);
    }

    @Override
    public final long multiplyByPowerOf10(long uDecimal, int n) {
        return Pow10.multiplyByPowerOf10Checked(this, this.rounding, uDecimal, n);
    }

    @Override
    public final long divideByLong(long uDecimalDividend, long lDivisor) {
        return Div.divideByLongChecked(this, this.rounding, uDecimalDividend, lDivisor);
    }

    @Override
    public final long divideByPowerOf10(long uDecimal, int n) {
        return Pow10.divideByPowerOf10Checked(this, this.rounding, uDecimal, n);
    }

    @Override
    public final long avg(long uDecimal1, long uDecimal2) {
        return Avg.avg(this, this.rounding, uDecimal1, uDecimal2);
    }

    @Override
    public final long invert(long uDecimal) {
        return Invert.invertLong(this.rounding, uDecimal);
    }

    @Override
    public final long sqrt(long uDecimal) {
        return Sqrt.sqrtLong(this.rounding, uDecimal);
    }

    @Override
    public final long pow(long uDecimalBase, int exponent) {
        return Pow.powLongChecked(this, this.rounding, uDecimalBase, exponent);
    }

    @Override
    public final long round(long uDecimal, int precision) {
        return Round.round(this, this.rounding, uDecimal, precision);
    }

    @Override
    public final long shiftLeft(long uDecimal, int n) {
        return Shift.shiftLeftChecked(this, this.rounding, uDecimal, n);
    }

    @Override
    public final long shiftRight(long uDecimal, int n) {
        return Shift.shiftRightChecked(this, this.rounding, uDecimal, n);
    }

    @Override
    public final float toFloat(long uDecimal) {
        return FloatConversion.longToFloat(this, this.rounding, uDecimal);
    }

    @Override
    public final double toDouble(long uDecimal) {
        return DoubleConversion.longToDouble(this, this.rounding, uDecimal);
    }

    @Override
    public final long toUnscaled(long uDecimal, int scale) {
        return UnscaledConversion.unscaledToUnscaled(this.rounding, scale, this, uDecimal);
    }

    @Override
    public final long fromFloat(float value) {
        return FloatConversion.floatToLong(this.rounding, value);
    }

    @Override
    public final long fromDouble(double value) {
        return DoubleConversion.doubleToLong(this.rounding, value);
    }

    @Override
    public final long fromUnscaled(long unscaledValue, int scale) {
        return UnscaledConversion.unscaledToLong(this, this.rounding, unscaledValue, scale);
    }

    @Override
    public final long fromBigDecimal(BigDecimal value) {
        return BigDecimalConversion.bigDecimalToLong(this.getRoundingMode(), value);
    }

    @Override
    public final long parse(String value) {
        return StringConversion.parseLong(this, this.rounding, value, 0, value.length());
    }

    @Override
    public final long parse(CharSequence value, int start, int end) {
        return StringConversion.parseLong(this, this.rounding, value, start, end);
    }
}

