/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.decimal4j.arithmetic.AbstractCheckedScale0fArithmetic;
import org.decimal4j.arithmetic.Add;
import org.decimal4j.arithmetic.Avg;
import org.decimal4j.arithmetic.BigDecimalConversion;
import org.decimal4j.arithmetic.Checked;
import org.decimal4j.arithmetic.Div;
import org.decimal4j.arithmetic.DoubleConversion;
import org.decimal4j.arithmetic.FloatConversion;
import org.decimal4j.arithmetic.Invert;
import org.decimal4j.arithmetic.Mul;
import org.decimal4j.arithmetic.Pow;
import org.decimal4j.arithmetic.Pow10;
import org.decimal4j.arithmetic.Round;
import org.decimal4j.arithmetic.Shift;
import org.decimal4j.arithmetic.Sqrt;
import org.decimal4j.arithmetic.StringConversion;
import org.decimal4j.arithmetic.Sub;
import org.decimal4j.arithmetic.UnscaledConversion;
import org.decimal4j.truncate.CheckedRounding;
import org.decimal4j.truncate.DecimalRounding;

public final class CheckedScale0fTruncatingArithmetic
extends AbstractCheckedScale0fArithmetic {
    public static final CheckedScale0fTruncatingArithmetic INSTANCE = new CheckedScale0fTruncatingArithmetic();

    @Override
    public final RoundingMode getRoundingMode() {
        return RoundingMode.DOWN;
    }

    @Override
    public final CheckedRounding getTruncationPolicy() {
        return CheckedRounding.DOWN;
    }

    @Override
    public final long addUnscaled(long uDecimal, long unscaled, int scale) {
        return Add.addUnscaledUnscaledChecked(this, uDecimal, unscaled, scale);
    }

    @Override
    public final long subtractUnscaled(long uDecimal, long unscaled, int scale) {
        return Sub.subtractUnscaledUnscaledChecked(this, uDecimal, unscaled, scale);
    }

    @Override
    public final long multiplyByUnscaled(long uDecimal, long unscaled, int scale) {
        return Mul.multiplyByUnscaledChecked(this, uDecimal, unscaled, scale);
    }

    @Override
    public final long divideByUnscaled(long uDecimal, long unscaled, int scale) {
        return Div.divideByUnscaledChecked(this, uDecimal, unscaled, scale);
    }

    @Override
    public final long divide(long uDecimalDividend, long uDecimalDivisor) {
        return Checked.divideByLong(this, uDecimalDividend, uDecimalDivisor);
    }

    @Override
    public final long divideByLong(long uDecimalDividend, long lDivisor) {
        return Checked.divideByLong(this, uDecimalDividend, lDivisor);
    }

    @Override
    public final long avg(long a, long b) {
        return Avg.avg(a, b);
    }

    @Override
    public final long invert(long uDecimal) {
        return Invert.invertLong(uDecimal);
    }

    @Override
    public final long pow(long uDecimalBase, int exponent) {
        return Pow.powLongChecked(this, DecimalRounding.DOWN, uDecimalBase, exponent);
    }

    @Override
    public final long sqrt(long uDecimal) {
        return Sqrt.sqrtLong(uDecimal);
    }

    @Override
    public final long divideByPowerOf10(long uDecimal, int n) {
        return Pow10.divideByPowerOf10Checked(this, uDecimal, n);
    }

    @Override
    public final long multiplyByPowerOf10(long uDecimal, int n) {
        return Pow10.multiplyByPowerOf10Checked(this, uDecimal, n);
    }

    @Override
    public final long shiftLeft(long uDecimal, int positions) {
        return Shift.shiftLeftChecked(this, DecimalRounding.DOWN, uDecimal, positions);
    }

    @Override
    public final long shiftRight(long uDecimal, int positions) {
        return Shift.shiftRightChecked(this, DecimalRounding.DOWN, uDecimal, positions);
    }

    @Override
    public final long round(long uDecimal, int precision) {
        return Round.round(this, uDecimal, precision);
    }

    @Override
    public final float toFloat(long uDecimal) {
        return FloatConversion.longToFloat(this, uDecimal);
    }

    @Override
    public final double toDouble(long uDecimal) {
        return DoubleConversion.longToDouble(this, uDecimal);
    }

    @Override
    public final long toUnscaled(long uDecimal, int scale) {
        return UnscaledConversion.unscaledToUnscaled(scale, this, uDecimal);
    }

    @Override
    public final long fromFloat(float value) {
        return FloatConversion.floatToLong(value);
    }

    @Override
    public final long fromDouble(double value) {
        return DoubleConversion.doubleToLong(value);
    }

    @Override
    public final long fromUnscaled(long unscaledValue, int scale) {
        return UnscaledConversion.unscaledToLong(this, unscaledValue, scale);
    }

    @Override
    public final long fromBigDecimal(BigDecimal value) {
        return BigDecimalConversion.bigDecimalToLong(RoundingMode.DOWN, value);
    }

    @Override
    public final long parse(String value) {
        return StringConversion.parseLong(this, DecimalRounding.DOWN, value, 0, value.length());
    }

    @Override
    public final long parse(CharSequence value, int start, int end) {
        return StringConversion.parseLong(this, DecimalRounding.DOWN, value, start, end);
    }
}

