/*
 * Decompiled with CFR 0.152.
 */
package org.decimal4j.arithmetic;

import org.decimal4j.scale.ScaleMetrics;
import org.decimal4j.scale.Scales;

final class Compare {
    public static final int compareUnscaled(long unscaled, int scale, long otherUnscaled, int otherScale) {
        if (scale == otherScale) {
            return Long.compare(unscaled, otherUnscaled);
        }
        if (scale < otherScale) {
            ScaleMetrics diffMetrics = Scales.getScaleMetrics(otherScale - scale);
            long otherRescaled = diffMetrics.divideByScaleFactor(otherUnscaled);
            int cmp = Long.compare(unscaled, otherRescaled);
            if (cmp != 0) {
                return cmp;
            }
            long otherRemainder = otherUnscaled - diffMetrics.multiplyByScaleFactor(otherRescaled);
            return -Long.signum(otherRemainder);
        }
        ScaleMetrics diffMetrics = Scales.getScaleMetrics(scale - otherScale);
        long rescaled = diffMetrics.divideByScaleFactor(unscaled);
        int cmp = Long.compare(rescaled, otherUnscaled);
        if (cmp != 0) {
            return cmp;
        }
        long remainder = unscaled - diffMetrics.multiplyByScaleFactor(rescaled);
        return Long.signum(remainder);
    }

    private Compare() {
    }
}

